/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.io.Serializable;
import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Derivative1;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.hipparchus.util.SinhCosh;

public class Gradient
implements Derivative1<Gradient>,
Serializable {
    private static final long serialVersionUID = 20200520L;
    private final double value;
    private final double[] grad;

    private Gradient(double value, int freeParameters) {
        this.value = value;
        this.grad = new double[freeParameters];
    }

    private Gradient(double[] gradient, double value) {
        this.value = value;
        this.grad = gradient;
    }

    public Gradient(double value, double ... gradient) {
        this(value, gradient.length);
        System.arraycopy(gradient, 0, this.grad, 0, this.grad.length);
    }

    public Gradient(DerivativeStructure ds) throws MathIllegalArgumentException {
        this(ds.getValue(), ds.getFreeParameters());
        MathUtils.checkDimension(ds.getOrder(), 1);
        System.arraycopy(ds.getAllDerivatives(), 1, this.grad, 0, this.grad.length);
    }

    public static Gradient constant(int freeParameters, double value) {
        return new Gradient(value, freeParameters);
    }

    public static Gradient variable(int freeParameters, int index, double value) {
        Gradient g = new Gradient(value, freeParameters);
        g.grad[index] = 1.0;
        return g;
    }

    @Override
    public Gradient newInstance(double c) {
        return new Gradient(c, new double[this.grad.length]);
    }

    @Override
    public Gradient withValue(double v) {
        return new Gradient(v, this.grad);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public double[] getGradient() {
        return (double[])this.grad.clone();
    }

    @Override
    public int getFreeParameters() {
        return this.grad.length;
    }

    @Override
    public double getPartialDerivative(int ... orders) throws MathIllegalArgumentException {
        if (orders.length != this.grad.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, orders.length, this.grad.length);
        }
        int selected = -1;
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] == 0) continue;
            if (selected >= 0 || orders[i] != 1) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DERIVATION_ORDER_NOT_ALLOWED, orders[i]);
            }
            selected = i;
        }
        return selected < 0 ? this.value : this.grad[selected];
    }

    public double getPartialDerivative(int n) throws MathIllegalArgumentException {
        if (n < 0 || n >= this.grad.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, n, 0, this.grad.length - 1);
        }
        return this.grad[n];
    }

    public DerivativeStructure toDerivativeStructure() {
        double[] derivatives = new double[1 + this.grad.length];
        derivatives[0] = this.value;
        System.arraycopy(this.grad, 0, derivatives, 1, this.grad.length);
        return this.getField().getConversionFactory().build(derivatives);
    }

    @Override
    public Gradient add(Gradient a) {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = this.grad[i] + a.grad[i];
        }
        return new Gradient(gradient, this.value + a.value);
    }

    @Override
    public Gradient subtract(Gradient a) {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = this.grad[i] - a.grad[i];
        }
        return new Gradient(gradient, this.value - a.value);
    }

    @Override
    public Gradient multiply(int n) {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = this.grad[i] * (double)n;
        }
        return new Gradient(gradient, this.value * (double)n);
    }

    @Override
    public Gradient multiply(double a) {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = this.grad[i] * a;
        }
        return new Gradient(gradient, this.value * a);
    }

    @Override
    public Gradient multiply(Gradient a) {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = this.grad[i] * a.value + this.value * a.grad[i];
        }
        return new Gradient(gradient, this.value * a.value);
    }

    @Override
    public Gradient divide(double a) {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = this.grad[i] / a;
        }
        return new Gradient(gradient, this.value / a);
    }

    @Override
    public Gradient divide(Gradient a) {
        double inv1 = 1.0 / a.value;
        double inv2 = inv1 * inv1;
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = (this.grad[i] * a.value - this.value * a.grad[i]) * inv2;
        }
        return new Gradient(gradient, this.value * inv1);
    }

    @Override
    public Gradient remainder(Gradient a) {
        double rem = FastMath.IEEEremainder(this.value, a.value);
        double k = FastMath.rint((this.value - rem) / a.value);
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = this.grad[i] - k * a.grad[i];
        }
        return new Gradient(gradient, rem);
    }

    @Override
    public Gradient negate() {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = -this.grad[i];
        }
        return new Gradient(gradient, -this.value);
    }

    @Override
    public Gradient abs() {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public Gradient copySign(Gradient sign) {
        long m = Double.doubleToLongBits(this.value);
        long s = Double.doubleToLongBits(sign.value);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public Gradient copySign(double sign) {
        long m = Double.doubleToLongBits(this.value);
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public Gradient scalb(int n) {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = FastMath.scalb(this.grad[i], n);
        }
        return new Gradient(gradient, FastMath.scalb(this.value, n));
    }

    @Override
    public Gradient hypot(Gradient y) {
        int expY;
        if (Double.isInfinite(this.value) || Double.isInfinite(y.value)) {
            return this.newInstance(Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.value) || Double.isNaN(y.value)) {
            return this.newInstance(Double.NaN);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        Gradient scaledX = this.scalb(-middleExp);
        Gradient scaledY = y.scalb(-middleExp);
        Gradient scaledH = (Gradient)scaledX.multiply(scaledX).add(scaledY.multiply(scaledY)).sqrt();
        return scaledH.scalb(middleExp);
    }

    @Override
    public Gradient compose(double ... f) {
        MathUtils.checkDimension(f.length, this.getOrder() + 1);
        return this.compose(f[0], f[1]);
    }

    @Override
    public Gradient compose(double f0, double f1) {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = f1 * this.grad[i];
        }
        return new Gradient(gradient, f0);
    }

    public GradientField getField() {
        return GradientField.getField(this.getFreeParameters());
    }

    public static Gradient pow(double a, Gradient x) {
        if (a == 0.0) {
            return x.getField().getZero();
        }
        double aX = FastMath.pow(a, x.value);
        double aXlnA = aX * FastMath.log(a);
        double[] gradient = new double[x.getFreeParameters()];
        for (int i = 0; i < gradient.length; ++i) {
            gradient[i] = aXlnA * x.grad[i];
        }
        return new Gradient(gradient, aX);
    }

    @Override
    public Gradient pow(double p) {
        if (p == 0.0) {
            return this.getField().getOne();
        }
        double valuePm1 = FastMath.pow(this.value, p - 1.0);
        return this.compose(valuePm1 * this.value, p * valuePm1);
    }

    @Override
    public Gradient pow(int n) {
        if (n == 0) {
            return this.getField().getOne();
        }
        double valueNm1 = FastMath.pow(this.value, n - 1);
        return this.compose(valueNm1 * this.value, (double)n * valueNm1);
    }

    @Override
    public FieldSinCos<Gradient> sinCos() {
        SinCos sinCos = FastMath.sinCos(this.value);
        double[] gradSin = new double[this.grad.length];
        double[] gradCos = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradSin[i] = this.grad[i] * sinCos.cos();
            gradCos[i] = -this.grad[i] * sinCos.sin();
        }
        Gradient sin = new Gradient(gradSin, sinCos.sin());
        Gradient cos = new Gradient(gradCos, sinCos.cos());
        return new FieldSinCos<Gradient>(sin, cos);
    }

    @Override
    public Gradient atan2(Gradient x) {
        double inv = 1.0 / (this.value * this.value + x.value * x.value);
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = (x.value * this.grad[i] - x.grad[i] * this.value) * inv;
        }
        return new Gradient(gradient, FastMath.atan2(this.value, x.value));
    }

    @Override
    public FieldSinhCosh<Gradient> sinhCosh() {
        SinhCosh sinhCosh = FastMath.sinhCosh(this.value);
        double[] gradSinh = new double[this.grad.length];
        double[] gradCosh = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradSinh[i] = this.grad[i] * sinhCosh.cosh();
            gradCosh[i] = this.grad[i] * sinhCosh.sinh();
        }
        Gradient sinh = new Gradient(gradSinh, sinhCosh.sinh());
        Gradient cosh = new Gradient(gradCosh, sinhCosh.cosh());
        return new FieldSinhCosh<Gradient>(sinh, cosh);
    }

    @Override
    public Gradient toDegrees() {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = FastMath.toDegrees(this.grad[i]);
        }
        return new Gradient(gradient, FastMath.toDegrees(this.value));
    }

    @Override
    public Gradient toRadians() {
        double[] gradient = new double[this.grad.length];
        for (int i = 0; i < this.grad.length; ++i) {
            gradient[i] = FastMath.toRadians(this.grad[i]);
        }
        return new Gradient(gradient, FastMath.toRadians(this.value));
    }

    public double taylor(double ... delta) {
        double result = this.value;
        for (int i = 0; i < this.grad.length; ++i) {
            result += delta[i] * this.grad[i];
        }
        return result;
    }

    public Gradient linearCombination(Gradient[] a, Gradient[] b) {
        int n = a.length;
        double[] a0 = new double[n];
        double[] b0 = new double[n];
        double[] a1 = new double[2 * n];
        double[] b1 = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            Gradient ai = a[i];
            Gradient bi = b[i];
            a0[i] = ai.value;
            b0[i] = bi.value;
            a1[2 * i] = ai.value;
            b1[2 * i + 1] = bi.value;
        }
        Gradient result = this.newInstance(MathArrays.linearCombination(a0, b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                a1[2 * i + 1] = a[i].grad[k];
                b1[2 * i] = b[i].grad[k];
            }
            result.grad[k] = MathArrays.linearCombination(a1, b1);
        }
        return result;
    }

    public Gradient linearCombination(double[] a, Gradient[] b) {
        int n = b.length;
        double[] b0 = new double[n];
        double[] b1 = new double[n];
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].value;
        }
        Gradient result = this.newInstance(MathArrays.linearCombination(a, b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                b1[i] = b[i].grad[k];
            }
            result.grad[k] = MathArrays.linearCombination(a, b1);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(Gradient a1, Gradient b1, Gradient a2, Gradient b2) {
        Gradient result = this.newInstance(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = MathArrays.linearCombination(a1.value, b1.grad[i], a1.grad[i], b1.value, a2.value, b2.grad[i], a2.grad[i], b2.value);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(double a1, Gradient b1, double a2, Gradient b2) {
        Gradient result = this.newInstance(MathArrays.linearCombination(a1, b1.value, a2, b2.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = MathArrays.linearCombination(a1, b1.grad[i], a2, b2.grad[i]);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(Gradient a1, Gradient b1, Gradient a2, Gradient b2, Gradient a3, Gradient b3) {
        double[] a = new double[]{a1.value, 0.0, a2.value, 0.0, a3.value, 0.0};
        double[] b = new double[]{0.0, b1.value, 0.0, b2.value, 0.0, b3.value};
        Gradient result = this.newInstance(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            a[1] = a1.grad[i];
            a[3] = a2.grad[i];
            a[5] = a3.grad[i];
            b[0] = b1.grad[i];
            b[2] = b2.grad[i];
            b[4] = b3.grad[i];
            result.grad[i] = MathArrays.linearCombination(a, b);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(double a1, Gradient b1, double a2, Gradient b2, double a3, Gradient b3) {
        Gradient result = this.newInstance(MathArrays.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = MathArrays.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i]);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(Gradient a1, Gradient b1, Gradient a2, Gradient b2, Gradient a3, Gradient b3, Gradient a4, Gradient b4) {
        double[] a = new double[]{a1.value, 0.0, a2.value, 0.0, a3.value, 0.0, a4.value, 0.0};
        double[] b = new double[]{0.0, b1.value, 0.0, b2.value, 0.0, b3.value, 0.0, b4.value};
        Gradient result = this.newInstance(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value, a4.value, b4.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            a[1] = a1.grad[i];
            a[3] = a2.grad[i];
            a[5] = a3.grad[i];
            a[7] = a4.grad[i];
            b[0] = b1.grad[i];
            b[2] = b2.grad[i];
            b[4] = b3.grad[i];
            b[6] = b4.grad[i];
            result.grad[i] = MathArrays.linearCombination(a, b);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(double a1, Gradient b1, double a2, Gradient b2, double a3, Gradient b3, double a4, Gradient b4) {
        Gradient result = this.newInstance(MathArrays.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value, a4, b4.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = MathArrays.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i], a4, b4.grad[i]);
        }
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Gradient) {
            Gradient rhs = (Gradient)other;
            return this.value == rhs.value && MathArrays.equals(this.grad, rhs.grad);
        }
        return false;
    }

    public int hashCode() {
        return 129 + 7 * Double.hashCode(this.value) - 15 * Arrays.hashCode(this.grad);
    }
}

