/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.analysis.differentiation.FieldDerivative1;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldGradientField;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldGradient<T extends CalculusFieldElement<T>>
implements FieldDerivative1<T, FieldGradient<T>> {
    private final T value;
    private final T[] grad;

    private FieldGradient(T value, int freeParameters) {
        this.value = value;
        this.grad = (CalculusFieldElement[])MathArrays.buildArray(value.getField(), (int)freeParameters);
    }

    @SafeVarargs
    public FieldGradient(T value, T ... gradient) {
        this(value, gradient.length);
        System.arraycopy(gradient, 0, this.grad, 0, this.grad.length);
    }

    public FieldGradient(FieldDerivativeStructure<T> ds) throws MathIllegalArgumentException {
        this(ds.getValue(), ds.getFreeParameters());
        MathUtils.checkDimension(ds.getOrder(), 1);
        System.arraycopy(ds.getAllDerivatives(), 1, this.grad, 0, this.grad.length);
    }

    public static <T extends CalculusFieldElement<T>> FieldGradient<T> constant(int freeParameters, T value) {
        FieldGradient<T> g = new FieldGradient<T>(value, freeParameters);
        Arrays.fill(g.grad, value.getField().getZero());
        return g;
    }

    public static <T extends CalculusFieldElement<T>> FieldGradient<T> variable(int freeParameters, int index, T value) {
        FieldGradient<T> g = new FieldGradient<T>(value, freeParameters);
        Field field = value.getField();
        Arrays.fill(g.grad, field.getZero());
        g.grad[index] = (CalculusFieldElement)field.getOne();
        return g;
    }

    public Field<T> getValueField() {
        return this.value.getField();
    }

    @Override
    public FieldGradient<T> newInstance(double c) {
        return this.newInstance((CalculusFieldElement)((CalculusFieldElement)this.getValueField().getZero()).newInstance(c));
    }

    @Override
    public FieldGradient<T> newInstance(T c) {
        return new FieldGradient(c, (CalculusFieldElement[])MathArrays.buildArray(this.value.getField(), (int)this.grad.length));
    }

    @Override
    public FieldGradient<T> withValue(T v) {
        return new FieldGradient(v, this.grad);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public T[] getGradient() {
        return (CalculusFieldElement[])this.grad.clone();
    }

    @Override
    public int getFreeParameters() {
        return this.grad.length;
    }

    @Override
    public T getPartialDerivative(int ... orders) throws MathIllegalArgumentException {
        if (orders.length != this.grad.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, orders.length, this.grad.length);
        }
        int selected = -1;
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] == 0) continue;
            if (selected >= 0 || orders[i] != 1) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DERIVATION_ORDER_NOT_ALLOWED, orders[i]);
            }
            selected = i;
        }
        return selected < 0 ? this.value : this.grad[selected];
    }

    public T getPartialDerivative(int n) throws MathIllegalArgumentException {
        if (n < 0 || n >= this.grad.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, n, 0, this.grad.length - 1);
        }
        return this.grad[n];
    }

    public FieldDerivativeStructure<T> toDerivativeStructure() {
        CalculusFieldElement[] derivatives = (CalculusFieldElement[])MathArrays.buildArray(this.getValueField(), (int)(1 + this.grad.length));
        derivatives[0] = this.value;
        System.arraycopy(this.grad, 0, derivatives, 1, this.grad.length);
        return ((FieldGradientField)this.getField()).getConversionFactory().build(derivatives);
    }

    @Override
    public FieldGradient<T> add(double a) {
        return new FieldGradient((CalculusFieldElement)this.value.add(a), this.grad);
    }

    @Override
    public FieldGradient<T> add(FieldGradient<T> a) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.add(a.value));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)this.grad[i].add(a.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> subtract(double a) {
        return new FieldGradient((CalculusFieldElement)this.value.subtract((double)a), this.grad);
    }

    @Override
    public FieldGradient<T> subtract(FieldGradient<T> a) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.subtract(a.value));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)this.grad[i].subtract(a.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> multiply(T n) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.multiply(n));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)this.grad[i].multiply(n);
        }
        return result;
    }

    @Override
    public FieldGradient<T> multiply(int n) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.multiply(n));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)this.grad[i].multiply(n);
        }
        return result;
    }

    @Override
    public FieldGradient<T> multiply(double a) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.multiply(a));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)this.grad[i].multiply(a);
        }
        return result;
    }

    @Override
    public FieldGradient<T> multiply(FieldGradient<T> a) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.multiply(a.value));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = ((CalculusFieldElement)this.grad[i].multiply(a.value)).add((CalculusFieldElement)this.value.multiply(a.grad[i]));
        }
        return result;
    }

    @Override
    public FieldGradient<T> divide(T a) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.divide(a));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)this.grad[i].divide(a);
        }
        return result;
    }

    @Override
    public FieldGradient<T> divide(double a) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.divide((double)a));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)this.grad[i].divide((double)a);
        }
        return result;
    }

    @Override
    public FieldGradient<T> divide(FieldGradient<T> a) {
        CalculusFieldElement inv1 = (CalculusFieldElement)a.value.reciprocal();
        CalculusFieldElement inv2 = inv1.multiply(inv1);
        FieldDerivative result = this.newInstance(this.value.multiply((CalculusFieldElement)inv1));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = ((CalculusFieldElement)this.grad[i].multiply(a.value)).subtract((CalculusFieldElement)this.value.multiply(a.grad[i])).multiply(inv2);
        }
        return result;
    }

    @Override
    public FieldGradient<T> remainder(T a) {
        return new FieldGradient(FastMath.IEEEremainder(this.value, a), this.grad);
    }

    @Override
    public FieldGradient<T> remainder(double a) {
        return new FieldGradient((CalculusFieldElement)FastMath.IEEEremainder(this.value, a), this.grad);
    }

    @Override
    public FieldGradient<T> remainder(FieldGradient<T> a) {
        T rem = FastMath.IEEEremainder(this.value, a.value);
        CalculusFieldElement k = FastMath.rint((CalculusFieldElement)((CalculusFieldElement)this.value.subtract(rem)).divide(a.value));
        FieldDerivative result = this.newInstance((CalculusFieldElement)rem);
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = this.grad[i].subtract((CalculusFieldElement)((CalculusFieldElement)k.multiply(a.grad[i])));
        }
        return result;
    }

    @Override
    public FieldGradient<T> negate() {
        FieldDerivative result = this.newInstance((CalculusFieldElement)this.value.negate());
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)this.grad[i].negate();
        }
        return result;
    }

    @Override
    public FieldGradient<T> abs() {
        if (Double.doubleToLongBits(this.value.getReal()) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public FieldGradient<T> copySign(T sign) {
        long m = Double.doubleToLongBits(this.value.getReal());
        long s = Double.doubleToLongBits(sign.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldGradient<T> copySign(FieldGradient<T> sign) {
        long m = Double.doubleToLongBits(this.value.getReal());
        long s = Double.doubleToLongBits(sign.value.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldGradient<T> copySign(double sign) {
        long m = Double.doubleToLongBits(this.value.getReal());
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldGradient<T> scalb(int n) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)FastMath.scalb(this.value, n));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = FastMath.scalb(this.grad[i], n);
        }
        return result;
    }

    @Override
    public FieldGradient<T> hypot(FieldGradient<T> y) {
        int expY;
        if (Double.isInfinite(this.value.getReal()) || Double.isInfinite(y.value.getReal())) {
            return this.newInstance(Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.value.getReal()) || Double.isNaN(y.value.getReal())) {
            return this.newInstance(Double.NaN);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        FieldElement scaledX = this.scalb(-middleExp);
        FieldElement scaledY = y.scalb(-middleExp);
        FieldGradient scaledH = (FieldGradient)((FieldGradient)scaledX).multiply((FieldGradient<T>)scaledX).add(((FieldGradient)scaledY).multiply((FieldGradient<T>)scaledY)).sqrt();
        return scaledH.scalb(middleExp);
    }

    @Override
    public FieldGradient<T> compose(T g0, T g1) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)g0);
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)g1.multiply(this.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> rootN(int n) {
        if (n == 2) {
            return (FieldGradient)this.sqrt();
        }
        if (n == 3) {
            return (FieldGradient)this.cbrt();
        }
        T r = FastMath.pow(this.value, 1.0 / (double)n);
        return this.compose((CalculusFieldElement)r, (CalculusFieldElement)((CalculusFieldElement)FastMath.pow(r, n - 1).multiply(n)).reciprocal());
    }

    @Override
    public FieldGradientField<T> getField() {
        return FieldGradientField.getField(this.getValueField(), this.getFreeParameters());
    }

    public static <T extends CalculusFieldElement<T>> FieldGradient<T> pow(double a, FieldGradient<T> x) {
        if (a == 0.0) {
            return ((FieldGradientField)x.getField()).getZero();
        }
        CalculusFieldElement aX = FastMath.pow((CalculusFieldElement)x.value.newInstance(a), x.value);
        CalculusFieldElement aXlnA = (CalculusFieldElement)aX.multiply(FastMath.log(a));
        FieldDerivative result = x.newInstance(aX);
        for (int i = 0; i < x.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)aXlnA.multiply(x.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> pow(double p) {
        if (p == 0.0) {
            return ((FieldGradientField)this.getField()).getOne();
        }
        T f0Pm1 = FastMath.pow(this.value, p - 1.0);
        return this.compose((CalculusFieldElement)f0Pm1.multiply(this.value), (CalculusFieldElement)f0Pm1.multiply(p));
    }

    @Override
    public FieldGradient<T> pow(int n) {
        if (n == 0) {
            return ((FieldGradientField)this.getField()).getOne();
        }
        T f0Nm1 = FastMath.pow(this.value, n - 1);
        return this.compose((CalculusFieldElement)f0Nm1.multiply(this.value), (CalculusFieldElement)f0Nm1.multiply(n));
    }

    @Override
    public FieldSinCos<FieldGradient<T>> sinCos() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.value);
        FieldDerivative sin = this.newInstance((CalculusFieldElement)sinCos.sin());
        FieldDerivative cos = this.newInstance((CalculusFieldElement)sinCos.cos());
        CalculusFieldElement mSin = (CalculusFieldElement)((CalculusFieldElement)sinCos.sin()).negate();
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)sin).grad[i] = this.grad[i].multiply((CalculusFieldElement)((CalculusFieldElement)sinCos.cos()));
            ((FieldGradient)cos).grad[i] = this.grad[i].multiply((CalculusFieldElement)mSin);
        }
        return new FieldSinCos<FieldDerivative>(sin, cos);
    }

    @Override
    public FieldGradient<T> atan2(FieldGradient<T> x) {
        CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)this.value.square()).add((CalculusFieldElement)x.value.multiply(x.value)).reciprocal();
        FieldDerivative result = this.newInstance((CalculusFieldElement)FastMath.atan2(this.value, x.value));
        CalculusFieldElement xValueInv = x.value.multiply((CalculusFieldElement)inv);
        CalculusFieldElement mValueInv = ((CalculusFieldElement)this.value.negate()).multiply(inv);
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = ((CalculusFieldElement)xValueInv.multiply(this.grad[i])).add(x.grad[i].multiply((CalculusFieldElement)mValueInv));
        }
        return result;
    }

    @Override
    public FieldSinhCosh<FieldGradient<T>> sinhCosh() {
        FieldSinhCosh<T> sinhCosh = FastMath.sinhCosh(this.value);
        FieldDerivative sinh = this.newInstance((CalculusFieldElement)sinhCosh.sinh());
        FieldDerivative cosh = this.newInstance((CalculusFieldElement)sinhCosh.cosh());
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)sinh).grad[i] = this.grad[i].multiply((CalculusFieldElement)((CalculusFieldElement)sinhCosh.cosh()));
            ((FieldGradient)cosh).grad[i] = this.grad[i].multiply((CalculusFieldElement)((CalculusFieldElement)sinhCosh.sinh()));
        }
        return new FieldSinhCosh<FieldDerivative>(sinh, cosh);
    }

    @Override
    public FieldGradient<T> toDegrees() {
        FieldDerivative result = this.newInstance((CalculusFieldElement)FastMath.toDegrees(this.value));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = FastMath.toDegrees(this.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> toRadians() {
        FieldDerivative result = this.newInstance((CalculusFieldElement)FastMath.toRadians(this.value));
        for (int i = 0; i < this.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = FastMath.toRadians(this.grad[i]);
        }
        return result;
    }

    public T taylor(double ... delta) {
        CalculusFieldElement result = this.value;
        for (int i = 0; i < this.grad.length; ++i) {
            result = result.add((CalculusFieldElement)((CalculusFieldElement)this.grad[i].multiply(delta[i])));
        }
        return (T)result;
    }

    public T taylor(T ... delta) {
        CalculusFieldElement result = this.value;
        for (int i = 0; i < this.grad.length; ++i) {
            result = result.add((CalculusFieldElement)((CalculusFieldElement)this.grad[i].multiply(delta[i])));
        }
        return (T)result;
    }

    public FieldGradient<T> linearCombination(FieldGradient<T>[] a, FieldGradient<T>[] b) {
        Field field = a[0].value.getField();
        int n = a.length;
        FieldElement[] a0 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        FieldElement[] b0 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        FieldElement[] a1 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(2 * n));
        FieldElement[] b1 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(2 * n));
        for (int i = 0; i < n; ++i) {
            FieldGradient<T> ai = a[i];
            FieldGradient<T> bi = b[i];
            a0[i] = ai.value;
            b0[i] = bi.value;
            a1[2 * i] = ai.value;
            b1[2 * i + 1] = bi.value;
        }
        FieldDerivative result = this.newInstance((CalculusFieldElement)a[0].value.linearCombination(a0, b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                a1[2 * i + 1] = a[i].grad[k];
                b1[2 * i] = b[i].grad[k];
            }
            ((FieldGradient)result).grad[k] = (CalculusFieldElement)a[0].value.linearCombination(a1, b1);
        }
        return result;
    }

    public FieldGradient<T> linearCombination(T[] a, FieldGradient<T>[] b) {
        Field field = b[0].value.getField();
        int n = b.length;
        FieldElement[] b0 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        FieldElement[] b1 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].value;
        }
        FieldDerivative result = this.newInstance((CalculusFieldElement)b[0].value.linearCombination(a, b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                b1[i] = b[i].grad[k];
            }
            ((FieldGradient)result).grad[k] = (CalculusFieldElement)b[0].value.linearCombination(a, b1);
        }
        return result;
    }

    public FieldGradient<T> linearCombination(double[] a, FieldGradient<T>[] b) {
        Field field = b[0].value.getField();
        int n = b.length;
        FieldElement[] b0 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        FieldElement[] b1 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].value;
        }
        FieldDerivative result = this.newInstance((CalculusFieldElement)b[0].value.linearCombination(a, b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                b1[i] = b[i].grad[k];
            }
            ((FieldGradient)result).grad[k] = (CalculusFieldElement)b[0].value.linearCombination(a, b1);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(FieldGradient<T> a1, FieldGradient<T> b1, FieldGradient<T> a2, FieldGradient<T> b2) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)a1.value.linearCombination(a1.value, b1.value, a2.value, b2.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)a1.value.linearCombination(a1.value, b1.grad[i], a1.grad[i], b1.value, a2.value, b2.grad[i], a2.grad[i], b2.value);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(double a1, FieldGradient<T> b1, double a2, FieldGradient<T> b2) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)b1.value.linearCombination(a1, b1.value, a2, b2.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)b1.value.linearCombination(a1, b1.grad[i], a2, b2.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(FieldGradient<T> a1, FieldGradient<T> b1, FieldGradient<T> a2, FieldGradient<T> b2, FieldGradient<T> a3, FieldGradient<T> b3) {
        Field field = a1.value.getField();
        FieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
        FieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
        a[0] = a1.value;
        a[2] = a2.value;
        a[4] = a3.value;
        b[1] = b1.value;
        b[3] = b2.value;
        b[5] = b3.value;
        FieldDerivative result = this.newInstance((CalculusFieldElement)a1.value.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            a[1] = a1.grad[i];
            a[3] = a2.grad[i];
            a[5] = a3.grad[i];
            b[0] = b1.grad[i];
            b[2] = b2.grad[i];
            b[4] = b3.grad[i];
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)a1.value.linearCombination(a, b);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(T a1, FieldGradient<T> b1, T a2, FieldGradient<T> b2, T a3, FieldGradient<T> b3) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)b1.value.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)b1.value.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(double a1, FieldGradient<T> b1, double a2, FieldGradient<T> b2, double a3, FieldGradient<T> b3) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)b1.value.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)b1.value.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(FieldGradient<T> a1, FieldGradient<T> b1, FieldGradient<T> a2, FieldGradient<T> b2, FieldGradient<T> a3, FieldGradient<T> b3, FieldGradient<T> a4, FieldGradient<T> b4) {
        Field field = a1.value.getField();
        FieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(field, (int)8);
        FieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(field, (int)8);
        a[0] = a1.value;
        a[2] = a2.value;
        a[4] = a3.value;
        a[6] = a4.value;
        b[1] = b1.value;
        b[3] = b2.value;
        b[5] = b3.value;
        b[7] = b4.value;
        FieldDerivative result = this.newInstance((CalculusFieldElement)a1.value.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value, a4.value, b4.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            a[1] = a1.grad[i];
            a[3] = a2.grad[i];
            a[5] = a3.grad[i];
            a[7] = a4.grad[i];
            b[0] = b1.grad[i];
            b[2] = b2.grad[i];
            b[4] = b3.grad[i];
            b[6] = b4.grad[i];
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)a1.value.linearCombination(a, b);
        }
        return result;
    }

    @Override
    public FieldGradient<T> linearCombination(double a1, FieldGradient<T> b1, double a2, FieldGradient<T> b2, double a3, FieldGradient<T> b3, double a4, FieldGradient<T> b4) {
        FieldDerivative result = this.newInstance((CalculusFieldElement)b1.value.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value, a4, b4.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            ((FieldGradient)result).grad[i] = (CalculusFieldElement)b1.value.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i], a4, b4.grad[i]);
        }
        return result;
    }

    @Override
    public FieldGradient<T> getPi() {
        return new FieldGradient<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)this.getValueField().getZero()).getPi(), this.getFreeParameters());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FieldGradient) {
            FieldGradient rhs = (FieldGradient)other;
            if (!this.value.equals(rhs.value) || this.grad.length != rhs.grad.length) {
                return false;
            }
            for (int i = 0; i < this.grad.length; ++i) {
                if (this.grad[i].equals(rhs.grad[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 129 + 7 * this.value.hashCode() - 15 * Arrays.hashCode(this.grad);
    }
}

