/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;

public interface FieldDerivative1<S extends CalculusFieldElement<S>, T extends FieldDerivative<S, T>>
extends FieldDerivative<S, T> {
    @Override
    default public int getOrder() {
        return 1;
    }

    public T compose(S var1, S var2);

    @Override
    default public T square() {
        Object f0 = this.getValue();
        return this.compose((CalculusFieldElement)f0.square(), (CalculusFieldElement)f0.multiply(2));
    }

    @Override
    default public T reciprocal() {
        CalculusFieldElement inv1 = (CalculusFieldElement)this.getValue().reciprocal();
        CalculusFieldElement inv2 = (CalculusFieldElement)((CalculusFieldElement)inv1.square()).negate();
        return this.compose(inv1, inv2);
    }

    @Override
    default public T exp() {
        CalculusFieldElement exp = (CalculusFieldElement)this.getValue().exp();
        return this.compose(exp, exp);
    }

    @Override
    default public T sqrt() {
        CalculusFieldElement s = (CalculusFieldElement)this.getValue().sqrt();
        return this.compose(s, (CalculusFieldElement)s.add(s).reciprocal());
    }

    @Override
    default public T cbrt() {
        CalculusFieldElement c = (CalculusFieldElement)this.getValue().cbrt();
        return this.compose(c, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c.square()).multiply(3)).reciprocal());
    }

    @Override
    default public T expm1() {
        Object exp = FastMath.exp(this.getValue());
        Object expM1 = FastMath.expm1(this.getValue());
        return this.compose(expM1, exp);
    }

    @Override
    default public T log() {
        return this.compose((CalculusFieldElement)this.getValue().log(), (CalculusFieldElement)this.getValue().reciprocal());
    }

    @Override
    default public T log1p() {
        return this.compose((CalculusFieldElement)this.getValue().log1p(), (CalculusFieldElement)((CalculusFieldElement)this.getValue().add(1.0)).reciprocal());
    }

    @Override
    default public T log10() {
        return this.compose((CalculusFieldElement)this.getValue().log10(), (CalculusFieldElement)((CalculusFieldElement)this.getValue().multiply(FastMath.log(10.0))).reciprocal());
    }

    @Override
    default public T cos() {
        FieldSinCos sinCos = this.getValue().sinCos();
        return this.compose((CalculusFieldElement)sinCos.cos(), (CalculusFieldElement)((CalculusFieldElement)sinCos.sin()).negate());
    }

    @Override
    default public T sin() {
        FieldSinCos sinCos = this.getValue().sinCos();
        return this.compose((CalculusFieldElement)sinCos.sin(), (CalculusFieldElement)sinCos.cos());
    }

    @Override
    default public FieldSinCos<T> sinCos() {
        FieldSinCos sinCos = this.getValue().sinCos();
        return new FieldSinCos<T>(this.compose((CalculusFieldElement)sinCos.sin(), (CalculusFieldElement)sinCos.cos()), this.compose((CalculusFieldElement)sinCos.cos(), (CalculusFieldElement)((CalculusFieldElement)sinCos.sin()).negate()));
    }

    @Override
    default public T tan() {
        CalculusFieldElement tan = (CalculusFieldElement)this.getValue().tan();
        return this.compose(tan, (CalculusFieldElement)tan.multiply(tan).add(1.0));
    }

    @Override
    default public T acos() {
        return this.compose((CalculusFieldElement)this.getValue().acos(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue().square()).negate()).add(1.0)).sqrt()).reciprocal()).negate());
    }

    @Override
    default public T asin() {
        return this.compose((CalculusFieldElement)this.getValue().asin(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue().square()).negate()).add(1.0)).sqrt()).reciprocal());
    }

    @Override
    default public T atan() {
        return this.compose((CalculusFieldElement)this.getValue().atan(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue().square()).add(1.0)).reciprocal());
    }

    @Override
    default public T cosh() {
        FieldSinhCosh sinhCosh = this.getValue().sinhCosh();
        return this.compose((CalculusFieldElement)sinhCosh.cosh(), (CalculusFieldElement)sinhCosh.sinh());
    }

    @Override
    default public T sinh() {
        FieldSinhCosh sinhCosh = this.getValue().sinhCosh();
        return this.compose((CalculusFieldElement)sinhCosh.sinh(), (CalculusFieldElement)sinhCosh.cosh());
    }

    @Override
    default public FieldSinhCosh<T> sinhCosh() {
        FieldSinhCosh sinhCosh = this.getValue().sinhCosh();
        return new FieldSinhCosh<T>(this.compose((CalculusFieldElement)sinhCosh.sinh(), (CalculusFieldElement)sinhCosh.cosh()), this.compose((CalculusFieldElement)sinhCosh.cosh(), (CalculusFieldElement)sinhCosh.sinh()));
    }

    @Override
    default public T tanh() {
        CalculusFieldElement tanh = (CalculusFieldElement)this.getValue().tanh();
        return this.compose(tanh, (CalculusFieldElement)((CalculusFieldElement)tanh.multiply(tanh).negate()).add(1.0));
    }

    @Override
    default public T acosh() {
        return this.compose((CalculusFieldElement)this.getValue().acosh(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue().square()).subtract(1.0)).sqrt()).reciprocal());
    }

    @Override
    default public T asinh() {
        return this.compose((CalculusFieldElement)this.getValue().asinh(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue().square()).add(1.0)).sqrt()).reciprocal());
    }

    @Override
    default public T atanh() {
        return this.compose((CalculusFieldElement)this.getValue().atanh(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue().square()).negate()).add(1.0)).reciprocal());
    }
}

