/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.DifferentialAlgebra;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;

public interface FieldDerivative<S extends CalculusFieldElement<S>, T extends FieldDerivative<S, T>>
extends CalculusFieldElement<T>,
DifferentialAlgebra {
    public S getValue();

    public S getPartialDerivative(int ... var1) throws MathIllegalArgumentException;

    @Override
    default public double getReal() {
        return this.getValue().getReal();
    }

    default public T newInstance(S value) {
        return (T)((FieldDerivative)this.newInstance((S)value.getReal()));
    }

    default public T withValue(S value) {
        return (T)((FieldDerivative)this.add((S)this.newInstance((CalculusFieldElement)value.subtract(this.getValue()))));
    }

    @Override
    default public T add(S a) {
        return this.withValue((CalculusFieldElement)this.getValue().add(a));
    }

    @Override
    default public T subtract(S a) {
        return this.withValue((CalculusFieldElement)this.getValue().subtract(a));
    }

    @Override
    default public T log10() {
        return (T)((FieldDerivative)((FieldDerivative)this.log()).divide(FastMath.log(10.0)));
    }

    @Override
    default public T pow(T e) {
        return (T)((FieldDerivative)((FieldDerivative)((FieldDerivative)this.log()).multiply(e)).exp());
    }

    @Override
    default public T cosh() {
        return (T)((FieldDerivative)((FieldDerivative)((FieldDerivative)this.exp()).add((S)((FieldDerivative)((FieldDerivative)this.negate()).exp()))).divide(2.0));
    }

    @Override
    default public T sinh() {
        return (T)((FieldDerivative)((FieldDerivative)((FieldDerivative)this.exp()).subtract((S)((FieldDerivative)((FieldDerivative)this.negate()).exp()))).divide(2.0));
    }

    @Override
    default public T acos() {
        return (T)((FieldDerivative)((FieldDerivative)((FieldDerivative)this.asin()).negate()).add((S)((FieldDerivative)((FieldDerivative)this.getPi()).divide(2.0))));
    }

    @Override
    default public T ceil() {
        return this.newInstance((CalculusFieldElement)this.getValue().ceil());
    }

    @Override
    default public T floor() {
        return this.newInstance((CalculusFieldElement)this.getValue().floor());
    }

    @Override
    default public T rint() {
        return this.newInstance((CalculusFieldElement)this.getValue().rint());
    }

    @Override
    default public T ulp() {
        return this.newInstance((CalculusFieldElement)this.getValue().ulp());
    }

    @Override
    default public T sign() {
        return this.newInstance((CalculusFieldElement)this.getValue().sign());
    }

    @Override
    default public int getExponent() {
        return this.getValue().getExponent();
    }
}

