/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.io.Serializable;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.DSCompiler;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class DerivativeStructure
implements Derivative<DerivativeStructure>,
Serializable {
    private static final long serialVersionUID = 20161220L;
    private final DSFactory factory;
    private final double[] data;

    DerivativeStructure(DSFactory factory, double[] data) {
        this.factory = factory;
        this.data = (double[])data.clone();
    }

    DerivativeStructure(DSFactory factory) {
        this.factory = factory;
        this.data = new double[factory.getCompiler().getSize()];
    }

    @Override
    public DerivativeStructure newInstance(double value) {
        return this.factory.constant(value);
    }

    @Override
    public DerivativeStructure withValue(double value) {
        DerivativeStructure ds = this.factory.build();
        System.arraycopy(this.data, 1, ds.data, 1, this.data.length - 1);
        ds.data[0] = value;
        return ds;
    }

    public DSFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getFreeParameters() {
        return this.getFactory().getCompiler().getFreeParameters();
    }

    @Override
    public int getOrder() {
        return this.getFactory().getCompiler().getOrder();
    }

    void setDerivativeComponent(int index, double value) {
        this.data[index] = value;
    }

    double getDerivativeComponent(int index) {
        return this.data[index];
    }

    @Override
    public double getValue() {
        return this.data[0];
    }

    @Override
    public double getPartialDerivative(int ... orders) throws MathIllegalArgumentException {
        return this.data[this.getFactory().getCompiler().getPartialDerivativeIndex(orders)];
    }

    public double[] getAllDerivatives() {
        return (double[])this.data.clone();
    }

    @Override
    public DerivativeStructure add(DerivativeStructure a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        DerivativeStructure ds = this.factory.build();
        this.factory.getCompiler().add(this.data, 0, a.data, 0, ds.data, 0);
        return ds;
    }

    @Override
    public DerivativeStructure subtract(DerivativeStructure a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        DerivativeStructure ds = this.factory.build();
        this.factory.getCompiler().subtract(this.data, 0, a.data, 0, ds.data, 0);
        return ds;
    }

    @Override
    public DerivativeStructure multiply(double a) {
        DerivativeStructure ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = this.data[i] * a;
        }
        return ds;
    }

    @Override
    public DerivativeStructure multiply(DerivativeStructure a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().multiply(this.data, 0, a.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure square() {
        return this.multiply(this);
    }

    @Override
    public DerivativeStructure divide(double a) {
        DerivativeStructure ds = this.factory.build();
        double inv = 1.0 / a;
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = this.data[i] * inv;
        }
        return ds;
    }

    @Override
    public DerivativeStructure divide(DerivativeStructure a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().divide(this.data, 0, a.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure remainder(DerivativeStructure a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().remainder(this.data, 0, a.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure negate() {
        DerivativeStructure ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = -this.data[i];
        }
        return ds;
    }

    @Override
    public DerivativeStructure abs() {
        if (Double.doubleToLongBits(this.data[0]) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public DerivativeStructure copySign(DerivativeStructure sign) {
        long m = Double.doubleToLongBits(this.data[0]);
        long s = Double.doubleToLongBits(sign.data[0]);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public DerivativeStructure copySign(double sign) {
        long m = Double.doubleToLongBits(this.data[0]);
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public DerivativeStructure scalb(int n) {
        DerivativeStructure ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = FastMath.scalb(this.data[i], n);
        }
        return ds;
    }

    @Override
    public DerivativeStructure hypot(DerivativeStructure y) throws MathIllegalArgumentException {
        int expY;
        this.factory.checkCompatibility(y.factory);
        if (Double.isInfinite(this.data[0]) || Double.isInfinite(y.data[0])) {
            return this.factory.constant(Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.data[0]) || Double.isNaN(y.data[0])) {
            return this.factory.constant(Double.NaN);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        DerivativeStructure scaledX = this.scalb(-middleExp);
        DerivativeStructure scaledY = y.scalb(-middleExp);
        DerivativeStructure scaledH = scaledX.multiply(scaledX).add(scaledY.multiply(scaledY)).sqrt();
        return scaledH.scalb(middleExp);
    }

    public static DerivativeStructure hypot(DerivativeStructure x, DerivativeStructure y) throws MathIllegalArgumentException {
        return x.hypot(y);
    }

    @Override
    public DerivativeStructure compose(double ... f) throws MathIllegalArgumentException {
        MathUtils.checkDimension(f.length, this.getOrder() + 1);
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().compose(this.data, 0, f, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure reciprocal() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().reciprocal(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure sqrt() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().sqrt(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure rootN(int n) {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().rootN(this.data, 0, n, result.data, 0);
        return result;
    }

    @Override
    public Field<DerivativeStructure> getField() {
        return this.factory.getDerivativeField();
    }

    public static DerivativeStructure pow(double a, DerivativeStructure x) {
        DerivativeStructure result = x.factory.build();
        x.factory.getCompiler().pow(a, x.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure pow(double p) {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().pow(this.data, 0, p, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure pow(int n) {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().pow(this.data, 0, n, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure pow(DerivativeStructure e) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(e.factory);
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().pow(this.data, 0, e.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure exp() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().exp(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure expm1() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().expm1(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure log() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().log(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure log1p() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().log1p(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure log10() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().log10(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure cos() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().cos(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure sin() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().sin(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public FieldSinCos<DerivativeStructure> sinCos() {
        DerivativeStructure sin = this.factory.build();
        DerivativeStructure cos = this.factory.build();
        this.factory.getCompiler().sinCos(this.data, 0, sin.data, 0, cos.data, 0);
        return new FieldSinCos<DerivativeStructure>(sin, cos);
    }

    @Override
    public DerivativeStructure tan() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().tan(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure acos() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().acos(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure asin() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().asin(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure atan() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().atan(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure atan2(DerivativeStructure x) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(x.factory);
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().atan2(this.data, 0, x.data, 0, result.data, 0);
        return result;
    }

    public static DerivativeStructure atan2(DerivativeStructure y, DerivativeStructure x) throws MathIllegalArgumentException {
        return y.atan2(x);
    }

    @Override
    public DerivativeStructure cosh() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().cosh(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure sinh() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().sinh(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public FieldSinhCosh<DerivativeStructure> sinhCosh() {
        DerivativeStructure sinh = this.factory.build();
        DerivativeStructure cosh = this.factory.build();
        this.factory.getCompiler().sinhCosh(this.data, 0, sinh.data, 0, cosh.data, 0);
        return new FieldSinhCosh<DerivativeStructure>(sinh, cosh);
    }

    @Override
    public DerivativeStructure tanh() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().tanh(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure acosh() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().acosh(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure asinh() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().asinh(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure atanh() {
        DerivativeStructure result = this.factory.build();
        this.factory.getCompiler().atanh(this.data, 0, result.data, 0);
        return result;
    }

    @Override
    public DerivativeStructure toDegrees() {
        DerivativeStructure ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = FastMath.toDegrees(this.data[i]);
        }
        return ds;
    }

    @Override
    public DerivativeStructure toRadians() {
        DerivativeStructure ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = FastMath.toRadians(this.data[i]);
        }
        return ds;
    }

    public DerivativeStructure integrate(int varIndex, int integrationOrder) {
        if (integrationOrder > this.getOrder()) {
            return this.factory.constant(0.0);
        }
        if (integrationOrder == 0) {
            return this.factory.build(this.data);
        }
        if (integrationOrder < 0) {
            return this.differentiate(varIndex, -integrationOrder);
        }
        double[] newData = new double[this.data.length];
        DSCompiler dsCompiler = this.factory.getCompiler();
        for (int i = 0; i < newData.length; ++i) {
            if (this.data[i] == 0.0) continue;
            int[] orders = dsCompiler.getPartialDerivativeOrders(i);
            int sum = 0;
            for (int order : orders) {
                sum += order;
            }
            if (sum + integrationOrder > this.getOrder()) continue;
            int saved = orders[varIndex];
            int n = varIndex;
            orders[n] = orders[n] + integrationOrder;
            int index = dsCompiler.getPartialDerivativeIndex(orders);
            orders[varIndex] = saved;
            newData[index] = this.data[i];
        }
        return this.factory.build(newData);
    }

    public DerivativeStructure differentiate(int varIndex, int differentiationOrder) {
        if (differentiationOrder > this.getOrder()) {
            return this.factory.constant(0.0);
        }
        if (differentiationOrder == 0) {
            return this.factory.build(this.data);
        }
        if (differentiationOrder < 0) {
            return this.integrate(varIndex, -differentiationOrder);
        }
        double[] newData = new double[this.data.length];
        DSCompiler dsCompiler = this.factory.getCompiler();
        for (int i = 0; i < newData.length; ++i) {
            int[] orders;
            if (this.data[i] == 0.0 || (orders = dsCompiler.getPartialDerivativeOrders(i))[varIndex] - differentiationOrder < 0) continue;
            int saved = orders[varIndex];
            int n = varIndex;
            orders[n] = orders[n] - differentiationOrder;
            int index = dsCompiler.getPartialDerivativeIndex(orders);
            orders[varIndex] = saved;
            newData[index] = this.data[i];
        }
        return this.factory.build(newData);
    }

    public double taylor(double ... delta) throws MathRuntimeException {
        return this.factory.getCompiler().taylor(this.data, 0, delta);
    }

    public DerivativeStructure rebase(DerivativeStructure ... p) {
        MathUtils.checkDimension(this.getFreeParameters(), p.length);
        if (p.length == 0) {
            return this;
        }
        int pSize = p[0].getFactory().getCompiler().getSize();
        double[] pData = new double[p.length * pSize];
        for (int i = 0; i < p.length; ++i) {
            MathUtils.checkDimension(this.getOrder(), p[i].getOrder());
            MathUtils.checkDimension(p[0].getFreeParameters(), p[i].getFreeParameters());
            System.arraycopy(p[i].data, 0, pData, i * pSize, pSize);
        }
        DerivativeStructure result = p[0].factory.build();
        this.factory.getCompiler().rebase(this.data, 0, p[0].factory.getCompiler(), pData, result.data, 0);
        return result;
    }

    public DerivativeStructure linearCombination(DerivativeStructure[] a, DerivativeStructure[] b) throws MathIllegalArgumentException {
        double[] aDouble = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            aDouble[i] = a[i].getValue();
        }
        double[] bDouble = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            bDouble[i] = b[i].getValue();
        }
        double accurateValue = MathArrays.linearCombination(aDouble, bDouble);
        DerivativeStructure simpleValue = a[0].getField().getZero();
        for (int i = 0; i < a.length; ++i) {
            simpleValue = simpleValue.add(a[i].multiply(b[i]));
        }
        double[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    public DerivativeStructure linearCombination(double[] a, DerivativeStructure[] b) throws MathIllegalArgumentException {
        double[] bDouble = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            bDouble[i] = b[i].getValue();
        }
        double accurateValue = MathArrays.linearCombination(a, bDouble);
        DerivativeStructure simpleValue = b[0].getField().getZero();
        for (int i = 0; i < a.length; ++i) {
            simpleValue = simpleValue.add(b[i].multiply(a[i]));
        }
        double[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    @Override
    public DerivativeStructure linearCombination(DerivativeStructure a1, DerivativeStructure b1, DerivativeStructure a2, DerivativeStructure b2) throws MathIllegalArgumentException {
        double accurateValue = MathArrays.linearCombination(a1.getValue(), b1.getValue(), a2.getValue(), b2.getValue());
        DerivativeStructure simpleValue = a1.multiply(b1).add(a2.multiply(b2));
        double[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    @Override
    public DerivativeStructure linearCombination(double a1, DerivativeStructure b1, double a2, DerivativeStructure b2) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        DerivativeStructure ds = this.factory.build();
        this.factory.getCompiler().linearCombination(a1, b1.data, 0, a2, b2.data, 0, ds.data, 0);
        return ds;
    }

    @Override
    public DerivativeStructure linearCombination(DerivativeStructure a1, DerivativeStructure b1, DerivativeStructure a2, DerivativeStructure b2, DerivativeStructure a3, DerivativeStructure b3) throws MathIllegalArgumentException {
        double accurateValue = MathArrays.linearCombination(a1.getValue(), b1.getValue(), a2.getValue(), b2.getValue(), a3.getValue(), b3.getValue());
        DerivativeStructure simpleValue = a1.multiply(b1).add(a2.multiply(b2)).add(a3.multiply(b3));
        double[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    @Override
    public DerivativeStructure linearCombination(double a1, DerivativeStructure b1, double a2, DerivativeStructure b2, double a3, DerivativeStructure b3) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        this.factory.checkCompatibility(b3.factory);
        DerivativeStructure ds = this.factory.build();
        this.factory.getCompiler().linearCombination(a1, b1.data, 0, a2, b2.data, 0, a3, b3.data, 0, ds.data, 0);
        return ds;
    }

    @Override
    public DerivativeStructure linearCombination(DerivativeStructure a1, DerivativeStructure b1, DerivativeStructure a2, DerivativeStructure b2, DerivativeStructure a3, DerivativeStructure b3, DerivativeStructure a4, DerivativeStructure b4) throws MathIllegalArgumentException {
        double accurateValue = MathArrays.linearCombination(a1.getValue(), b1.getValue(), a2.getValue(), b2.getValue(), a3.getValue(), b3.getValue(), a4.getValue(), b4.getValue());
        DerivativeStructure simpleValue = a1.multiply(b1).add(a2.multiply(b2)).add(a3.multiply(b3)).add(a4.multiply(b4));
        double[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    @Override
    public DerivativeStructure linearCombination(double a1, DerivativeStructure b1, double a2, DerivativeStructure b2, double a3, DerivativeStructure b3, double a4, DerivativeStructure b4) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        this.factory.checkCompatibility(b3.factory);
        this.factory.checkCompatibility(b4.factory);
        DerivativeStructure ds = this.factory.build();
        this.factory.getCompiler().linearCombination(a1, b1.data, 0, a2, b2.data, 0, a3, b3.data, 0, a4, b4.data, 0, ds.data, 0);
        return ds;
    }

    @Override
    public DerivativeStructure getPi() {
        return this.factory.getDerivativeField().getPi();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DerivativeStructure) {
            DerivativeStructure rhs = (DerivativeStructure)other;
            return this.getFreeParameters() == rhs.getFreeParameters() && this.getOrder() == rhs.getOrder() && MathArrays.equals(this.data, rhs.data);
        }
        return false;
    }

    public int hashCode() {
        return 227 + 229 * this.getFreeParameters() + 233 * this.getOrder() + 239 * MathUtils.hash(this.data);
    }
}

