/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.SinCos;
import org.hipparchus.util.SinhCosh;

public interface Derivative1<T extends CalculusFieldElement<T>>
extends Derivative<T> {
    @Override
    default public int getOrder() {
        return 1;
    }

    public T compose(double var1, double var3);

    @Override
    default public T square() {
        double f0 = this.getValue();
        return this.compose(f0 * f0, 2.0 * f0);
    }

    @Override
    default public T reciprocal() {
        double inv1 = 1.0 / this.getValue();
        double inv2 = -inv1 * inv1;
        return this.compose(inv1, inv2);
    }

    @Override
    default public T sqrt() {
        double s = FastMath.sqrt(this.getValue());
        return this.compose(s, 1.0 / (2.0 * s));
    }

    @Override
    default public T cbrt() {
        double c = FastMath.cbrt(this.getValue());
        return this.compose(c, 1.0 / (3.0 * c * c));
    }

    @Override
    default public T rootN(int n) {
        if (n == 2) {
            return (T)this.sqrt();
        }
        if (n == 3) {
            return (T)this.cbrt();
        }
        double r = FastMath.pow(this.getValue(), 1.0 / (double)n);
        return this.compose(r, 1.0 / ((double)n * FastMath.pow(r, n - 1)));
    }

    @Override
    default public T exp() {
        double exp = FastMath.exp(this.getValue());
        return this.compose(exp, exp);
    }

    @Override
    default public T expm1() {
        double exp = FastMath.exp(this.getValue());
        double expM1 = FastMath.expm1(this.getValue());
        return this.compose(expM1, exp);
    }

    @Override
    default public T log() {
        return this.compose(FastMath.log(this.getValue()), 1.0 / this.getValue());
    }

    @Override
    default public T log1p() {
        return this.compose(FastMath.log1p(this.getValue()), 1.0 / (1.0 + this.getValue()));
    }

    @Override
    default public T log10() {
        return this.compose(FastMath.log10(this.getValue()), 1.0 / (this.getValue() * FastMath.log(10.0)));
    }

    @Override
    default public T cos() {
        SinCos sinCos = FastMath.sinCos(this.getValue());
        return this.compose(sinCos.cos(), -sinCos.sin());
    }

    @Override
    default public T sin() {
        SinCos sinCos = FastMath.sinCos(this.getValue());
        return this.compose(sinCos.sin(), sinCos.cos());
    }

    @Override
    default public FieldSinCos<T> sinCos() {
        SinCos sinCos = FastMath.sinCos(this.getValue());
        return new FieldSinCos<T>(this.compose(sinCos.sin(), sinCos.cos()), this.compose(sinCos.cos(), -sinCos.sin()));
    }

    @Override
    default public T tan() {
        double tan = FastMath.tan(this.getValue());
        return this.compose(tan, 1.0 + tan * tan);
    }

    @Override
    default public T acos() {
        double f0 = this.getValue();
        return this.compose(FastMath.acos(f0), -1.0 / FastMath.sqrt(1.0 - f0 * f0));
    }

    @Override
    default public T asin() {
        double f0 = this.getValue();
        return this.compose(FastMath.asin(f0), 1.0 / FastMath.sqrt(1.0 - f0 * f0));
    }

    @Override
    default public T atan() {
        double f0 = this.getValue();
        return this.compose(FastMath.atan(f0), 1.0 / (1.0 + f0 * f0));
    }

    @Override
    default public T cosh() {
        return this.compose(FastMath.cosh(this.getValue()), FastMath.sinh(this.getValue()));
    }

    @Override
    default public T sinh() {
        return this.compose(FastMath.sinh(this.getValue()), FastMath.cosh(this.getValue()));
    }

    @Override
    default public FieldSinhCosh<T> sinhCosh() {
        SinhCosh sinhCosh = FastMath.sinhCosh(this.getValue());
        return new FieldSinhCosh<T>(this.compose(sinhCosh.sinh(), sinhCosh.cosh()), this.compose(sinhCosh.cosh(), sinhCosh.sinh()));
    }

    @Override
    default public T tanh() {
        double tanh = FastMath.tanh(this.getValue());
        return this.compose(tanh, 1.0 - tanh * tanh);
    }

    @Override
    default public T acosh() {
        double f0 = this.getValue();
        return this.compose(FastMath.acosh(f0), 1.0 / FastMath.sqrt(f0 * f0 - 1.0));
    }

    @Override
    default public T asinh() {
        double f0 = this.getValue();
        return this.compose(FastMath.asinh(f0), 1.0 / FastMath.sqrt(f0 * f0 + 1.0));
    }

    @Override
    default public T atanh() {
        double f0 = this.getValue();
        return this.compose(FastMath.atanh(f0), 1.0 / (1.0 - f0 * f0));
    }
}

