/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus;

import org.hipparchus.FieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;

public interface CalculusFieldElement<T extends FieldElement<T>>
extends FieldElement<T> {
    default public T getPi() {
        return this.newInstance(Math.PI);
    }

    public T newInstance(double var1);

    @Override
    default public T add(double a) {
        return this.add(this.newInstance(a));
    }

    @Override
    default public T subtract(double a) {
        return this.subtract(this.newInstance(a));
    }

    @Override
    default public T subtract(T a) {
        return this.add(a.negate());
    }

    @Override
    default public T multiply(double a) {
        return this.multiply(this.newInstance(a));
    }

    @Override
    default public T multiply(int n) {
        return this.multiply((double)n);
    }

    @Override
    default public T divide(double a) {
        return this.divide(this.newInstance(a));
    }

    default public int getExponent() {
        return FastMath.getExponent(this.getReal());
    }

    public T scalb(int var1);

    default public T ulp() {
        return this.newInstance(FastMath.ulp(this.getReal()));
    }

    public T hypot(T var1) throws MathIllegalArgumentException;

    @Override
    default public T divide(T a) {
        return this.multiply(a.reciprocal());
    }

    default public T sqrt() {
        return this.rootN(2);
    }

    default public T cbrt() {
        return this.rootN(3);
    }

    default public T rootN(int n) {
        return this.pow((T)(1.0 / (double)n));
    }

    default public T square() {
        return this.pow((T)2);
    }

    default public T pow(double p) {
        return this.pow(this.newInstance(p));
    }

    default public T pow(int n) {
        return this.pow((T)n);
    }

    public T pow(T var1) throws MathIllegalArgumentException;

    public T exp();

    public T expm1();

    public T log();

    public T log1p();

    public T log10();

    public T cos();

    public T sin();

    default public FieldSinCos<T> sinCos() {
        return new FieldSinCos<T>(this.sin(), this.cos());
    }

    default public T tan() {
        return this.sin().divide(this.cos());
    }

    public T acos();

    public T asin();

    public T atan();

    public T atan2(T var1) throws MathIllegalArgumentException;

    public T cosh();

    public T sinh();

    default public FieldSinhCosh<T> sinhCosh() {
        return new FieldSinhCosh<T>(this.sinh(), this.cosh());
    }

    default public T tanh() {
        return this.sinh().divide(this.cosh());
    }

    public T acosh();

    public T asinh();

    public T atanh();

    default public T toDegrees() {
        return this.multiply(FastMath.toDegrees(1.0));
    }

    default public T toRadians() {
        return this.multiply(FastMath.toRadians(1.0));
    }

    public T linearCombination(T[] var1, T[] var2) throws MathIllegalArgumentException;

    default public T linearCombination(double[] a, T[] b) throws MathIllegalArgumentException {
        FieldElement[] newInstances = MathArrays.buildArray(this.getField(), (int)a.length);
        for (int i = 0; i < a.length; ++i) {
            newInstances[i] = this.newInstance(a[i]);
        }
        return (T)this.linearCombination(newInstances, (FieldElement[])b);
    }

    public T linearCombination(T var1, T var2, T var3, T var4);

    default public T linearCombination(double a1, T b1, double a2, T b2) {
        return this.linearCombination(this.newInstance(a1), b1, this.newInstance(a2), b2);
    }

    public T linearCombination(T var1, T var2, T var3, T var4, T var5, T var6);

    default public T linearCombination(double a1, T b1, double a2, T b2, double a3, T b3) {
        return this.linearCombination(this.newInstance(a1), b1, this.newInstance(a2), b2, this.newInstance(a3), b3);
    }

    public T linearCombination(T var1, T var2, T var3, T var4, T var5, T var6, T var7, T var8);

    default public T linearCombination(double a1, T b1, double a2, T b2, double a3, T b3, double a4, T b4) {
        return this.linearCombination(this.newInstance(a1), b1, this.newInstance(a2), b2, this.newInstance(a3), b3, this.newInstance(a4), b4);
    }

    default public T ceil() {
        return this.newInstance(FastMath.ceil(this.getReal()));
    }

    default public T floor() {
        return this.newInstance(FastMath.floor(this.getReal()));
    }

    default public T rint() {
        return this.newInstance(FastMath.rint(this.getReal()));
    }

    public T remainder(double var1);

    public T remainder(T var1);

    default public T sign() {
        return this.newInstance(FastMath.signum(this.getReal()));
    }

    public T copySign(T var1);

    default public T copySign(double sign) {
        return this.copySign(this.newInstance(sign));
    }

    default public boolean isInfinite() {
        return Double.isInfinite(this.getReal());
    }

    default public boolean isFinite() {
        return Double.isFinite(this.getReal());
    }

    default public boolean isNaN() {
        return Double.isNaN(this.getReal());
    }

    default public double norm() {
        return this.abs().getReal();
    }

    public T abs();

    default public long round() {
        return FastMath.round(this.getReal());
    }
}

