/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;

class ThreeEighthesFieldStateInterpolator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    ThreeEighthesFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected ThreeEighthesFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new ThreeEighthesFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        CalculusFieldElement[] interpolatedDerivatives;
        CalculusFieldElement[] interpolatedState;
        CalculusFieldElement coeffDot3 = (CalculusFieldElement)theta.multiply(0.75);
        CalculusFieldElement coeffDot1 = (CalculusFieldElement)((CalculusFieldElement)coeffDot3.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(4)).subtract(5.0)))).add(1.0);
        CalculusFieldElement coeffDot2 = (CalculusFieldElement)coeffDot3.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(-6)).add(5.0)));
        CalculusFieldElement coeffDot4 = (CalculusFieldElement)coeffDot3.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(2)).subtract(1.0)));
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            CalculusFieldElement s = (CalculusFieldElement)thetaH.divide(8.0);
            CalculusFieldElement fourTheta2 = (CalculusFieldElement)((CalculusFieldElement)theta.multiply(theta)).multiply(4);
            CalculusFieldElement coeff1 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fourTheta2.multiply(2)).subtract((FieldElement)((CalculusFieldElement)theta.multiply(15)))).add(8.0)));
            CalculusFieldElement coeff2 = (CalculusFieldElement)((CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(5)).subtract((FieldElement)fourTheta2)))).multiply(3);
            CalculusFieldElement coeff3 = (CalculusFieldElement)((CalculusFieldElement)s.multiply(theta)).multiply(3);
            CalculusFieldElement coeff4 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)fourTheta2.subtract((FieldElement)((CalculusFieldElement)theta.multiply(3)))));
            interpolatedState = this.previousStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff2, coeff3, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4});
        } else {
            CalculusFieldElement s = (CalculusFieldElement)oneMinusThetaH.divide(-8.0);
            CalculusFieldElement fourTheta2 = (CalculusFieldElement)((CalculusFieldElement)theta.multiply(theta)).multiply(4);
            CalculusFieldElement thetaPlus1 = (CalculusFieldElement)theta.add(1.0);
            CalculusFieldElement coeff1 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fourTheta2.multiply(2)).subtract((FieldElement)((CalculusFieldElement)theta.multiply(7)))).add(1.0)));
            CalculusFieldElement coeff2 = (CalculusFieldElement)((CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)thetaPlus1.subtract((FieldElement)fourTheta2)))).multiply(3);
            CalculusFieldElement coeff3 = (CalculusFieldElement)((CalculusFieldElement)s.multiply((FieldElement)thetaPlus1)).multiply(3);
            CalculusFieldElement coeff4 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)thetaPlus1.add((FieldElement)fourTheta2)));
            interpolatedState = this.currentStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff2, coeff3, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4});
        }
        return mapper.mapStateAndDerivative((CalculusFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

