/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.sampling.AbstractODEStateInterpolator;

abstract class RungeKuttaStateInterpolator
extends AbstractODEStateInterpolator {
    private static final long serialVersionUID = 20160328L;
    protected double[][] yDotK;

    protected RungeKuttaStateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
        this.yDotK = new double[yDotK.length][];
        for (int i = 0; i < yDotK.length; ++i) {
            this.yDotK[i] = (double[])yDotK[i].clone();
        }
    }

    @Override
    protected RungeKuttaStateInterpolator create(boolean newForward, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return this.create(newForward, this.yDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    protected abstract RungeKuttaStateInterpolator create(boolean var1, double[][] var2, ODEStateAndDerivative var3, ODEStateAndDerivative var4, ODEStateAndDerivative var5, ODEStateAndDerivative var6, EquationsMapper var7);

    protected final double[] previousStateLinearCombination(double ... coefficients) {
        return this.combine(this.getGlobalPreviousState().getCompleteState(), coefficients);
    }

    protected double[] currentStateLinearCombination(double ... coefficients) {
        return this.combine(this.getGlobalCurrentState().getCompleteState(), coefficients);
    }

    protected double[] derivativeLinearCombination(double ... coefficients) {
        return this.combine(new double[this.yDotK[0].length], coefficients);
    }

    private double[] combine(double[] a, double ... coefficients) {
        for (int i = 0; i < a.length; ++i) {
            for (int k = 0; k < coefficients.length; ++k) {
                int n = i;
                a[n] = a[n] + coefficients[k] * this.yDotK[k][i];
            }
        }
        return a;
    }
}

