/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.AbstractFieldIntegrator;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.FieldExplicitRungeKuttaIntegrator;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;
import org.hipparchus.util.MathArrays;

public abstract class RungeKuttaFieldIntegrator<T extends CalculusFieldElement<T>>
extends AbstractFieldIntegrator<T>
implements FieldExplicitRungeKuttaIntegrator<T> {
    private final T[] c;
    private final T[][] a;
    private final T[] b;
    private double[] realC = new double[0];
    private double[][] realA = new double[0][];
    private double[] realB = new double[0];
    private final T step;
    private boolean usingFieldCoefficients;

    protected RungeKuttaFieldIntegrator(Field<T> field, String name, T step) {
        super(field, name);
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.step = (CalculusFieldElement)step.abs();
        this.usingFieldCoefficients = false;
    }

    public T getDefaultStep() {
        return this.step;
    }

    public void setUsingFieldCoefficients(boolean usingFieldCoefficients) {
        this.usingFieldCoefficients = usingFieldCoefficients;
    }

    @Override
    public boolean isUsingFieldCoefficients() {
        return this.usingFieldCoefficients;
    }

    @Override
    public int getNumberOfStages() {
        return this.b.length;
    }

    protected abstract RungeKuttaFieldStateInterpolator<T> createInterpolator(boolean var1, T[][] var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldEquationsMapper<T> var5);

    @Override
    protected FieldODEStateAndDerivative<T> initIntegration(FieldExpandableODE<T> eqn, FieldODEState<T> s0, T t) {
        if (!this.isUsingFieldCoefficients()) {
            this.realA = this.getRealA();
            this.realB = this.getRealB();
            this.realC = this.getRealC();
        }
        return super.initIntegration(eqn, s0, t);
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> equations, FieldODEState<T> initialState, T finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = ((CalculusFieldElement)finalTime.subtract(initialState.getTime())).getReal() > 0.0;
        int stages = this.getNumberOfStages();
        CalculusFieldElement[][] yDotK = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)stages, (int)-1);
        MathArrays.buildArray(this.getField(), (int)equations.getMapper().getTotalDimension());
        if (forward) {
            if (((CalculusFieldElement)((CalculusFieldElement)this.getStepStart().getTime().add(this.step)).subtract(finalTime)).getReal() >= 0.0) {
                this.setStepSize((CalculusFieldElement)finalTime.subtract(this.getStepStart().getTime()));
            } else {
                this.setStepSize(this.step);
            }
        } else if (((CalculusFieldElement)((CalculusFieldElement)this.getStepStart().getTime().subtract(this.step)).subtract(finalTime)).getReal() <= 0.0) {
            this.setStepSize((CalculusFieldElement)finalTime.subtract(this.getStepStart().getTime()));
        } else {
            this.setStepSize((CalculusFieldElement)this.step.negate());
        }
        this.setIsLastStep(false);
        do {
            boolean nextIsLast;
            CalculusFieldElement[] yTmp;
            CalculusFieldElement[] y = this.getStepStart().getCompleteState();
            yDotK[0] = this.getStepStart().getCompleteDerivative();
            if (this.isUsingFieldCoefficients()) {
                FieldExplicitRungeKuttaIntegrator.applyInternalButcherWeights(this.getEquations(), this.getStepStart().getTime(), (CalculusFieldElement[])y, this.getStepSize(), this.a, this.c, (CalculusFieldElement[][])yDotK);
                yTmp = FieldExplicitRungeKuttaIntegrator.applyExternalButcherWeights((CalculusFieldElement[])y, (CalculusFieldElement[][])yDotK, this.getStepSize(), this.b);
            } else {
                FieldExplicitRungeKuttaIntegrator.applyInternalButcherWeights(this.getEquations(), this.getStepStart().getTime(), (CalculusFieldElement[])y, this.getStepSize(), (double[][])this.realA, (double[])this.realC, (CalculusFieldElement[][])yDotK);
                yTmp = FieldExplicitRungeKuttaIntegrator.applyExternalButcherWeights((CalculusFieldElement[])y, (CalculusFieldElement[][])yDotK, this.getStepSize(), (double[])this.realB);
            }
            this.incrementEvaluations(stages - 1);
            CalculusFieldElement stepEnd = (CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            CalculusFieldElement[] yDotTmp = this.computeDerivatives(stepEnd, yTmp);
            FieldODEStateAndDerivative stateTmp = equations.getMapper().mapStateAndDerivative(stepEnd, yTmp, yDotTmp);
            this.setStepStart(this.acceptStep(this.createInterpolator(forward, yDotK, this.getStepStart(), stateTmp, equations.getMapper()), finalTime));
            if (this.isLastStep()) continue;
            CalculusFieldElement nextT = (CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            boolean bl = forward ? ((CalculusFieldElement)nextT.subtract(finalTime)).getReal() >= 0.0 : (nextIsLast = ((CalculusFieldElement)nextT.subtract(finalTime)).getReal() <= 0.0);
            if (!nextIsLast) continue;
            this.setStepSize((CalculusFieldElement)finalTime.subtract(this.getStepStart().getTime()));
        } while (!this.isLastStep());
        FieldODEStateAndDerivative finalState = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return finalState;
    }
}

