/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;

class MidpointFieldStateInterpolator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    MidpointFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected MidpointFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new MidpointFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        CalculusFieldElement[] interpolatedDerivatives;
        CalculusFieldElement[] interpolatedState;
        CalculusFieldElement coeffDot2 = (CalculusFieldElement)theta.multiply(2);
        CalculusFieldElement coeffDot1 = (CalculusFieldElement)((CalculusFieldElement)time.getField().getOne()).subtract((FieldElement)coeffDot2);
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            CalculusFieldElement coeff1 = (CalculusFieldElement)theta.multiply(oneMinusThetaH);
            CalculusFieldElement coeff2 = (CalculusFieldElement)theta.multiply(thetaH);
            interpolatedState = this.previousStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff2});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot2});
        } else {
            CalculusFieldElement coeff1 = (CalculusFieldElement)oneMinusThetaH.multiply(theta);
            CalculusFieldElement coeff2 = (CalculusFieldElement)((CalculusFieldElement)oneMinusThetaH.multiply((FieldElement)((CalculusFieldElement)theta.add(1.0)))).negate();
            interpolatedState = this.currentStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff2});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot2});
        }
        return mapper.mapStateAndDerivative((CalculusFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

