/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.hipparchus.ode.nonstiff.FieldExplicitRungeKuttaIntegrator;
import org.hipparchus.ode.nonstiff.HighamHall54FieldStateInterpolator;
import org.hipparchus.ode.nonstiff.HighamHall54Integrator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class HighamHall54FieldIntegrator<T extends CalculusFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    public static final String METHOD_NAME = "Higham-Hall 5(4)";

    public HighamHall54FieldIntegrator(Field<T> field, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(field, METHOD_NAME, -1, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public HighamHall54FieldIntegrator(Field<T> field, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, METHOD_NAME, -1, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)6);
        c[0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 2, 9);
        c[1] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 3);
        c[2] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 2);
        c[3] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3, 5);
        c[4] = (CalculusFieldElement)this.getField().getOne();
        c[5] = (CalculusFieldElement)this.getField().getOne();
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)6, (int)-1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)(i + 1));
        }
        a[0][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 2, 9);
        a[1][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 12);
        a[1][1] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 4);
        a[2][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 8);
        a[2][1] = (CalculusFieldElement)this.getField().getZero();
        a[2][2] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3, 8);
        a[3][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 91, 500);
        a[3][1] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -27, 100);
        a[3][2] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 78, 125);
        a[3][3] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 8, 125);
        a[4][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -11, 20);
        a[4][1] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 27, 20);
        a[4][2] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 12, 5);
        a[4][3] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -36, 5);
        a[4][4] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 5, 1);
        a[5][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 12);
        a[5][1] = (CalculusFieldElement)this.getField().getZero();
        a[5][2] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 27, 32);
        a[5][3] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -4, 3);
        a[5][4] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 125, 96);
        a[5][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 5, 48);
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)7);
        b[0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 12);
        b[1] = (CalculusFieldElement)this.getField().getZero();
        b[2] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 27, 32);
        b[3] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -4, 3);
        b[4] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 125, 96);
        b[5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 5, 48);
        b[6] = (CalculusFieldElement)this.getField().getZero();
        return b;
    }

    @Override
    protected HighamHall54FieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new HighamHall54FieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    protected double estimateError(T[][] yDotK, T[] y0, T[] y1, T h) {
        StepsizeHelper helper = this.getStepSizeHelper();
        double error = 0.0;
        for (int j = 0; j < helper.getMainSetDimension(); ++j) {
            double errSum = HighamHall54Integrator.STATIC_E[0] * yDotK[0][j].getReal();
            for (int l = 1; l < HighamHall54Integrator.STATIC_E.length; ++l) {
                errSum += HighamHall54Integrator.STATIC_E[l] * yDotK[l][j].getReal();
            }
            double tol = helper.getTolerance(j, FastMath.max((double)FastMath.abs((double)y0[j].getReal()), (double)FastMath.abs((double)y1[j].getReal())));
            double ratio = h.getReal() * errSum / tol;
            error += ratio * ratio;
        }
        return FastMath.sqrt((double)(error / (double)helper.getMainSetDimension()));
    }
}

