/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaStateInterpolator;
import org.hipparchus.util.FastMath;

class GillStateInterpolator
extends RungeKuttaStateInterpolator {
    private static final double ONE_MINUS_INV_SQRT_2 = 1.0 - FastMath.sqrt((double)0.5);
    private static final double ONE_PLUS_INV_SQRT_2 = 1.0 + FastMath.sqrt((double)0.5);
    private static final long serialVersionUID = 20160328L;

    GillStateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected GillStateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new GillStateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedDerivatives;
        double[] interpolatedState;
        double twoTheta = 2.0 * theta;
        double fourTheta2 = twoTheta * twoTheta;
        double coeffDot1 = theta * (twoTheta - 3.0) + 1.0;
        double cDot23 = twoTheta * (1.0 - theta);
        double coeffDot2 = cDot23 * ONE_MINUS_INV_SQRT_2;
        double coeffDot3 = cDot23 * ONE_PLUS_INV_SQRT_2;
        double coeffDot4 = theta * (twoTheta - 1.0);
        if (this.getGlobalPreviousState() != null && theta <= 0.5) {
            double s = thetaH / 6.0;
            double c23 = s * (6.0 * theta - fourTheta2);
            double coeff1 = s * (6.0 - 9.0 * theta + fourTheta2);
            double coeff2 = c23 * ONE_MINUS_INV_SQRT_2;
            double coeff3 = c23 * ONE_PLUS_INV_SQRT_2;
            double coeff4 = s * (-3.0 * theta + fourTheta2);
            interpolatedState = this.previousStateLinearCombination(coeff1, coeff2, coeff3, coeff4);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, coeffDot2, coeffDot3, coeffDot4);
        } else {
            double s = oneMinusThetaH / -6.0;
            double c23 = s * (2.0 + twoTheta - fourTheta2);
            double coeff1 = s * (1.0 - 5.0 * theta + fourTheta2);
            double coeff2 = c23 * ONE_MINUS_INV_SQRT_2;
            double coeff3 = c23 * ONE_PLUS_INV_SQRT_2;
            double coeff4 = s * (1.0 + theta + fourTheta2);
            interpolatedState = this.currentStateLinearCombination(coeff1, coeff2, coeff3, coeff4);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, coeffDot2, coeffDot3, coeffDot4);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

