/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.nonstiff.ButcherArrayProvider;

public interface ExplicitRungeKuttaIntegrator
extends ButcherArrayProvider,
ODEIntegrator {
    default public int getNumberOfStages() {
        return this.getB().length;
    }

    default public double[] singleStep(OrdinaryDifferentialEquation equations, double t0, double[] y0, double t) {
        int stages = this.getNumberOfStages();
        double[][] yDotK = new double[stages][];
        double h = t - t0;
        ExpandableODE expandableODE = new ExpandableODE(equations);
        yDotK[0] = expandableODE.computeDerivatives(t0, y0);
        ExplicitRungeKuttaIntegrator.applyInternalButcherWeights(expandableODE, t0, y0, h, this.getA(), this.getC(), yDotK);
        return ExplicitRungeKuttaIntegrator.applyExternalButcherWeights(y0, yDotK, h, this.getB());
    }

    public static void applyInternalButcherWeights(ExpandableODE equations, double t0, double[] y0, double h, double[][] a, double[] c, double[][] yDotK) {
        int stages = c.length + 1;
        double[] yTmp = (double[])y0.clone();
        for (int k = 1; k < stages; ++k) {
            for (int j = 0; j < y0.length; ++j) {
                double sum = yDotK[0][j] * a[k - 1][0];
                for (int l = 1; l < k; ++l) {
                    sum += yDotK[l][j] * a[k - 1][l];
                }
                yTmp[j] = y0[j] + h * sum;
            }
            yDotK[k] = equations.computeDerivatives(t0 + h * c[k - 1], yTmp);
        }
    }

    public static double[] applyExternalButcherWeights(double[] y0, double[][] yDotK, double h, double[] b) {
        double[] y = (double[])y0.clone();
        int stages = b.length;
        int j = 0;
        while (j < y0.length) {
            double sum = yDotK[0][j] * b[0];
            for (int l = 1; l < stages; ++l) {
                sum += yDotK[l][j] * b[l];
            }
            int n = j++;
            y[n] = y[n] + h * sum;
        }
        return y;
    }
}

