/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.EulerFieldStateInterpolator;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.hipparchus.util.MathArrays;

public class EulerFieldIntegrator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public static final String METHOD_NAME = "Euler";

    public EulerFieldIntegrator(Field<T> field, T step) {
        super(field, METHOD_NAME, step);
    }

    @Override
    public T[] getC() {
        return (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)0);
    }

    @Override
    public T[][] getA() {
        return (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)0, (int)0);
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)1);
        b[0] = (CalculusFieldElement)this.getField().getOne();
        return b;
    }

    @Override
    protected EulerFieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new EulerFieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

