/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldMatrixPreservingVisitor;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.nonstiff.AdamsFieldIntegrator;
import org.hipparchus.ode.nonstiff.AdamsFieldStateInterpolator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class AdamsMoultonFieldIntegrator<T extends CalculusFieldElement<T>>
extends AdamsFieldIntegrator<T> {
    public static final String METHOD_NAME = "Adams-Moulton";

    public AdamsMoultonFieldIntegrator(Field<T> field, int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(field, METHOD_NAME, nSteps, nSteps + 1, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public AdamsMoultonFieldIntegrator(Field<T> field, int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(field, METHOD_NAME, nSteps, nSteps + 1, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    protected double errorEstimation(T[] previousState, T predictedTime, T[] predictedState, T[] predictedScaled, FieldMatrix<T> predictedNordsieck) {
        double error = ((CalculusFieldElement)predictedNordsieck.walkInOptimizedOrder((FieldMatrixPreservingVisitor)new Corrector(this, previousState, predictedScaled, predictedState))).getReal();
        if (Double.isNaN(error)) {
            throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{predictedTime.getReal()});
        }
        return error;
    }

    @Override
    protected AdamsFieldStateInterpolator<T> finalizeStep(T stepSize, T[] predictedY, T[] predictedScaled, Array2DRowFieldMatrix<T> predictedNordsieck, boolean isForward, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> equationsMapper) {
        CalculusFieldElement[] correctedYDot = this.computeDerivatives((CalculusFieldElement)globalCurrentState.getTime(), (CalculusFieldElement[])predictedY);
        CalculusFieldElement[] correctedScaled = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)predictedY.length);
        for (int j = 0; j < correctedScaled.length; ++j) {
            correctedScaled[j] = (CalculusFieldElement)this.getStepSize().multiply((FieldElement)correctedYDot[j]);
        }
        this.updateHighOrderDerivativesPhase2((CalculusFieldElement[])predictedScaled, correctedScaled, (Array2DRowFieldMatrix)predictedNordsieck);
        FieldODEStateAndDerivative updatedStepEnd = equationsMapper.mapStateAndDerivative((CalculusFieldElement)globalCurrentState.getTime(), (CalculusFieldElement[])predictedY, correctedYDot);
        return new AdamsFieldStateInterpolator(this.getStepSize(), updatedStepEnd, correctedScaled, predictedNordsieck, isForward, this.getStepStart(), updatedStepEnd, equationsMapper);
    }

    private static class Corrector
    implements FieldMatrixPreservingVisitor<T> {
        private final T[] previous;
        private final T[] scaled;
        private final T[] before;
        private final T[] after;
        final /* synthetic */ AdamsMoultonFieldIntegrator this$0;

        Corrector(T[] previous, T[] scaled, T[] state) {
            this.this$0 = var1_1;
            this.previous = previous;
            this.scaled = scaled;
            this.after = state;
            this.before = (CalculusFieldElement[])state.clone();
        }

        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            Arrays.fill(this.after, this.this$0.getField().getZero());
        }

        public void visit(int row, int column, T value) {
            this.after[column] = (row & 1) == 0 ? (CalculusFieldElement)this.after[column].subtract(value) : (CalculusFieldElement)this.after[column].add(value);
        }

        public T end() {
            StepsizeHelper helper = this.this$0.getStepSizeHelper();
            CalculusFieldElement error = (CalculusFieldElement)this.this$0.getField().getZero();
            for (int i = 0; i < this.after.length; ++i) {
                this.after[i] = (CalculusFieldElement)this.after[i].add((FieldElement)((CalculusFieldElement)this.previous[i].add(this.scaled[i])));
                if (i >= helper.getMainSetDimension()) continue;
                CalculusFieldElement tol = helper.getTolerance(i, MathUtils.max((CalculusFieldElement)((CalculusFieldElement)this.previous[i].abs()), (CalculusFieldElement)((CalculusFieldElement)this.after[i].abs())));
                CalculusFieldElement ratio = (CalculusFieldElement)((CalculusFieldElement)this.after[i].subtract(this.before[i])).divide((FieldElement)tol);
                error = (CalculusFieldElement)error.add((FieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)ratio)));
            }
            return (CalculusFieldElement)((CalculusFieldElement)error.divide((double)helper.getMainSetDimension())).sqrt();
        }
    }
}

