/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.MultistepIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdamsNordsieckTransformer;
import org.hipparchus.ode.nonstiff.AdamsStateInterpolator;

public abstract class AdamsIntegrator
extends MultistepIntegrator {
    private final AdamsNordsieckTransformer transformer;

    public AdamsIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(name, nSteps, order, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.transformer = AdamsNordsieckTransformer.getInstance(nSteps);
    }

    public AdamsIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(name, nSteps, order, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.transformer = AdamsNordsieckTransformer.getInstance(nSteps);
    }

    @Override
    public ODEStateAndDerivative integrate(ExpandableODE equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = finalTime > initialState.getTime();
        this.start(equations, this.getStepStart(), finalTime);
        ODEStateAndDerivative stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), this.getStepStart().getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
        this.setIsLastStep(false);
        double[] y = this.getStepStart().getCompleteState();
        do {
            double[] predictedY = null;
            double[] predictedScaled = new double[y.length];
            Array2DRowRealMatrix predictedNordsieck = null;
            double error = 10.0;
            while (error >= 1.0) {
                predictedY = stepEnd.getCompleteState();
                double[] yDot = this.computeDerivatives(stepEnd.getTime(), predictedY);
                for (int j = 0; j < predictedScaled.length; ++j) {
                    predictedScaled[j] = this.getStepSize() * yDot[j];
                }
                predictedNordsieck = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, predictedScaled, predictedNordsieck);
                error = this.errorEstimation(y, stepEnd.getTime(), predictedY, predictedScaled, (RealMatrix)predictedNordsieck);
                if (Double.isNaN(error)) {
                    throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{stepEnd.getTime()});
                }
                if (!(error >= 1.0)) continue;
                double factor = this.computeStepGrowShrinkFactor(error);
                this.rescale(this.getStepSizeHelper().filterStep(this.getStepSize() * factor, forward, false));
                stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), this.getStepStart().getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
            }
            AdamsStateInterpolator interpolator = this.finalizeStep(this.getStepSize(), predictedY, predictedScaled, predictedNordsieck, forward, this.getStepStart(), stepEnd, equations.getMapper());
            this.setStepStart(this.acceptStep(interpolator, finalTime));
            this.scaled = interpolator.getScaled();
            this.nordsieck = interpolator.getNordsieck();
            if (this.isLastStep()) continue;
            if (this.resetOccurred()) {
                this.start(equations, this.getStepStart(), finalTime);
                double nextT = this.getStepStart().getTime() + this.getStepSize();
                boolean nextIsLast = forward ? nextT >= finalTime : nextT <= finalTime;
                double hNew = nextIsLast ? finalTime - this.getStepStart().getTime() : this.getStepSize();
                this.rescale(hNew);
                System.arraycopy(this.getStepStart().getCompleteState(), 0, y, 0, y.length);
            } else {
                boolean filteredNextIsLast;
                double factor = this.computeStepGrowShrinkFactor(error);
                double scaledH = this.getStepSize() * factor;
                double nextT = this.getStepStart().getTime() + scaledH;
                boolean nextIsLast = forward ? nextT >= finalTime : nextT <= finalTime;
                double hNew = this.getStepSizeHelper().filterStep(scaledH, forward, nextIsLast);
                double filteredNextT = this.getStepStart().getTime() + hNew;
                boolean bl = forward ? filteredNextT >= finalTime : (filteredNextIsLast = filteredNextT <= finalTime);
                if (filteredNextIsLast) {
                    hNew = finalTime - this.getStepStart().getTime();
                }
                this.rescale(hNew);
                System.arraycopy(predictedY, 0, y, 0, y.length);
            }
            stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), this.getStepStart().getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
        } while (!this.isLastStep());
        ODEStateAndDerivative finalState = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(Double.NaN);
        return finalState;
    }

    @Override
    protected Array2DRowRealMatrix initializeHighOrderDerivatives(double h, double[] t, double[][] y, double[][] yDot) {
        return this.transformer.initializeHighOrderDerivatives(h, t, y, yDot);
    }

    public Array2DRowRealMatrix updateHighOrderDerivativesPhase1(Array2DRowRealMatrix highOrder) {
        return this.transformer.updateHighOrderDerivativesPhase1(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(double[] start, double[] end, Array2DRowRealMatrix highOrder) {
        this.transformer.updateHighOrderDerivativesPhase2(start, end, highOrder);
    }

    protected abstract double errorEstimation(double[] var1, double var2, double[] var4, double[] var5, RealMatrix var6);

    protected abstract AdamsStateInterpolator finalizeStep(double var1, double[] var3, double[] var4, Array2DRowRealMatrix var5, boolean var6, ODEStateAndDerivative var7, ODEStateAndDerivative var8, EquationsMapper var9);
}

