/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.sampling.AbstractFieldODEStateInterpolator;
import org.hipparchus.util.MathArrays;

class AdamsFieldStateInterpolator<T extends CalculusFieldElement<T>>
extends AbstractFieldODEStateInterpolator<T> {
    private T scalingH;
    private final FieldODEStateAndDerivative<T> reference;
    private final T[] scaled;
    private final Array2DRowFieldMatrix<T> nordsieck;

    AdamsFieldStateInterpolator(T stepSize, FieldODEStateAndDerivative<T> reference, T[] scaled, Array2DRowFieldMatrix<T> nordsieck, boolean isForward, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> equationsMapper) {
        this((CalculusFieldElement)stepSize, reference, (CalculusFieldElement[])scaled, (Array2DRowFieldMatrix)nordsieck, isForward, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, equationsMapper);
    }

    private AdamsFieldStateInterpolator(T stepSize, FieldODEStateAndDerivative<T> reference, T[] scaled, Array2DRowFieldMatrix<T> nordsieck, boolean isForward, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> equationsMapper) {
        super(isForward, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, equationsMapper);
        this.scalingH = stepSize;
        this.reference = reference;
        this.scaled = (CalculusFieldElement[])scaled.clone();
        this.nordsieck = new Array2DRowFieldMatrix((FieldElement[][])((CalculusFieldElement[][])nordsieck.getData()), false);
    }

    @Override
    protected AdamsFieldStateInterpolator<T> create(boolean newForward, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new AdamsFieldStateInterpolator(this.scalingH, this.reference, this.scaled, this.nordsieck, newForward, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    public T[] getScaled() {
        return (CalculusFieldElement[])this.scaled.clone();
    }

    public Array2DRowFieldMatrix<T> getNordsieck() {
        return this.nordsieck;
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> equationsMapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        return AdamsFieldStateInterpolator.taylor(equationsMapper, this.reference, time, this.scalingH, this.scaled, this.nordsieck);
    }

    public static <S extends CalculusFieldElement<S>> FieldODEStateAndDerivative<S> taylor(FieldEquationsMapper<S> equationsMapper, FieldODEStateAndDerivative<S> reference, S time, S stepSize, S[] scaled, Array2DRowFieldMatrix<S> nordsieck) {
        CalculusFieldElement x = (CalculusFieldElement)time.subtract(reference.getTime());
        CalculusFieldElement normalizedAbscissa = (CalculusFieldElement)x.divide(stepSize);
        Object[] stateVariation = (CalculusFieldElement[])MathArrays.buildArray((Field)time.getField(), (int)scaled.length);
        Arrays.fill(stateVariation, time.getField().getZero());
        Object[] estimatedDerivatives = (CalculusFieldElement[])MathArrays.buildArray((Field)time.getField(), (int)scaled.length);
        Arrays.fill(estimatedDerivatives, time.getField().getZero());
        CalculusFieldElement[][] nData = (CalculusFieldElement[][])nordsieck.getDataRef();
        for (int i = nData.length - 1; i >= 0; --i) {
            int order = i + 2;
            CalculusFieldElement[] nDataI = nData[i];
            CalculusFieldElement power = (CalculusFieldElement)normalizedAbscissa.pow(order);
            for (int j = 0; j < nDataI.length; ++j) {
                CalculusFieldElement d = (CalculusFieldElement)nDataI[j].multiply((FieldElement)power);
                stateVariation[j] = (CalculusFieldElement)stateVariation[j].add((FieldElement)d);
                estimatedDerivatives[j] = (CalculusFieldElement)estimatedDerivatives[j].add((FieldElement)((CalculusFieldElement)d.multiply(order)));
            }
        }
        CalculusFieldElement[] estimatedState = reference.getCompleteState();
        for (int j = 0; j < stateVariation.length; ++j) {
            stateVariation[j] = (CalculusFieldElement)stateVariation[j].add((FieldElement)((CalculusFieldElement)scaled[j].multiply((FieldElement)normalizedAbscissa)));
            estimatedState[j] = (CalculusFieldElement)estimatedState[j].add((FieldElement)stateVariation[j]);
            estimatedDerivatives[j] = (CalculusFieldElement)((CalculusFieldElement)estimatedDerivatives[j].add((FieldElement)((CalculusFieldElement)scaled[j].multiply((FieldElement)normalizedAbscissa)))).divide((FieldElement)x);
        }
        return equationsMapper.mapStateAndDerivative(time, estimatedState, (CalculusFieldElement[])estimatedDerivatives);
    }
}

