/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedRealFieldUnivariateSolver;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldEventOccurrence;
import org.hipparchus.ode.events.FieldEventState;
import org.hipparchus.ode.events.FieldODEEventDetector;
import org.hipparchus.ode.events.FieldODEEventHandler;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.util.FastMath;

public class FieldDetectorBasedEventState<T extends CalculusFieldElement<T>>
implements FieldEventState<T> {
    private final FieldODEEventDetector<T> detector;
    private final BracketedRealFieldUnivariateSolver<T> solver;
    private final FieldODEEventHandler<T> handler;
    private T lastT;
    private T lastG;
    private T t0;
    private T g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private T pendingEventTime;
    private T stopTime;
    private T afterEvent;
    private T afterG;
    private T earliestTimeConsidered;
    private boolean forward;
    private boolean increasing;

    public FieldDetectorBasedEventState(FieldODEEventDetector<T> detector) {
        this.detector = detector;
        this.solver = detector.getSolver();
        this.handler = detector.getHandler();
        this.t0 = null;
        this.g0 = null;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.increasing = true;
        this.earliestTimeConsidered = null;
        this.afterEvent = null;
        this.afterG = null;
    }

    public FieldODEEventDetector<T> getEventDetector() {
        return this.detector;
    }

    @Override
    public void init(FieldODEStateAndDerivative<T> s0, T t) {
        this.detector.init(s0, t);
        this.lastT = (CalculusFieldElement)((CalculusFieldElement)t.getField().getZero()).newInstance(Double.NEGATIVE_INFINITY);
        this.lastG = null;
    }

    private T g(FieldODEStateAndDerivative<T> s) {
        if (!((CalculusFieldElement)s.getTime().subtract(this.lastT)).isZero()) {
            this.lastG = this.detector.g(s);
            this.lastT = s.getTime();
        }
        return this.lastG;
    }

    public void reinitializeBegin(FieldODEStateInterpolator<T> interpolator) throws MathIllegalStateException {
        this.forward = interpolator.isForward();
        FieldODEStateAndDerivative<T> s0 = interpolator.getPreviousState();
        this.t0 = s0.getTime();
        this.g0 = this.g(s0);
        while (this.g0.isZero()) {
            Object tStart = (CalculusFieldElement)this.t0.add((FieldElement)((CalculusFieldElement)this.solver.getAbsoluteAccuracy().multiply(this.forward ? 0.5 : -0.5)));
            if (tStart.equals(this.t0)) {
                tStart = this.nextAfter(this.t0);
            }
            this.t0 = tStart;
            this.g0 = this.g(interpolator.getInterpolatedState((CalculusFieldElement)tStart));
        }
        this.increasing = this.g0Positive = this.g0.getReal() > 0.0;
    }

    @Override
    public boolean evaluateStep(FieldODEStateInterpolator<T> interpolator) throws MathIllegalArgumentException, MathIllegalStateException {
        this.forward = interpolator.isForward();
        FieldODEStateAndDerivative<T> s0 = interpolator.getPreviousState();
        FieldODEStateAndDerivative<T> s1 = interpolator.getCurrentState();
        Object t1 = s1.getTime();
        CalculusFieldElement dt = (CalculusFieldElement)t1.subtract(this.t0);
        if (((CalculusFieldElement)((CalculusFieldElement)dt.abs()).subtract((FieldElement)this.solver.getAbsoluteAccuracy())).getReal() < 0.0) {
            this.pendingEvent = false;
            this.pendingEventTime = null;
            return false;
        }
        T ta = this.t0;
        T ga = this.g0;
        FieldODEStateAndDerivative<T> sb = this.nextCheck(s0, s1, interpolator);
        while (sb != null) {
            Object tb = sb.getTime();
            T gb = this.g(sb);
            if (gb.getReal() == 0.0 || this.g0Positive ^ gb.getReal() > 0.0) {
                if (this.findRoot(interpolator, ta, ga, tb, gb)) {
                    return true;
                }
            } else {
                ta = tb;
                ga = gb;
            }
            sb = this.nextCheck(sb, s1, interpolator);
        }
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return false;
    }

    private FieldODEStateAndDerivative<T> nextCheck(FieldODEStateAndDerivative<T> done, FieldODEStateAndDerivative<T> target, FieldODEStateInterpolator<T> interpolator) {
        if (done == target) {
            return null;
        }
        CalculusFieldElement dt = (CalculusFieldElement)target.getTime().subtract(done.getTime());
        double maxCheck = this.detector.getMaxCheckInterval().currentInterval(done);
        int n = FastMath.max((int)1, (int)((int)FastMath.ceil((double)((CalculusFieldElement)((CalculusFieldElement)dt.abs()).divide(maxCheck)).getReal())));
        return n == 1 ? target : interpolator.getInterpolatedState((CalculusFieldElement)done.getTime().add((FieldElement)((CalculusFieldElement)dt.divide((double)n))));
    }

    private boolean findRoot(FieldODEStateInterpolator<T> interpolator, T ta, T ga, T tb, T gb) {
        this.check(ga.getReal() == 0.0 || gb.getReal() == 0.0 || ga.getReal() > 0.0 && gb.getReal() < 0.0 || ga.getReal() < 0.0 && gb.getReal() > 0.0);
        int maxIterationCount = this.detector.getMaxIterationCount();
        CalculusFieldUnivariateFunction f = t -> this.g(interpolator.getInterpolatedState(t));
        Object loopT = ta;
        Object loopG = ga;
        Object beforeRootT = null;
        CalculusFieldElement beforeRootG = null;
        Object afterRootT = ta;
        CalculusFieldElement afterRootG = (CalculusFieldElement)ta.getField().getZero();
        if (ta.getReal() == tb.getReal()) {
            beforeRootT = ta;
            beforeRootG = (CalculusFieldElement)ga;
            afterRootT = this.shiftedBy(beforeRootT, this.solver.getAbsoluteAccuracy());
            afterRootG = f.value(afterRootT);
        } else if (!ga.isZero() && gb.isZero()) {
            beforeRootT = tb;
            beforeRootG = (CalculusFieldElement)gb;
            afterRootT = this.shiftedBy(beforeRootT, this.solver.getAbsoluteAccuracy());
            afterRootG = f.value(afterRootT);
        } else if (!ga.isZero()) {
            CalculusFieldElement newGa = f.value(ta);
            if (ga.getReal() > 0.0 != newGa.getReal() > 0.0) {
                CalculusFieldElement nextT = this.minTime(this.shiftedBy(ta, this.solver.getAbsoluteAccuracy()), tb);
                CalculusFieldElement nextG = f.value(nextT);
                if (nextG.getReal() > 0.0 == this.g0Positive) {
                    loopT = nextT;
                    loopG = nextG;
                } else {
                    beforeRootT = ta;
                    beforeRootG = newGa;
                    afterRootT = nextT;
                    afterRootG = nextG;
                }
            }
        }
        while ((afterRootG.isZero() || afterRootG.getReal() > 0.0 == this.g0Positive) && this.strictlyAfter(afterRootT, tb)) {
            if (loopG.getReal() == 0.0) {
                beforeRootT = loopT;
                beforeRootG = (CalculusFieldElement)loopG;
                afterRootT = this.minTime(this.shiftedBy(beforeRootT, this.solver.getAbsoluteAccuracy()), tb);
                afterRootG = f.value(afterRootT);
            } else {
                BracketedRealFieldUnivariateSolver.Interval interval;
                if (this.forward) {
                    try {
                        interval = this.solver.solveInterval(maxIterationCount, f, loopT, tb);
                        beforeRootT = interval.getLeftAbscissa();
                        beforeRootG = interval.getLeftValue();
                        afterRootT = interval.getRightAbscissa();
                        afterRootG = interval.getRightValue();
                    }
                    catch (RuntimeException e) {
                        throw new MathIllegalStateException((Throwable)e, (Localizable)LocalizedODEFormats.FIND_ROOT, new Object[]{this.detector, loopT.getReal(), loopG.getReal(), tb.getReal(), gb.getReal(), this.lastT.getReal(), this.lastG.getReal()});
                    }
                }
                try {
                    interval = this.solver.solveInterval(maxIterationCount, f, tb, loopT);
                    beforeRootT = interval.getRightAbscissa();
                    beforeRootG = interval.getRightValue();
                    afterRootT = interval.getLeftAbscissa();
                    afterRootG = interval.getLeftValue();
                }
                catch (RuntimeException e) {
                    throw new MathIllegalStateException((Throwable)e, (Localizable)LocalizedODEFormats.FIND_ROOT, new Object[]{this.detector, tb.getReal(), gb.getReal(), loopT.getReal(), loopG.getReal(), this.lastT.getReal(), this.lastG.getReal()});
                }
            }
            if (beforeRootT == afterRootT) {
                afterRootT = this.nextAfter(afterRootT);
                afterRootG = f.value(afterRootT);
            }
            this.check(this.forward && afterRootT.getReal() > beforeRootT.getReal() || !this.forward && afterRootT.getReal() < beforeRootT.getReal());
            loopT = afterRootT;
            loopG = afterRootG;
        }
        if (afterRootG.getReal() == 0.0 || afterRootG.getReal() > 0.0 == this.g0Positive) {
            return false;
        }
        this.check(beforeRootT != null && beforeRootG != null);
        this.increasing = !this.g0Positive;
        this.pendingEventTime = beforeRootT;
        this.stopTime = beforeRootG.isZero() ? beforeRootT : afterRootT;
        this.pendingEvent = true;
        this.afterEvent = afterRootT;
        this.afterG = afterRootG;
        this.check(this.afterG.getReal() > 0.0 == this.increasing);
        this.check(this.increasing == gb.getReal() >= ga.getReal());
        return true;
    }

    public boolean tryAdvance(FieldODEStateAndDerivative<T> state, FieldODEStateInterpolator<T> interpolator) {
        boolean meFirst;
        Object t = state.getTime();
        this.check(!this.pendingEvent || !this.strictlyAfter(this.pendingEventTime, t));
        if (this.earliestTimeConsidered != null && this.strictlyAfter(t, this.earliestTimeConsidered)) {
            meFirst = false;
        } else {
            boolean positive;
            T g = this.g(state);
            boolean bl = positive = g.getReal() > 0.0;
            if (positive == this.g0Positive) {
                this.g0 = g;
                meFirst = false;
            } else {
                T oldPendingEventTime = this.pendingEventTime;
                boolean foundRoot = this.findRoot(interpolator, this.t0, this.g0, t, g);
                boolean bl2 = meFirst = foundRoot && !this.pendingEventTime.equals(oldPendingEventTime);
            }
        }
        if (!meFirst) {
            this.t0 = t;
        }
        return meFirst;
    }

    @Override
    public FieldEventOccurrence<T> doEvent(FieldODEStateAndDerivative<T> state) {
        this.check(this.pendingEvent);
        this.check(state.getTime() == this.pendingEventTime);
        Action action = this.handler.eventOccurred(state, this.detector, this.increasing == this.forward);
        FieldODEState newState = action == Action.RESET_STATE ? this.handler.resetState(this.detector, state) : state;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.earliestTimeConsidered = this.afterEvent;
        this.t0 = this.afterEvent;
        this.g0 = this.afterG;
        this.g0Positive = this.increasing;
        this.check(this.g0.isZero() || this.g0Positive == this.g0.getReal() > 0.0);
        return new FieldEventOccurrence<T>(action, newState, this.stopTime);
    }

    private boolean strictlyAfter(T t1, T t2) {
        return this.forward ? t1.getReal() < t2.getReal() : t2.getReal() < t1.getReal();
    }

    private T nextAfter(T t) {
        int sign = this.forward ? 1 : -1;
        double ulp = FastMath.ulp((double)t.getReal());
        return (T)((CalculusFieldElement)t.add((double)sign * ulp));
    }

    private void check(boolean condition) throws MathRuntimeException {
        if (!condition) {
            throw MathRuntimeException.createInternalError();
        }
    }

    private T minTime(T a, T b) {
        return (T)(this.forward ? FastMath.min(a, b) : FastMath.max(a, b));
    }

    private T shiftedBy(T t, T delta) {
        if (this.forward) {
            CalculusFieldElement ret = (CalculusFieldElement)t.add(delta);
            if (((CalculusFieldElement)ret.subtract(t)).getReal() > delta.getReal()) {
                return (T)((CalculusFieldElement)ret.subtract(FastMath.ulp((double)ret.getReal())));
            }
            return (T)ret;
        }
        CalculusFieldElement ret = (CalculusFieldElement)t.subtract(delta);
        if (((CalculusFieldElement)t.subtract((FieldElement)ret)).getReal() > delta.getReal()) {
            return (T)((CalculusFieldElement)ret.add(FastMath.ulp((double)ret.getReal())));
        }
        return (T)ret;
    }

    @Override
    public T getEventTime() {
        return (T)(this.pendingEvent ? this.pendingEventTime : (CalculusFieldElement)((CalculusFieldElement)this.t0.getField().getZero()).add(this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY));
    }
}

