/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.solvers.BracketedRealFieldUnivariateSolver;
import org.hipparchus.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.events.FieldAdaptableInterval;
import org.hipparchus.ode.events.FieldODEEventDetector;
import org.hipparchus.ode.events.FieldODEEventHandler;

public abstract class AbstractFieldODEDetector<T extends AbstractFieldODEDetector<T, E>, E extends CalculusFieldElement<E>>
implements FieldODEEventDetector<E> {
    public static final double DEFAULT_MAXCHECK = 600.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final int DEFAULT_MAX_ITER = 100;
    private final FieldAdaptableInterval<E> maxCheck;
    private final int maxIter;
    private final BracketedRealFieldUnivariateSolver<E> solver;
    private final FieldODEEventHandler<E> handler;
    private boolean forward;

    protected AbstractFieldODEDetector(FieldAdaptableInterval<E> maxCheck, int maxIter, BracketedRealFieldUnivariateSolver<E> solver, FieldODEEventHandler<E> handler) {
        this.maxCheck = maxCheck;
        this.maxIter = maxIter;
        this.solver = solver;
        this.handler = handler;
        this.forward = true;
    }

    @Override
    public void init(FieldODEStateAndDerivative<E> s0, E t) {
        this.forward = ((CalculusFieldElement)t.subtract(s0.getTime())).getReal() >= 0.0;
        this.getHandler().init(s0, t, this);
    }

    @Override
    public abstract E g(FieldODEStateAndDerivative<E> var1);

    @Override
    public FieldAdaptableInterval<E> getMaxCheckInterval() {
        return this.maxCheck;
    }

    @Override
    public int getMaxIterationCount() {
        return this.maxIter;
    }

    @Override
    public BracketedRealFieldUnivariateSolver<E> getSolver() {
        return this.solver;
    }

    public T withMaxCheck(E newMaxCheck) {
        return this.withMaxCheck(s -> newMaxCheck.getReal());
    }

    public T withMaxCheck(FieldAdaptableInterval<E> newMaxCheck) {
        return this.create(newMaxCheck, this.getMaxIterationCount(), this.getSolver(), this.getHandler());
    }

    public T withMaxIter(int newMaxIter) {
        return this.create(this.getMaxCheckInterval(), newMaxIter, this.getSolver(), this.getHandler());
    }

    public T withThreshold(E newThreshold) {
        CalculusFieldElement zero = (CalculusFieldElement)newThreshold.getField().getZero();
        return this.withSolver((BracketedRealFieldUnivariateSolver<E>)new FieldBracketingNthOrderBrentSolver(zero, newThreshold, zero, 5));
    }

    public T withSolver(BracketedRealFieldUnivariateSolver<E> newSolver) {
        return this.create(this.getMaxCheckInterval(), this.getMaxIterationCount(), newSolver, this.getHandler());
    }

    public T withHandler(FieldODEEventHandler<E> newHandler) {
        return this.create(this.getMaxCheckInterval(), this.getMaxIterationCount(), this.getSolver(), newHandler);
    }

    @Override
    public FieldODEEventHandler<E> getHandler() {
        return this.handler;
    }

    protected abstract T create(FieldAdaptableInterval<E> var1, int var2, BracketedRealFieldUnivariateSolver<E> var3, FieldODEEventHandler<E> var4);

    public boolean isForward() {
        return this.forward;
    }
}

