/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.DetectorBasedEventState;
import org.hipparchus.ode.events.EventOccurrence;
import org.hipparchus.ode.events.EventState;
import org.hipparchus.ode.events.ODEEventDetector;
import org.hipparchus.ode.events.ODEStepEndHandler;
import org.hipparchus.ode.events.StepEndEventState;
import org.hipparchus.ode.sampling.AbstractODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;

public abstract class AbstractIntegrator
implements ODEIntegrator {
    private List<ODEStepHandler> stepHandlers;
    private ODEStateAndDerivative stepStart;
    private double stepSize;
    private boolean isLastStep;
    private boolean resetOccurred;
    private List<DetectorBasedEventState> detectorBasedEventsStates;
    private List<StepEndEventState> stepEndEventsStates;
    private boolean statesInitialized;
    private final String name;
    private Incrementor evaluations;
    private transient ExpandableODE equations;

    protected AbstractIntegrator(String name) {
        this.name = name;
        this.stepHandlers = new ArrayList<ODEStepHandler>();
        this.stepStart = null;
        this.stepSize = Double.NaN;
        this.detectorBasedEventsStates = new ArrayList<DetectorBasedEventState>();
        this.stepEndEventsStates = new ArrayList<StepEndEventState>();
        this.statesInitialized = false;
        this.evaluations = new Incrementor();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(ODEStepHandler handler) {
        this.stepHandlers.add(handler);
    }

    @Override
    public List<ODEStepHandler> getStepHandlers() {
        return Collections.unmodifiableList(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventDetector(ODEEventDetector detector) {
        this.detectorBasedEventsStates.add(new DetectorBasedEventState(detector));
    }

    @Override
    public List<ODEEventDetector> getEventDetectors() {
        return this.detectorBasedEventsStates.stream().map(es -> es.getEventDetector()).collect(Collectors.toList());
    }

    @Override
    public void clearEventDetectors() {
        this.detectorBasedEventsStates.clear();
    }

    @Override
    public void addStepEndHandler(ODEStepEndHandler handler) {
        this.stepEndEventsStates.add(new StepEndEventState(handler));
    }

    @Override
    public List<ODEStepEndHandler> getStepEndHandlers() {
        return this.stepEndEventsStates.stream().map(es -> es.getHandler()).collect(Collectors.toList());
    }

    @Override
    public void clearStepEndHandlers() {
        this.stepEndEventsStates.clear();
    }

    @Override
    public double getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.evaluations = this.evaluations.withMaximalCount(maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    protected ODEStateAndDerivative initIntegration(ExpandableODE eqn, ODEState s0, double t) {
        this.equations = eqn;
        this.evaluations = this.evaluations.withCount(0);
        eqn.init(s0, t);
        double t0 = s0.getTime();
        double[] y0 = s0.getCompleteState();
        double[] y0Dot = this.computeDerivatives(t0, y0);
        ODEStateAndDerivative s0WithDerivatives = eqn.getMapper().mapStateAndDerivative(t0, y0, y0Dot);
        this.detectorBasedEventsStates.stream().forEach(s -> {
            s.init(s0WithDerivatives, t);
            s.getEventDetector().getHandler().init(s0WithDerivatives, t, s.getEventDetector());
        });
        this.stepEndEventsStates.stream().forEach(s -> {
            s.init(s0WithDerivatives, t);
            s.getHandler().init(s0WithDerivatives, t);
        });
        for (ODEStepHandler handler : this.stepHandlers) {
            handler.init(s0WithDerivatives, t);
        }
        this.setStateInitialized(false);
        return s0WithDerivatives;
    }

    protected ExpandableODE getEquations() {
        return this.equations;
    }

    protected Incrementor getEvaluationsCounter() {
        return this.evaluations;
    }

    public double[] computeDerivatives(double t, double[] y) throws MathIllegalArgumentException, MathIllegalStateException, NullPointerException {
        this.evaluations.increment();
        return this.equations.computeDerivatives(t, y);
    }

    protected void incrementEvaluations(int nTimes) {
        this.evaluations.increment(nTimes);
    }

    protected void setStateInitialized(boolean stateInitialized) {
        this.statesInitialized = stateInitialized;
    }

    protected ODEStateAndDerivative acceptStep(AbstractODEStateInterpolator interpolator, double tEnd) throws MathIllegalArgumentException, MathIllegalStateException {
        ODEStateAndDerivative previousState = interpolator.getGlobalPreviousState();
        ODEStateAndDerivative currentState = interpolator.getGlobalCurrentState();
        AbstractODEStateInterpolator restricted = interpolator;
        if (!this.statesInitialized) {
            this.detectorBasedEventsStates.stream().forEach(s -> s.reinitializeBegin(interpolator));
            this.statesInitialized = true;
        }
        this.stepEndEventsStates.stream().forEach(s -> s.setStepEnd(currentState.getTime()));
        final int orderingSign = interpolator.isForward() ? 1 : -1;
        PriorityQueue<EventState> occurringEvents = new PriorityQueue<EventState>(new Comparator<EventState>(){

            @Override
            public int compare(EventState es0, EventState es1) {
                return orderingSign * Double.compare(es0.getEventTime(), es1.getEventTime());
            }
        });
        this.resetOccurred = false;
        boolean doneWithStep = false;
        block0: do {
            occurringEvents.clear();
            AbstractODEStateInterpolator finalRestricted = restricted;
            Stream.concat(this.detectorBasedEventsStates.stream(), this.stepEndEventsStates.stream()).forEach(s -> {
                if (s.evaluateStep(finalRestricted)) {
                    occurringEvents.add((EventState)s);
                }
            });
            block1: while (true) {
                if (!occurringEvents.isEmpty()) {
                    EventState currentEvent = (EventState)occurringEvents.poll();
                    ODEStateAndDerivative eventState = restricted.getInterpolatedState(currentEvent.getEventTime());
                    restricted = restricted.restrictStep(previousState, eventState);
                    for (DetectorBasedEventState state : this.detectorBasedEventsStates) {
                        if (state == currentEvent || !state.tryAdvance(eventState, interpolator)) continue;
                        occurringEvents.remove(state);
                        occurringEvents.add(state);
                        occurringEvents.add(currentEvent);
                        continue block1;
                    }
                    for (ODEStepHandler handler : this.stepHandlers) {
                        handler.handleStep(restricted);
                    }
                    EventOccurrence occurrence = currentEvent.doEvent(eventState);
                    Action action = occurrence.getAction();
                    boolean bl = this.isLastStep = action == Action.STOP;
                    if (this.isLastStep) {
                        ODEStateAndDerivative savedState = eventState;
                        eventState = interpolator.getInterpolatedState(occurrence.getStopTime());
                        restricted = interpolator.restrictStep(savedState, eventState);
                        for (ODEStepHandler handler : this.stepHandlers) {
                            handler.handleStep(restricted);
                            handler.finish(restricted.getCurrentState());
                        }
                    }
                    if (this.isLastStep) {
                        return eventState;
                    }
                    if (action == Action.RESET_DERIVATIVES || action == Action.RESET_STATE) {
                        ODEState newState = occurrence.getNewState();
                        double[] y = newState.getCompleteState();
                        double[] yDot = this.computeDerivatives(newState.getTime(), y);
                        this.resetOccurred = true;
                        return this.equations.getMapper().mapStateAndDerivative(newState.getTime(), y, yDot);
                    }
                    previousState = eventState;
                    restricted = restricted.restrictStep(eventState, currentState);
                    if (action == Action.RESET_EVENTS) continue block0;
                    if (!currentEvent.evaluateStep(restricted)) continue;
                    occurringEvents.add(currentEvent);
                    continue;
                }
                for (DetectorBasedEventState state : this.detectorBasedEventsStates) {
                    if (!state.tryAdvance(currentState, interpolator)) continue;
                    occurringEvents.add(state);
                }
                if (occurringEvents.isEmpty()) break;
            }
            doneWithStep = true;
        } while (!doneWithStep);
        this.isLastStep = this.isLastStep || FastMath.abs((double)(currentState.getTime() - tEnd)) < FastMath.ulp((double)tEnd);
        for (ODEStepHandler handler : this.stepHandlers) {
            handler.handleStep(restricted);
            if (!this.isLastStep) continue;
            handler.finish(restricted.getCurrentState());
        }
        return currentState;
    }

    protected void sanityChecks(ODEState initialState, double t) throws MathIllegalArgumentException {
        double threshold = 1000.0 * FastMath.ulp((double)FastMath.max((double)FastMath.abs((double)initialState.getTime()), (double)FastMath.abs((double)t)));
        double dt = FastMath.abs((double)(initialState.getTime() - t));
        if (dt < threshold) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.TOO_SMALL_INTEGRATION_INTERVAL, new Object[]{dt, threshold, false});
        }
    }

    protected boolean resetOccurred() {
        return this.resetOccurred;
    }

    protected void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    protected double getStepSize() {
        return this.stepSize;
    }

    protected void setStepStart(ODEStateAndDerivative stepStart) {
        this.stepStart = stepStart;
    }

    @Override
    public ODEStateAndDerivative getStepStart() {
        return this.stepStart;
    }

    protected void setIsLastStep(boolean isLastStep) {
        this.isLastStep = isLastStep;
    }

    protected boolean isLastStep() {
        return this.isLastStep;
    }
}

