"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("@aws-cdk/core");
const ssm = require("../lib");
class CreatingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        new ssm.StringParameter(this, 'String', {
            parameterName: '/My/Public/Parameter',
            stringValue: 'abcdef',
        });
    }
}
class UsingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        // Retrieve the latest value of the non-secret parameter
        // with name "/My/String/Parameter".
        const stringValue = ssm.StringParameter.fromStringParameterAttributes(this, 'MyValue', {
            parameterName: '/My/Public/Parameter',
        }).stringValue;
        // Retrieve a specific version of the secret (SecureString) parameter.
        // 'version' is always required.
        const secretValue = ssm.StringParameter.fromSecureStringParameterAttributes(this, 'MySecureValue', {
            parameterName: '/My/Secret/Parameter',
            version: 5,
        });
        /// !hide
        new cdk.CfnResource(this, 'Dummy', { type: 'AWS::SNS::Topic' });
        new cdk.CfnOutput(this, 'TheValue', { value: stringValue });
        // Cannot be provisioned so cannot be actually used
        Array.isArray(secretValue);
    }
}
const app = new cdk.App();
const creating = new CreatingStack(app, 'sspms-creating');
const using = new UsingStack(app, 'sspms-using');
using.addDependency(creating);
app.synth();
//# sourceMappingURL=data:application/json;base64,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