from setuptools import find_packages, setup


def readme():
    with open("README.rst") as f:
        return f.read()


with open("filepreview/__init__.py") as f:
    # magic n stuff
    version = (
        [i for i in f.readlines() if "__version__" in i][-1]
        .split("=", 1)[1]
        .strip()
        .strip('"')
    )

setup(
    name="django-filepreview",
    version=version,
    description="Autogenerated file preview field for django files",
    long_description=readme(),
    url="https://github.com/basxsoftwareassociation/django-filepreview",
    author="basx Software Association",
    author_email="info@basx.dev",
    license="New BSD License",
    install_requires=["preview-generator", "django"],
    packages=find_packages(),
    zip_safe=False,
    include_package_data=True,
)
