
# 说明

lk_logger 是一个日志打印模块. 其亮点在于:

1. 可打印代码所在的源码位置
2. 可打印出变量名
3. 支持打印计数
4. 支持打印计时
5. 支持打印信息收集, 分析和导出
6. 可自定义回溯层级



# 使用方法

==TODO==



# 原理

## 基本工作流程

假设 A 函数调用了 LKLogger 的打印方法 (`lk.loga(x)`):

```python
# ./test.py
from lk_utils.lk_logger import lk


def main():
    x = 'hello world'
    lk.loga(x)


if __name__ == "__main__":
    main()

```

则发生以下事件:

1. LKLogger 通过快速定位功能, 获得调用者 (即函数A) 所在的文件路径, 函数名及行号
2. LKLogger 根据文件路径和行号查询自己的跟踪记录器, 看是否能找到已记录的 x 信息
3. 如果没能找到, 则:
    1. 使用深度定位功能, 获取 x 所在行的源码内容 (也就是说这里拿到了 "    lk.loga(x)" 这串文字)
    2. 通过分析器, 获得变量的字面值是 "x" (也就是从 "    lk.loga(x)" 分析出 "x" 是变量的变量名)
    3. 将变量名更新到跟踪记录器, 以便后续调用
4. 获得了 x 的变量名后, 通过拼接字符串, 获得 `变量名 = 变量值` 这样的格式, 比如 "x = 'hello world'"
5. 调用核心打印器, 将文件名, 行号, 所属函数名, `变量名 = 变量值`, 以及一些自定义的风格传进去, 从而在核心打印器中完成控制台的打印输出
6. 于是我们就看到了控制台打印出: `test.py:7  >>  main()  >>  x = 'hello world'`



