# ccf-openapi
This API provides programmatic access to data registered to the CCF.
See the [HuBMAP CCF Portal](https://hubmapconsortium.github.io/ccf/) for details.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import ccf_openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ccf_openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ccf_openapi_client
from pprint import pprint
from ccf_openapi_client.api import default_api
from ccf_openapi_client.model.aggregate_count import AggregateCount
from ccf_openapi_client.model.database_status import DatabaseStatus
from ccf_openapi_client.model.error_message import ErrorMessage
from ccf_openapi_client.model.flat_spatial_placement import FlatSpatialPlacement
from ccf_openapi_client.model.get_spatial_placement_request import GetSpatialPlacementRequest
from ccf_openapi_client.model.min_max import MinMax
from ccf_openapi_client.model.ontology_tree import OntologyTree
from ccf_openapi_client.model.sparql_query_request import SparqlQueryRequest
from ccf_openapi_client.model.spatial_entity import SpatialEntity
from ccf_openapi_client.model.spatial_scene_node import SpatialSceneNode
from ccf_openapi_client.model.spatial_search import SpatialSearch
from ccf_openapi_client.model.tissue_block import TissueBlock
# Defining the host is optional and defaults to /v1
# See configuration.py for a list of all supported configuration parameters.
configuration = ccf_openapi_client.Configuration(
    host = "/v1"
)



# Enter a context with an instance of the API client
with ccf_openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    age = MinMax(
        min=3.14,
        max=3.14,
    ) # MinMax | Filter result by age. (optional)
age_range = "10,100" # str | Filter result by age. (optional)
bmi = MinMax(
        min=3.14,
        max=3.14,
    ) # MinMax | Filter result by bmi. (optional)
bmi_range = "0,40" # str | Filter result by bmi. (optional)
cache = True # bool | Hint to cache (or not) the response of this request (optional) (default to True)
ontology_terms = [
        "ontology-terms_example",
    ] # [str] | Filter result by ontology terms. (optional)
cell_type_terms = [
        "cell-type-terms_example",
    ] # [str] | Filter result by ontology terms. (optional)
providers = [
        "providers_example",
    ] # [str] | Filter result by providers. (optional)
sex = "both" # str | Filter result by sex. (optional)
spatial = [
        SpatialSearch(
            x=3.14,
            y=3.14,
            z=3.14,
            radius=3.14,
            target="target_example",
        ),
    ] # [SpatialSearch] | Filter result by spatial searches. (optional)
technologies = [
        "technologies_example",
    ] # [str] | Filter result by technologies. (optional)
token = "token_example" # str | Authentication token to use for authenticated searches (optional)

    try:
        # Get aggregate results / statistics
        api_response = api_instance.aggregate_results(age=age, age_range=age_range, bmi=bmi, bmi_range=bmi_range, cache=cache, ontology_terms=ontology_terms, cell_type_terms=cell_type_terms, providers=providers, sex=sex, spatial=spatial, technologies=technologies, token=token)
        pprint(api_response)
    except ccf_openapi_client.ApiException as e:
        print("Exception when calling DefaultApi->aggregate_results: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**aggregate_results**](docs/DefaultApi.md#aggregate_results) | **GET** /aggregate-results | Get aggregate results / statistics
*DefaultApi* | [**cell_type_term_occurences**](docs/DefaultApi.md#cell_type_term_occurences) | **GET** /cell-type-term-occurences | Get number of cell type term occurrences for a search
*DefaultApi* | [**cell_type_tree_model**](docs/DefaultApi.md#cell_type_tree_model) | **GET** /cell-type-tree-model | Get cell type tree nodes
*DefaultApi* | [**db_status**](docs/DefaultApi.md#db_status) | **GET** /db-status | Get current status of database
*DefaultApi* | [**get_spatial_placement**](docs/DefaultApi.md#get_spatial_placement) | **POST** /get-spatial-placement | Given a SpatialEntity already placed relative to a reference SpatialEntity, retrieve a new direct SpatialPlacement to the given SpatialEntity IRI
*DefaultApi* | [**gtex_rui_locations**](docs/DefaultApi.md#gtex_rui_locations) | **GET** /gtex/rui_locations.jsonld | Get all GTEx rui locations (if enabled)
*DefaultApi* | [**hubmap_rui_locations**](docs/DefaultApi.md#hubmap_rui_locations) | **GET** /hubmap/rui_locations.jsonld | Get all hubmap rui locations (if enabled)
*DefaultApi* | [**ontology_term_occurences**](docs/DefaultApi.md#ontology_term_occurences) | **GET** /ontology-term-occurences | Get number of ontology term occurrences for a search
*DefaultApi* | [**ontology_tree_model**](docs/DefaultApi.md#ontology_tree_model) | **GET** /ontology-tree-model | Get ontology term tree nodes
*DefaultApi* | [**provider_names**](docs/DefaultApi.md#provider_names) | **GET** /provider-names | Get tissue provider names (for filtering)
*DefaultApi* | [**reference_organ_scene**](docs/DefaultApi.md#reference_organ_scene) | **GET** /reference-organ-scene | Get all nodes to form the 3D scene for an organ
*DefaultApi* | [**reference_organs**](docs/DefaultApi.md#reference_organs) | **GET** /reference-organs | Get all reference organs
*DefaultApi* | [**scene**](docs/DefaultApi.md#scene) | **GET** /scene | Get all nodes to form the 3D scene of reference body, organs, and tissues
*DefaultApi* | [**sparql**](docs/DefaultApi.md#sparql) | **GET** /sparql | Run a SPARQL query
*DefaultApi* | [**sparql_post**](docs/DefaultApi.md#sparql_post) | **POST** /sparql | Run a SPARQL query (POST)
*DefaultApi* | [**technology_names**](docs/DefaultApi.md#technology_names) | **GET** /technology-names | Get technology names (for filtering)
*DefaultApi* | [**tissue_blocks**](docs/DefaultApi.md#tissue_blocks) | **GET** /tissue-blocks | Get Tissue Block Results


## Documentation For Models

 - [AggregateCount](docs/AggregateCount.md)
 - [DatabaseStatus](docs/DatabaseStatus.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [FlatSpatialPlacement](docs/FlatSpatialPlacement.md)
 - [GetSpatialPlacementRequest](docs/GetSpatialPlacementRequest.md)
 - [JsonLdObject](docs/JsonLdObject.md)
 - [MinMax](docs/MinMax.md)
 - [OntologyTree](docs/OntologyTree.md)
 - [OntologyTreeNode](docs/OntologyTreeNode.md)
 - [Rgba](docs/Rgba.md)
 - [SparqlQueryRequest](docs/SparqlQueryRequest.md)
 - [SpatialEntity](docs/SpatialEntity.md)
 - [SpatialEntityCommon](docs/SpatialEntityCommon.md)
 - [SpatialEntityCreator](docs/SpatialEntityCreator.md)
 - [SpatialEntityDimensions](docs/SpatialEntityDimensions.md)
 - [SpatialObjectReference](docs/SpatialObjectReference.md)
 - [SpatialPlacement](docs/SpatialPlacement.md)
 - [SpatialPlacementCommon](docs/SpatialPlacementCommon.md)
 - [SpatialPlacementRotation](docs/SpatialPlacementRotation.md)
 - [SpatialPlacementScaling](docs/SpatialPlacementScaling.md)
 - [SpatialPlacementTranslation](docs/SpatialPlacementTranslation.md)
 - [SpatialSceneNode](docs/SpatialSceneNode.md)
 - [SpatialSearch](docs/SpatialSearch.md)
 - [TissueBlock](docs/TissueBlock.md)
 - [TissueCommon](docs/TissueCommon.md)
 - [TissueDataset](docs/TissueDataset.md)
 - [TissueDonor](docs/TissueDonor.md)
 - [TissueSampleCommon](docs/TissueSampleCommon.md)
 - [TissueSection](docs/TissueSection.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ccf_openapi_client.apis and ccf_openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from ccf_openapi_client.api.default_api import DefaultApi`
- `from ccf_openapi_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ccf_openapi_client
from ccf_openapi_client.apis import *
from ccf_openapi_client.models import *
```

