import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a user in PagerDuty.
 *
 * @schema CfnUserProps
 */
export interface CfnUserProps {
    /**
     * The name of the user.
     *
     * @schema CfnUserProps#Name
     */
    readonly name: string;
    /**
     * The user's email address.
     *
     * @schema CfnUserProps#Email
     */
    readonly email: string;
    /**
     * The preferred time zone name. If null, the account's time zone will be used.
     *
     * @schema CfnUserProps#TimeZone
     */
    readonly timeZone?: string;
    /**
     * The schedule color.
     *
     * @schema CfnUserProps#Color
     */
    readonly color?: string;
    /**
     * The user role. Account must have the read_only_users ability to set a user as a read_only_user or a read_only_limited_user, and must have advanced permissions abilities to set a user as observer or restricted_access.
     *
     * @schema CfnUserProps#Role
     */
    readonly role?: CfnUserPropsRole;
    /**
     * The user's bio.
     *
     * @schema CfnUserProps#Description
     */
    readonly description?: string;
    /**
     * The user's title.
     *
     * @schema CfnUserProps#JobTitle
     */
    readonly jobTitle?: string;
    /**
     * The list of contact methods for the user.
     *
     * @schema CfnUserProps#ContactMethods
     */
    readonly contactMethods?: ContactMethod[];
    /**
     * The list of notification rules for the user.
     *
     * @schema CfnUserProps#NotificationRules
     */
    readonly notificationRules?: NotificationRule[];
}
/**
 * Converts an object of type 'CfnUserProps' to JSON representation.
 */
export declare function toJson_CfnUserProps(obj: CfnUserProps | undefined): Record<string, any> | undefined;
/**
 * The user role. Account must have the read_only_users ability to set a user as a read_only_user or a read_only_limited_user, and must have advanced permissions abilities to set a user as observer or restricted_access.
 *
 * @schema CfnUserPropsRole
 */
export declare enum CfnUserPropsRole {
    /** admin */
    ADMIN = "admin",
    /** limited_user */
    LIMITED_USER = "limited_user",
    /** observer */
    OBSERVER = "observer",
    /** owner */
    OWNER = "owner",
    /** read_only_user */
    READ_ONLY_USER = "read_only_user",
    /** restricted_access */
    RESTRICTED_ACCESS = "restricted_access",
    /** read_only_limited_user */
    READ_ONLY_LIMITED_USER = "read_only_limited_user",
    /** user */
    USER = "user"
}
/**
 * @schema ContactMethod
 */
export interface ContactMethod {
    /**
     * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
     *
     * @schema ContactMethod#Type
     */
    readonly type: ContactMethodType;
    /**
     * @schema ContactMethod#Id
     */
    readonly id: string;
    /**
     * A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to name, though it is not intended to be an identifier.
     *
     * @schema ContactMethod#Summary
     */
    readonly summary?: string;
    /**
     * A URL at which the entity is uniquely displayed in the Web app
     *
     * @schema ContactMethod#HtmlUrl
     */
    readonly htmlUrl?: string;
}
/**
 * Converts an object of type 'ContactMethod' to JSON representation.
 */
export declare function toJson_ContactMethod(obj: ContactMethod | undefined): Record<string, any> | undefined;
/**
 * @schema NotificationRule
 */
export interface NotificationRule {
    /**
     * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
     *
     * @schema NotificationRule#Type
     */
    readonly type: NotificationRuleType;
    /**
     * @schema NotificationRule#Id
     */
    readonly id: string;
    /**
     * A short-form, server-generated string that provides succinct, important information about an object suitable for primary labeling of an entity in a client. In many cases, this will be identical to name, though it is not intended to be an identifier.
     *
     * @schema NotificationRule#Summary
     */
    readonly summary?: string;
    /**
     * A URL at which the entity is uniquely displayed in the Web app
     *
     * @schema NotificationRule#HtmlUrl
     */
    readonly htmlUrl?: string;
}
/**
 * Converts an object of type 'NotificationRule' to JSON representation.
 */
export declare function toJson_NotificationRule(obj: NotificationRule | undefined): Record<string, any> | undefined;
/**
 * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
 *
 * @schema ContactMethodType
 */
export declare enum ContactMethodType {
    /** email_contact_method_reference */
    EMAIL_CONTACT_METHOD_REFERENCE = "email_contact_method_reference",
    /** phone_contact_method_reference */
    PHONE_CONTACT_METHOD_REFERENCE = "phone_contact_method_reference",
    /** push_notification_contact_method_reference */
    PUSH_NOTIFICATION_CONTACT_METHOD_REFERENCE = "push_notification_contact_method_reference",
    /** sms_contact_method_reference */
    SMS_CONTACT_METHOD_REFERENCE = "sms_contact_method_reference"
}
/**
 * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
 *
 * @schema NotificationRuleType
 */
export declare enum NotificationRuleType {
    /** assignment_notification_rule_reference */
    ASSIGNMENT_NOTIFICATION_RULE_REFERENCE = "assignment_notification_rule_reference"
}
/**
 * A CloudFormation `PagerDuty::Users::User`
 *
 * @cloudformationResource PagerDuty::Users::User
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
 */
export declare class CfnUser extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "PagerDuty::Users::User";
    /**
     * Resource props.
     */
    readonly props: CfnUserProps;
    /**
     * Attribute `PagerDuty::Users::User.Id`
     * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
     */
    readonly attrId: string;
    /**
     * Attribute `PagerDuty::Users::User.Summary`
     * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
     */
    readonly attrSummary: string;
    /**
     * Attribute `PagerDuty::Users::User.Type`
     * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
     */
    readonly attrType: string;
    /**
     * Attribute `PagerDuty::Users::User.HtmlUrl`
     * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
     */
    readonly attrHtmlUrl: string;
    /**
     * Attribute `PagerDuty::Users::User.AvatarUrl`
     * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
     */
    readonly attrAvatarUrl: string;
    /**
     * Attribute `PagerDuty::Users::User.InvitationSent`
     * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
     */
    readonly attrInvitationSent: cdk.IResolvable;
    /**
     * Create a new `PagerDuty::Users::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnUserProps);
}
