/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Styleable;

public enum ParticipantType implements Styleable
{
    PARTICIPANT(ColorParam.participantBackground),
    ACTOR(ColorParam.actorBackground),
    BOUNDARY(ColorParam.boundaryBackground),
    CONTROL(ColorParam.controlBackground),
    ENTITY(ColorParam.entityBackground),
    QUEUE(ColorParam.queueBackground),
    DATABASE(ColorParam.databaseBackground),
    COLLECTIONS(ColorParam.collectionsBackground);

    private final ColorParam background;

    private ParticipantType(ColorParam background) {
        this.background = background;
    }

    public ColorParam getBackgroundColorParam() {
        return this.background;
    }

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        if (this == PARTICIPANT) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.participant);
        }
        if (this == ACTOR) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.actor);
        }
        if (this == BOUNDARY) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.boundary);
        }
        if (this == CONTROL) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.control);
        }
        if (this == ENTITY) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.entity);
        }
        if (this == QUEUE) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.queue);
        }
        if (this == DATABASE) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.database);
        }
        if (this == COLLECTIONS) {
            return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.collections);
        }
        return null;
    }
}

