# DO NOT EDIT! This file is automatically generated
import datetime
import enum
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._cart import (
        CartOrigin,
        CartReference,
        CustomLineItem,
        CustomLineItemDraft,
        DiscountCodeInfo,
        DiscountedLineItemPortion,
        InventoryMode,
        ItemShippingDetailsDraft,
        LineItem,
        RoundingMode,
        ShippingInfo,
        ShippingMethodState,
        ShippingRateInput,
        TaxCalculationMode,
        TaxedPrice,
        TaxedPriceDraft,
        TaxMode,
    )
    from ._cart_discount import CartDiscountReference
    from ._channel import ChannelReference, ChannelResourceIdentifier
    from ._common import (
        Address,
        CreatedBy,
        Image,
        LastModifiedBy,
        LocalizedString,
        Money,
        PriceDraft,
        TypedMoney,
    )
    from ._customer_group import CustomerGroupReference, CustomerGroupResourceIdentifier
    from ._payment import PaymentReference, PaymentResourceIdentifier
    from ._product import Attribute
    from ._shipping_method import ShippingMethodResourceIdentifier, ShippingRateDraft
    from ._state import StateReference, StateResourceIdentifier
    from ._store import StoreKeyReference, StoreResourceIdentifier
    from ._tax_category import TaxCategoryResourceIdentifier, TaxRate
    from ._type import (
        CustomFields,
        CustomFieldsDraft,
        FieldContainer,
        TypeResourceIdentifier,
    )
__all__ = [
    "CustomLineItemReturnItem",
    "Delivery",
    "DeliveryItem",
    "DiscountedLineItemPriceDraft",
    "ItemState",
    "LineItemImportDraft",
    "LineItemReturnItem",
    "Order",
    "OrderAddDeliveryAction",
    "OrderAddItemShippingAddressAction",
    "OrderAddParcelToDeliveryAction",
    "OrderAddPaymentAction",
    "OrderAddReturnInfoAction",
    "OrderChangeOrderStateAction",
    "OrderChangePaymentStateAction",
    "OrderChangeShipmentStateAction",
    "OrderFromCartDraft",
    "OrderImportCustomLineItemStateAction",
    "OrderImportDraft",
    "OrderImportLineItemStateAction",
    "OrderPagedQueryResponse",
    "OrderReference",
    "OrderRemoveDeliveryAction",
    "OrderRemoveItemShippingAddressAction",
    "OrderRemoveParcelFromDeliveryAction",
    "OrderRemovePaymentAction",
    "OrderResourceIdentifier",
    "OrderSetBillingAddressAction",
    "OrderSetCustomFieldAction",
    "OrderSetCustomLineItemCustomFieldAction",
    "OrderSetCustomLineItemCustomTypeAction",
    "OrderSetCustomLineItemShippingDetailsAction",
    "OrderSetCustomTypeAction",
    "OrderSetCustomerEmailAction",
    "OrderSetCustomerIdAction",
    "OrderSetDeliveryAddressAction",
    "OrderSetDeliveryItemsAction",
    "OrderSetLineItemCustomFieldAction",
    "OrderSetLineItemCustomTypeAction",
    "OrderSetLineItemShippingDetailsAction",
    "OrderSetLocaleAction",
    "OrderSetOrderNumberAction",
    "OrderSetParcelItemsAction",
    "OrderSetParcelMeasurementsAction",
    "OrderSetParcelTrackingDataAction",
    "OrderSetReturnPaymentStateAction",
    "OrderSetReturnShipmentStateAction",
    "OrderSetShippingAddressAction",
    "OrderSetStoreAction",
    "OrderState",
    "OrderTransitionCustomLineItemStateAction",
    "OrderTransitionLineItemStateAction",
    "OrderTransitionStateAction",
    "OrderUpdate",
    "OrderUpdateAction",
    "OrderUpdateItemShippingAddressAction",
    "OrderUpdateSyncInfoAction",
    "Parcel",
    "ParcelDraft",
    "ParcelMeasurements",
    "PaymentInfo",
    "PaymentState",
    "ProductVariantImportDraft",
    "ReturnInfo",
    "ReturnItem",
    "ReturnItemDraft",
    "ReturnPaymentState",
    "ReturnShipmentState",
    "ShipmentState",
    "ShippingInfoImportDraft",
    "StagedOrderUpdateAction",
    "SyncInfo",
    "TaxedItemPriceDraft",
    "TrackingData",
]


class Delivery(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]
    #: List of :class:`commercetools.types.Parcel`
    parcels: typing.List["Parcel"]
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        id: str,
        created_at: datetime.datetime,
        items: typing.List["DeliveryItem"],
        parcels: typing.List["Parcel"],
        address: typing.Optional["Address"] = None
    ) -> None:
        self.id = id
        self.created_at = created_at
        self.items = items
        self.parcels = parcels
        self.address = address
        super().__init__()

    def __repr__(self) -> str:
        return "Delivery(id=%r, created_at=%r, items=%r, parcels=%r, address=%r)" % (
            self.id,
            self.created_at,
            self.items,
            self.parcels,
            self.address,
        )


class DeliveryItem(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`int`
    quantity: int

    def __init__(self, *, id: str, quantity: int) -> None:
        self.id = id
        self.quantity = quantity
        super().__init__()

    def __repr__(self) -> str:
        return "DeliveryItem(id=%r, quantity=%r)" % (self.id, self.quantity)


class DiscountedLineItemPriceDraft(_BaseType):
    #: :class:`commercetools.types.Money`
    value: "Money"
    #: List of :class:`commercetools.types.DiscountedLineItemPortion` `(Named` ``includedDiscounts`` `in Commercetools)`
    included_discounts: typing.List["DiscountedLineItemPortion"]

    def __init__(
        self,
        *,
        value: "Money",
        included_discounts: typing.List["DiscountedLineItemPortion"]
    ) -> None:
        self.value = value
        self.included_discounts = included_discounts
        super().__init__()

    def __repr__(self) -> str:
        return "DiscountedLineItemPriceDraft(value=%r, included_discounts=%r)" % (
            self.value,
            self.included_discounts,
        )


class ItemState(_BaseType):
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateReference`
    state: "StateReference"

    def __init__(self, *, quantity: int, state: "StateReference") -> None:
        self.quantity = quantity
        self.state = state
        super().__init__()

    def __repr__(self) -> str:
        return "ItemState(quantity=%r, state=%r)" % (self.quantity, self.state)


class LineItemImportDraft(_BaseType):
    #: Optional :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: typing.Optional[str]
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"
    #: :class:`commercetools.types.ProductVariantImportDraft`
    variant: "ProductVariantImportDraft"
    #: :class:`commercetools.types.PriceDraft`
    price: "PriceDraft"
    #: :class:`int`
    quantity: int
    #: Optional list of :class:`commercetools.types.ItemState`
    state: typing.Optional[typing.List["ItemState"]]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.TaxRate` `(Named` ``taxRate`` `in Commercetools)`
    tax_rate: typing.Optional["TaxRate"]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        name: "LocalizedString",
        variant: "ProductVariantImportDraft",
        price: "PriceDraft",
        quantity: int,
        product_id: typing.Optional[str] = None,
        state: typing.Optional[typing.List["ItemState"]] = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        distribution_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        tax_rate: typing.Optional["TaxRate"] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.product_id = product_id
        self.name = name
        self.variant = variant
        self.price = price
        self.quantity = quantity
        self.state = state
        self.supply_channel = supply_channel
        self.distribution_channel = distribution_channel
        self.tax_rate = tax_rate
        self.custom = custom
        self.shipping_details = shipping_details
        super().__init__()

    def __repr__(self) -> str:
        return (
            "LineItemImportDraft(product_id=%r, name=%r, variant=%r, price=%r, quantity=%r, state=%r, supply_channel=%r, distribution_channel=%r, tax_rate=%r, custom=%r, shipping_details=%r)"
            % (
                self.product_id,
                self.name,
                self.variant,
                self.price,
                self.quantity,
                self.state,
                self.supply_channel,
                self.distribution_channel,
                self.tax_rate,
                self.custom,
                self.shipping_details,
            )
        )


class Order(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`datetime.datetime` `(Named` ``completedAt`` `in Commercetools)`
    completed_at: typing.Optional[datetime.datetime]
    #: Optional :class:`str` `(Named` ``orderNumber`` `in Commercetools)`
    order_number: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``customerEmail`` `in Commercetools)`
    customer_email: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.StoreKeyReference`
    store: typing.Optional["StoreKeyReference"]
    #: List of :class:`commercetools.types.LineItem` `(Named` ``lineItems`` `in Commercetools)`
    line_items: typing.List["LineItem"]
    #: List of :class:`commercetools.types.CustomLineItem` `(Named` ``customLineItems`` `in Commercetools)`
    custom_line_items: typing.List["CustomLineItem"]
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "TypedMoney"
    #: Optional :class:`commercetools.types.TaxedPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedPrice"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``shippingAddress`` `in Commercetools)`
    shipping_address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``billingAddress`` `in Commercetools)`
    billing_address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.TaxMode` `(Named` ``taxMode`` `in Commercetools)`
    tax_mode: typing.Optional["TaxMode"]
    #: Optional :class:`commercetools.types.RoundingMode` `(Named` ``taxRoundingMode`` `in Commercetools)`
    tax_rounding_mode: typing.Optional["RoundingMode"]
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupReference"]
    #: Optional :class:`str`
    country: typing.Optional[str]
    #: :class:`commercetools.types.OrderState` `(Named` ``orderState`` `in Commercetools)`
    order_state: "OrderState"
    #: Optional :class:`commercetools.types.StateReference`
    state: typing.Optional["StateReference"]
    #: Optional :class:`commercetools.types.ShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: typing.Optional["ShipmentState"]
    #: Optional :class:`commercetools.types.PaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: typing.Optional["PaymentState"]
    #: Optional :class:`commercetools.types.ShippingInfo` `(Named` ``shippingInfo`` `in Commercetools)`
    shipping_info: typing.Optional["ShippingInfo"]
    #: List of :class:`commercetools.types.SyncInfo` `(Named` ``syncInfo`` `in Commercetools)`
    sync_info: typing.List["SyncInfo"]
    #: Optional list of :class:`commercetools.types.ReturnInfo` `(Named` ``returnInfo`` `in Commercetools)`
    return_info: typing.Optional[typing.List["ReturnInfo"]]
    #: Optional list of :class:`commercetools.types.DiscountCodeInfo` `(Named` ``discountCodes`` `in Commercetools)`
    discount_codes: typing.Optional[typing.List["DiscountCodeInfo"]]
    #: :class:`int` `(Named` ``lastMessageSequenceNumber`` `in Commercetools)`
    last_message_sequence_number: int
    #: Optional :class:`commercetools.types.CartReference`
    cart: typing.Optional["CartReference"]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`commercetools.types.PaymentInfo` `(Named` ``paymentInfo`` `in Commercetools)`
    payment_info: typing.Optional["PaymentInfo"]
    #: Optional :class:`str`
    locale: typing.Optional[str]
    #: Optional :class:`commercetools.types.InventoryMode` `(Named` ``inventoryMode`` `in Commercetools)`
    inventory_mode: typing.Optional["InventoryMode"]
    #: :class:`commercetools.types.CartOrigin`
    origin: "CartOrigin"
    #: Optional :class:`commercetools.types.TaxCalculationMode` `(Named` ``taxCalculationMode`` `in Commercetools)`
    tax_calculation_mode: typing.Optional["TaxCalculationMode"]
    #: Optional :class:`commercetools.types.ShippingRateInput` `(Named` ``shippingRateInput`` `in Commercetools)`
    shipping_rate_input: typing.Optional["ShippingRateInput"]
    #: Optional list of :class:`commercetools.types.Address` `(Named` ``itemShippingAddresses`` `in Commercetools)`
    item_shipping_addresses: typing.Optional[typing.List["Address"]]
    #: List of :class:`commercetools.types.CartDiscountReference` `(Named` ``refusedGifts`` `in Commercetools)`
    refused_gifts: typing.List["CartDiscountReference"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        line_items: typing.List["LineItem"],
        custom_line_items: typing.List["CustomLineItem"],
        total_price: "TypedMoney",
        order_state: "OrderState",
        sync_info: typing.List["SyncInfo"],
        last_message_sequence_number: int,
        origin: "CartOrigin",
        refused_gifts: typing.List["CartDiscountReference"],
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        completed_at: typing.Optional[datetime.datetime] = None,
        order_number: typing.Optional[str] = None,
        customer_id: typing.Optional[str] = None,
        customer_email: typing.Optional[str] = None,
        anonymous_id: typing.Optional[str] = None,
        store: typing.Optional["StoreKeyReference"] = None,
        taxed_price: typing.Optional["TaxedPrice"] = None,
        shipping_address: typing.Optional["Address"] = None,
        billing_address: typing.Optional["Address"] = None,
        tax_mode: typing.Optional["TaxMode"] = None,
        tax_rounding_mode: typing.Optional["RoundingMode"] = None,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        country: typing.Optional[str] = None,
        state: typing.Optional["StateReference"] = None,
        shipment_state: typing.Optional["ShipmentState"] = None,
        payment_state: typing.Optional["PaymentState"] = None,
        shipping_info: typing.Optional["ShippingInfo"] = None,
        return_info: typing.Optional[typing.List["ReturnInfo"]] = None,
        discount_codes: typing.Optional[typing.List["DiscountCodeInfo"]] = None,
        cart: typing.Optional["CartReference"] = None,
        custom: typing.Optional["CustomFields"] = None,
        payment_info: typing.Optional["PaymentInfo"] = None,
        locale: typing.Optional[str] = None,
        inventory_mode: typing.Optional["InventoryMode"] = None,
        tax_calculation_mode: typing.Optional["TaxCalculationMode"] = None,
        shipping_rate_input: typing.Optional["ShippingRateInput"] = None,
        item_shipping_addresses: typing.Optional[typing.List["Address"]] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.completed_at = completed_at
        self.order_number = order_number
        self.customer_id = customer_id
        self.customer_email = customer_email
        self.anonymous_id = anonymous_id
        self.store = store
        self.line_items = line_items
        self.custom_line_items = custom_line_items
        self.total_price = total_price
        self.taxed_price = taxed_price
        self.shipping_address = shipping_address
        self.billing_address = billing_address
        self.tax_mode = tax_mode
        self.tax_rounding_mode = tax_rounding_mode
        self.customer_group = customer_group
        self.country = country
        self.order_state = order_state
        self.state = state
        self.shipment_state = shipment_state
        self.payment_state = payment_state
        self.shipping_info = shipping_info
        self.sync_info = sync_info
        self.return_info = return_info
        self.discount_codes = discount_codes
        self.last_message_sequence_number = last_message_sequence_number
        self.cart = cart
        self.custom = custom
        self.payment_info = payment_info
        self.locale = locale
        self.inventory_mode = inventory_mode
        self.origin = origin
        self.tax_calculation_mode = tax_calculation_mode
        self.shipping_rate_input = shipping_rate_input
        self.item_shipping_addresses = item_shipping_addresses
        self.refused_gifts = refused_gifts
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "Order(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, completed_at=%r, order_number=%r, customer_id=%r, customer_email=%r, anonymous_id=%r, store=%r, line_items=%r, custom_line_items=%r, total_price=%r, taxed_price=%r, shipping_address=%r, billing_address=%r, tax_mode=%r, tax_rounding_mode=%r, customer_group=%r, country=%r, order_state=%r, state=%r, shipment_state=%r, payment_state=%r, shipping_info=%r, sync_info=%r, return_info=%r, discount_codes=%r, last_message_sequence_number=%r, cart=%r, custom=%r, payment_info=%r, locale=%r, inventory_mode=%r, origin=%r, tax_calculation_mode=%r, shipping_rate_input=%r, item_shipping_addresses=%r, refused_gifts=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.completed_at,
                self.order_number,
                self.customer_id,
                self.customer_email,
                self.anonymous_id,
                self.store,
                self.line_items,
                self.custom_line_items,
                self.total_price,
                self.taxed_price,
                self.shipping_address,
                self.billing_address,
                self.tax_mode,
                self.tax_rounding_mode,
                self.customer_group,
                self.country,
                self.order_state,
                self.state,
                self.shipment_state,
                self.payment_state,
                self.shipping_info,
                self.sync_info,
                self.return_info,
                self.discount_codes,
                self.last_message_sequence_number,
                self.cart,
                self.custom,
                self.payment_info,
                self.locale,
                self.inventory_mode,
                self.origin,
                self.tax_calculation_mode,
                self.shipping_rate_input,
                self.item_shipping_addresses,
                self.refused_gifts,
            )
        )


class OrderFromCartDraft(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: Optional :class:`str` `(Named` ``orderNumber`` `in Commercetools)`
    order_number: typing.Optional[str]
    #: Optional :class:`commercetools.types.PaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: typing.Optional["PaymentState"]
    #: Optional :class:`commercetools.types.ShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: typing.Optional["ShipmentState"]
    #: Optional :class:`commercetools.types.OrderState` `(Named` ``orderState`` `in Commercetools)`
    order_state: typing.Optional["OrderState"]
    #: Optional :class:`commercetools.types.StateResourceIdentifier`
    state: typing.Optional["StateResourceIdentifier"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        order_number: typing.Optional[str] = None,
        payment_state: typing.Optional["PaymentState"] = None,
        shipment_state: typing.Optional["ShipmentState"] = None,
        order_state: typing.Optional["OrderState"] = None,
        state: typing.Optional["StateResourceIdentifier"] = None
    ) -> None:
        self.id = id
        self.version = version
        self.order_number = order_number
        self.payment_state = payment_state
        self.shipment_state = shipment_state
        self.order_state = order_state
        self.state = state
        super().__init__()

    def __repr__(self) -> str:
        return (
            "OrderFromCartDraft(id=%r, version=%r, order_number=%r, payment_state=%r, shipment_state=%r, order_state=%r, state=%r)"
            % (
                self.id,
                self.version,
                self.order_number,
                self.payment_state,
                self.shipment_state,
                self.order_state,
                self.state,
            )
        )


class OrderImportDraft(_BaseType):
    #: Optional :class:`str` `(Named` ``orderNumber`` `in Commercetools)`
    order_number: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``customerEmail`` `in Commercetools)`
    customer_email: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.LineItemImportDraft` `(Named` ``lineItems`` `in Commercetools)`
    line_items: typing.Optional[typing.List["LineItemImportDraft"]]
    #: Optional list of :class:`commercetools.types.CustomLineItemDraft` `(Named` ``customLineItems`` `in Commercetools)`
    custom_line_items: typing.Optional[typing.List["CustomLineItemDraft"]]
    #: :class:`commercetools.types.Money` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "Money"
    #: Optional :class:`commercetools.types.TaxedPriceDraft` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedPriceDraft"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``shippingAddress`` `in Commercetools)`
    shipping_address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``billingAddress`` `in Commercetools)`
    billing_address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.CustomerGroupResourceIdentifier` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupResourceIdentifier"]
    #: Optional :class:`str`
    country: typing.Optional[str]
    #: Optional :class:`commercetools.types.OrderState` `(Named` ``orderState`` `in Commercetools)`
    order_state: typing.Optional["OrderState"]
    #: Optional :class:`commercetools.types.ShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: typing.Optional["ShipmentState"]
    #: Optional :class:`commercetools.types.PaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: typing.Optional["PaymentState"]
    #: Optional :class:`commercetools.types.ShippingInfoImportDraft` `(Named` ``shippingInfo`` `in Commercetools)`
    shipping_info: typing.Optional["ShippingInfoImportDraft"]
    #: Optional :class:`datetime.datetime` `(Named` ``completedAt`` `in Commercetools)`
    completed_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.InventoryMode` `(Named` ``inventoryMode`` `in Commercetools)`
    inventory_mode: typing.Optional["InventoryMode"]
    #: Optional :class:`commercetools.types.RoundingMode` `(Named` ``taxRoundingMode`` `in Commercetools)`
    tax_rounding_mode: typing.Optional["RoundingMode"]
    #: Optional list of :class:`commercetools.types.Address` `(Named` ``itemShippingAddresses`` `in Commercetools)`
    item_shipping_addresses: typing.Optional[typing.List["Address"]]
    #: Optional :class:`commercetools.types.StoreResourceIdentifier`
    store: typing.Optional["StoreResourceIdentifier"]
    #: Optional :class:`commercetools.types.CartOrigin`
    origin: typing.Optional["CartOrigin"]

    def __init__(
        self,
        *,
        total_price: "Money",
        order_number: typing.Optional[str] = None,
        customer_id: typing.Optional[str] = None,
        customer_email: typing.Optional[str] = None,
        line_items: typing.Optional[typing.List["LineItemImportDraft"]] = None,
        custom_line_items: typing.Optional[typing.List["CustomLineItemDraft"]] = None,
        taxed_price: typing.Optional["TaxedPriceDraft"] = None,
        shipping_address: typing.Optional["Address"] = None,
        billing_address: typing.Optional["Address"] = None,
        customer_group: typing.Optional["CustomerGroupResourceIdentifier"] = None,
        country: typing.Optional[str] = None,
        order_state: typing.Optional["OrderState"] = None,
        shipment_state: typing.Optional["ShipmentState"] = None,
        payment_state: typing.Optional["PaymentState"] = None,
        shipping_info: typing.Optional["ShippingInfoImportDraft"] = None,
        completed_at: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        inventory_mode: typing.Optional["InventoryMode"] = None,
        tax_rounding_mode: typing.Optional["RoundingMode"] = None,
        item_shipping_addresses: typing.Optional[typing.List["Address"]] = None,
        store: typing.Optional["StoreResourceIdentifier"] = None,
        origin: typing.Optional["CartOrigin"] = None
    ) -> None:
        self.order_number = order_number
        self.customer_id = customer_id
        self.customer_email = customer_email
        self.line_items = line_items
        self.custom_line_items = custom_line_items
        self.total_price = total_price
        self.taxed_price = taxed_price
        self.shipping_address = shipping_address
        self.billing_address = billing_address
        self.customer_group = customer_group
        self.country = country
        self.order_state = order_state
        self.shipment_state = shipment_state
        self.payment_state = payment_state
        self.shipping_info = shipping_info
        self.completed_at = completed_at
        self.custom = custom
        self.inventory_mode = inventory_mode
        self.tax_rounding_mode = tax_rounding_mode
        self.item_shipping_addresses = item_shipping_addresses
        self.store = store
        self.origin = origin
        super().__init__()

    def __repr__(self) -> str:
        return (
            "OrderImportDraft(order_number=%r, customer_id=%r, customer_email=%r, line_items=%r, custom_line_items=%r, total_price=%r, taxed_price=%r, shipping_address=%r, billing_address=%r, customer_group=%r, country=%r, order_state=%r, shipment_state=%r, payment_state=%r, shipping_info=%r, completed_at=%r, custom=%r, inventory_mode=%r, tax_rounding_mode=%r, item_shipping_addresses=%r, store=%r, origin=%r)"
            % (
                self.order_number,
                self.customer_id,
                self.customer_email,
                self.line_items,
                self.custom_line_items,
                self.total_price,
                self.taxed_price,
                self.shipping_address,
                self.billing_address,
                self.customer_group,
                self.country,
                self.order_state,
                self.shipment_state,
                self.payment_state,
                self.shipping_info,
                self.completed_at,
                self.custom,
                self.inventory_mode,
                self.tax_rounding_mode,
                self.item_shipping_addresses,
                self.store,
                self.origin,
            )
        )


class OrderPagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.Order`
    results: typing.Sequence["Order"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["Order"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "OrderPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class OrderReference(Reference):
    #: Optional :class:`commercetools.types.Order`
    obj: typing.Optional["Order"]

    def __init__(self, *, id: str, obj: typing.Optional["Order"] = None) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.ORDER, id=id)

    def __repr__(self) -> str:
        return "OrderReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class OrderResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.ORDER, id=id, key=key)

    def __repr__(self) -> str:
        return "OrderResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class OrderState(enum.Enum):
    OPEN = "Open"
    CONFIRMED = "Confirmed"
    COMPLETE = "Complete"
    CANCELLED = "Cancelled"


class OrderUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int, actions: list) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "OrderUpdate(version=%r, actions=%r)" % (self.version, self.actions)


class OrderUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "OrderUpdateAction(action=%r)" % (self.action,)


class Parcel(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]
    #: Optional list of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]

    def __init__(
        self,
        *,
        id: str,
        created_at: datetime.datetime,
        measurements: typing.Optional["ParcelMeasurements"] = None,
        tracking_data: typing.Optional["TrackingData"] = None,
        items: typing.Optional[typing.List["DeliveryItem"]] = None
    ) -> None:
        self.id = id
        self.created_at = created_at
        self.measurements = measurements
        self.tracking_data = tracking_data
        self.items = items
        super().__init__()

    def __repr__(self) -> str:
        return (
            "Parcel(id=%r, created_at=%r, measurements=%r, tracking_data=%r, items=%r)"
            % (
                self.id,
                self.created_at,
                self.measurements,
                self.tracking_data,
                self.items,
            )
        )


class ParcelDraft(_BaseType):
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]
    #: Optional list of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]

    def __init__(
        self,
        *,
        measurements: typing.Optional["ParcelMeasurements"] = None,
        tracking_data: typing.Optional["TrackingData"] = None,
        items: typing.Optional[typing.List["DeliveryItem"]] = None
    ) -> None:
        self.measurements = measurements
        self.tracking_data = tracking_data
        self.items = items
        super().__init__()

    def __repr__(self) -> str:
        return "ParcelDraft(measurements=%r, tracking_data=%r, items=%r)" % (
            self.measurements,
            self.tracking_data,
            self.items,
        )


class ParcelMeasurements(_BaseType):
    #: Optional :class:`int` `(Named` ``heightInMillimeter`` `in Commercetools)`
    height_in_millimeter: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``lengthInMillimeter`` `in Commercetools)`
    length_in_millimeter: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``widthInMillimeter`` `in Commercetools)`
    width_in_millimeter: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``weightInGram`` `in Commercetools)`
    weight_in_gram: typing.Optional[int]

    def __init__(
        self,
        *,
        height_in_millimeter: typing.Optional[int] = None,
        length_in_millimeter: typing.Optional[int] = None,
        width_in_millimeter: typing.Optional[int] = None,
        weight_in_gram: typing.Optional[int] = None
    ) -> None:
        self.height_in_millimeter = height_in_millimeter
        self.length_in_millimeter = length_in_millimeter
        self.width_in_millimeter = width_in_millimeter
        self.weight_in_gram = weight_in_gram
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ParcelMeasurements(height_in_millimeter=%r, length_in_millimeter=%r, width_in_millimeter=%r, weight_in_gram=%r)"
            % (
                self.height_in_millimeter,
                self.length_in_millimeter,
                self.width_in_millimeter,
                self.weight_in_gram,
            )
        )


class PaymentInfo(_BaseType):
    #: List of :class:`commercetools.types.PaymentReference`
    payments: typing.List["PaymentReference"]

    def __init__(self, *, payments: typing.List["PaymentReference"]) -> None:
        self.payments = payments
        super().__init__()

    def __repr__(self) -> str:
        return "PaymentInfo(payments=%r)" % (self.payments,)


class PaymentState(enum.Enum):
    BALANCE_DUE = "BalanceDue"
    FAILED = "Failed"
    PENDING = "Pending"
    CREDIT_OWED = "CreditOwed"
    PAID = "Paid"


class ProductVariantImportDraft(_BaseType):
    #: Optional :class:`int`
    id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.PriceDraft`
    prices: typing.Optional[typing.List["PriceDraft"]]
    #: Optional list of :class:`commercetools.types.Attribute`
    attributes: typing.Optional[typing.List["Attribute"]]
    #: Optional list of :class:`commercetools.types.Image`
    images: typing.Optional[typing.List["Image"]]

    def __init__(
        self,
        *,
        id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        prices: typing.Optional[typing.List["PriceDraft"]] = None,
        attributes: typing.Optional[typing.List["Attribute"]] = None,
        images: typing.Optional[typing.List["Image"]] = None
    ) -> None:
        self.id = id
        self.sku = sku
        self.prices = prices
        self.attributes = attributes
        self.images = images
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductVariantImportDraft(id=%r, sku=%r, prices=%r, attributes=%r, images=%r)"
            % (self.id, self.sku, self.prices, self.attributes, self.images)
        )


class ReturnInfo(_BaseType):
    #: List of :class:`commercetools.types.ReturnItem`
    items: typing.List["ReturnItem"]
    #: Optional :class:`str` `(Named` ``returnTrackingId`` `in Commercetools)`
    return_tracking_id: typing.Optional[str]
    #: Optional :class:`datetime.datetime` `(Named` ``returnDate`` `in Commercetools)`
    return_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        items: typing.List["ReturnItem"],
        return_tracking_id: typing.Optional[str] = None,
        return_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.items = items
        self.return_tracking_id = return_tracking_id
        self.return_date = return_date
        super().__init__()

    def __repr__(self) -> str:
        return "ReturnInfo(items=%r, return_tracking_id=%r, return_date=%r)" % (
            self.items,
            self.return_tracking_id,
            self.return_date,
        )


class ReturnItem(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`int`
    quantity: int
    #: :class:`str`
    type: str
    #: Optional :class:`str`
    comment: typing.Optional[str]
    #: :class:`commercetools.types.ReturnShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: "ReturnShipmentState"
    #: :class:`commercetools.types.ReturnPaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: "ReturnPaymentState"
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime

    def __init__(
        self,
        *,
        id: str,
        quantity: int,
        type: str,
        shipment_state: "ReturnShipmentState",
        payment_state: "ReturnPaymentState",
        last_modified_at: datetime.datetime,
        created_at: datetime.datetime,
        comment: typing.Optional[str] = None
    ) -> None:
        self.id = id
        self.quantity = quantity
        self.type = type
        self.comment = comment
        self.shipment_state = shipment_state
        self.payment_state = payment_state
        self.last_modified_at = last_modified_at
        self.created_at = created_at
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ReturnItem(id=%r, quantity=%r, type=%r, comment=%r, shipment_state=%r, payment_state=%r, last_modified_at=%r, created_at=%r)"
            % (
                self.id,
                self.quantity,
                self.type,
                self.comment,
                self.shipment_state,
                self.payment_state,
                self.last_modified_at,
                self.created_at,
            )
        )


class ReturnItemDraft(_BaseType):
    #: :class:`int`
    quantity: int
    #: Optional :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: Optional :class:`str`
    comment: typing.Optional[str]
    #: :class:`commercetools.types.ReturnShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: "ReturnShipmentState"

    def __init__(
        self,
        *,
        quantity: int,
        shipment_state: "ReturnShipmentState",
        line_item_id: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        comment: typing.Optional[str] = None
    ) -> None:
        self.quantity = quantity
        self.line_item_id = line_item_id
        self.custom_line_item_id = custom_line_item_id
        self.comment = comment
        self.shipment_state = shipment_state
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ReturnItemDraft(quantity=%r, line_item_id=%r, custom_line_item_id=%r, comment=%r, shipment_state=%r)"
            % (
                self.quantity,
                self.line_item_id,
                self.custom_line_item_id,
                self.comment,
                self.shipment_state,
            )
        )


class ReturnPaymentState(enum.Enum):
    NON_REFUNDABLE = "NonRefundable"
    INITIAL = "Initial"
    REFUNDED = "Refunded"
    NOT_REFUNDED = "NotRefunded"


class ReturnShipmentState(enum.Enum):
    ADVISED = "Advised"
    RETURNED = "Returned"
    BACK_IN_STOCK = "BackInStock"
    UNUSABLE = "Unusable"


class ShipmentState(enum.Enum):
    SHIPPED = "Shipped"
    READY = "Ready"
    PENDING = "Pending"
    DELAYED = "Delayed"
    PARTIAL = "Partial"
    BACKORDER = "Backorder"


class ShippingInfoImportDraft(_BaseType):
    #: :class:`str` `(Named` ``shippingMethodName`` `in Commercetools)`
    shipping_method_name: str
    #: :class:`commercetools.types.Money`
    price: "Money"
    #: :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: "ShippingRateDraft"
    #: Optional :class:`commercetools.types.TaxRate` `(Named` ``taxRate`` `in Commercetools)`
    tax_rate: typing.Optional["TaxRate"]
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.ShippingMethodResourceIdentifier` `(Named` ``shippingMethod`` `in Commercetools)`
    shipping_method: typing.Optional["ShippingMethodResourceIdentifier"]
    #: Optional list of :class:`commercetools.types.Delivery`
    deliveries: typing.Optional[typing.List["Delivery"]]
    #: Optional :class:`commercetools.types.DiscountedLineItemPriceDraft` `(Named` ``discountedPrice`` `in Commercetools)`
    discounted_price: typing.Optional["DiscountedLineItemPriceDraft"]
    #: Optional :class:`commercetools.types.ShippingMethodState` `(Named` ``shippingMethodState`` `in Commercetools)`
    shipping_method_state: typing.Optional["ShippingMethodState"]

    def __init__(
        self,
        *,
        shipping_method_name: str,
        price: "Money",
        shipping_rate: "ShippingRateDraft",
        tax_rate: typing.Optional["TaxRate"] = None,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        shipping_method: typing.Optional["ShippingMethodResourceIdentifier"] = None,
        deliveries: typing.Optional[typing.List["Delivery"]] = None,
        discounted_price: typing.Optional["DiscountedLineItemPriceDraft"] = None,
        shipping_method_state: typing.Optional["ShippingMethodState"] = None
    ) -> None:
        self.shipping_method_name = shipping_method_name
        self.price = price
        self.shipping_rate = shipping_rate
        self.tax_rate = tax_rate
        self.tax_category = tax_category
        self.shipping_method = shipping_method
        self.deliveries = deliveries
        self.discounted_price = discounted_price
        self.shipping_method_state = shipping_method_state
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ShippingInfoImportDraft(shipping_method_name=%r, price=%r, shipping_rate=%r, tax_rate=%r, tax_category=%r, shipping_method=%r, deliveries=%r, discounted_price=%r, shipping_method_state=%r)"
            % (
                self.shipping_method_name,
                self.price,
                self.shipping_rate,
                self.tax_rate,
                self.tax_category,
                self.shipping_method,
                self.deliveries,
                self.discounted_price,
                self.shipping_method_state,
            )
        )


class StagedOrderUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "StagedOrderUpdateAction(action=%r)" % (self.action,)


class SyncInfo(_BaseType):
    #: :class:`commercetools.types.ChannelReference`
    channel: "ChannelReference"
    #: Optional :class:`str` `(Named` ``externalId`` `in Commercetools)`
    external_id: typing.Optional[str]
    #: :class:`datetime.datetime` `(Named` ``syncedAt`` `in Commercetools)`
    synced_at: datetime.datetime

    def __init__(
        self,
        *,
        channel: "ChannelReference",
        synced_at: datetime.datetime,
        external_id: typing.Optional[str] = None
    ) -> None:
        self.channel = channel
        self.external_id = external_id
        self.synced_at = synced_at
        super().__init__()

    def __repr__(self) -> str:
        return "SyncInfo(channel=%r, external_id=%r, synced_at=%r)" % (
            self.channel,
            self.external_id,
            self.synced_at,
        )


class TaxedItemPriceDraft(_BaseType):
    #: :class:`commercetools.types.Money` `(Named` ``totalNet`` `in Commercetools)`
    total_net: "Money"
    #: :class:`commercetools.types.Money` `(Named` ``totalGross`` `in Commercetools)`
    total_gross: "Money"

    def __init__(self, *, total_net: "Money", total_gross: "Money") -> None:
        self.total_net = total_net
        self.total_gross = total_gross
        super().__init__()

    def __repr__(self) -> str:
        return "TaxedItemPriceDraft(total_net=%r, total_gross=%r)" % (
            self.total_net,
            self.total_gross,
        )


class TrackingData(_BaseType):
    #: Optional :class:`str` `(Named` ``trackingId`` `in Commercetools)`
    tracking_id: typing.Optional[str]
    #: Optional :class:`str`
    carrier: typing.Optional[str]
    #: Optional :class:`str`
    provider: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``providerTransaction`` `in Commercetools)`
    provider_transaction: typing.Optional[str]
    #: Optional :class:`bool` `(Named` ``isReturn`` `in Commercetools)`
    is_return: typing.Optional[bool]

    def __init__(
        self,
        *,
        tracking_id: typing.Optional[str] = None,
        carrier: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        provider_transaction: typing.Optional[str] = None,
        is_return: typing.Optional[bool] = None
    ) -> None:
        self.tracking_id = tracking_id
        self.carrier = carrier
        self.provider = provider
        self.provider_transaction = provider_transaction
        self.is_return = is_return
        super().__init__()

    def __repr__(self) -> str:
        return (
            "TrackingData(tracking_id=%r, carrier=%r, provider=%r, provider_transaction=%r, is_return=%r)"
            % (
                self.tracking_id,
                self.carrier,
                self.provider,
                self.provider_transaction,
                self.is_return,
            )
        )


class CustomLineItemReturnItem(ReturnItem):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str

    def __init__(
        self,
        *,
        id: str,
        quantity: int,
        shipment_state: "ReturnShipmentState",
        payment_state: "ReturnPaymentState",
        last_modified_at: datetime.datetime,
        created_at: datetime.datetime,
        custom_line_item_id: str,
        comment: typing.Optional[str] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        super().__init__(
            id=id,
            quantity=quantity,
            type="CustomLineItemReturnItem",
            comment=comment,
            shipment_state=shipment_state,
            payment_state=payment_state,
            last_modified_at=last_modified_at,
            created_at=created_at,
        )

    def __repr__(self) -> str:
        return (
            "CustomLineItemReturnItem(id=%r, quantity=%r, type=%r, comment=%r, shipment_state=%r, payment_state=%r, last_modified_at=%r, created_at=%r, custom_line_item_id=%r)"
            % (
                self.id,
                self.quantity,
                self.type,
                self.comment,
                self.shipment_state,
                self.payment_state,
                self.last_modified_at,
                self.created_at,
                self.custom_line_item_id,
            )
        )


class LineItemReturnItem(ReturnItem):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str

    def __init__(
        self,
        *,
        id: str,
        quantity: int,
        shipment_state: "ReturnShipmentState",
        payment_state: "ReturnPaymentState",
        last_modified_at: datetime.datetime,
        created_at: datetime.datetime,
        line_item_id: str,
        comment: typing.Optional[str] = None
    ) -> None:
        self.line_item_id = line_item_id
        super().__init__(
            id=id,
            quantity=quantity,
            type="LineItemReturnItem",
            comment=comment,
            shipment_state=shipment_state,
            payment_state=payment_state,
            last_modified_at=last_modified_at,
            created_at=created_at,
        )

    def __repr__(self) -> str:
        return (
            "LineItemReturnItem(id=%r, quantity=%r, type=%r, comment=%r, shipment_state=%r, payment_state=%r, last_modified_at=%r, created_at=%r, line_item_id=%r)"
            % (
                self.id,
                self.quantity,
                self.type,
                self.comment,
                self.shipment_state,
                self.payment_state,
                self.last_modified_at,
                self.created_at,
                self.line_item_id,
            )
        )


class OrderAddDeliveryAction(OrderUpdateAction):
    #: Optional list of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional list of :class:`commercetools.types.ParcelDraft`
    parcels: typing.Optional[typing.List["ParcelDraft"]]

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List["DeliveryItem"]] = None,
        address: typing.Optional["Address"] = None,
        parcels: typing.Optional[typing.List["ParcelDraft"]] = None
    ) -> None:
        self.items = items
        self.address = address
        self.parcels = parcels
        super().__init__(action="addDelivery")

    def __repr__(self) -> str:
        return "OrderAddDeliveryAction(action=%r, items=%r, address=%r, parcels=%r)" % (
            self.action,
            self.items,
            self.address,
            self.parcels,
        )


class OrderAddItemShippingAddressAction(OrderUpdateAction):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(action="addItemShippingAddress")

    def __repr__(self) -> str:
        return "OrderAddItemShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class OrderAddParcelToDeliveryAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]
    #: Optional list of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]

    def __init__(
        self,
        *,
        delivery_id: str,
        measurements: typing.Optional["ParcelMeasurements"] = None,
        tracking_data: typing.Optional["TrackingData"] = None,
        items: typing.Optional[typing.List["DeliveryItem"]] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.measurements = measurements
        self.tracking_data = tracking_data
        self.items = items
        super().__init__(action="addParcelToDelivery")

    def __repr__(self) -> str:
        return (
            "OrderAddParcelToDeliveryAction(action=%r, delivery_id=%r, measurements=%r, tracking_data=%r, items=%r)"
            % (
                self.action,
                self.delivery_id,
                self.measurements,
                self.tracking_data,
                self.items,
            )
        )


class OrderAddPaymentAction(OrderUpdateAction):
    #: :class:`commercetools.types.PaymentResourceIdentifier`
    payment: "PaymentResourceIdentifier"

    def __init__(self, *, payment: "PaymentResourceIdentifier") -> None:
        self.payment = payment
        super().__init__(action="addPayment")

    def __repr__(self) -> str:
        return "OrderAddPaymentAction(action=%r, payment=%r)" % (
            self.action,
            self.payment,
        )


class OrderAddReturnInfoAction(OrderUpdateAction):
    #: Optional :class:`str` `(Named` ``returnTrackingId`` `in Commercetools)`
    return_tracking_id: typing.Optional[str]
    #: List of :class:`commercetools.types.ReturnItemDraft`
    items: typing.List["ReturnItemDraft"]
    #: Optional :class:`datetime.datetime` `(Named` ``returnDate`` `in Commercetools)`
    return_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        items: typing.List["ReturnItemDraft"],
        return_tracking_id: typing.Optional[str] = None,
        return_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.return_tracking_id = return_tracking_id
        self.items = items
        self.return_date = return_date
        super().__init__(action="addReturnInfo")

    def __repr__(self) -> str:
        return (
            "OrderAddReturnInfoAction(action=%r, return_tracking_id=%r, items=%r, return_date=%r)"
            % (self.action, self.return_tracking_id, self.items, self.return_date)
        )


class OrderChangeOrderStateAction(OrderUpdateAction):
    #: :class:`commercetools.types.OrderState` `(Named` ``orderState`` `in Commercetools)`
    order_state: "OrderState"

    def __init__(self, *, order_state: "OrderState") -> None:
        self.order_state = order_state
        super().__init__(action="changeOrderState")

    def __repr__(self) -> str:
        return "OrderChangeOrderStateAction(action=%r, order_state=%r)" % (
            self.action,
            self.order_state,
        )


class OrderChangePaymentStateAction(OrderUpdateAction):
    #: Optional :class:`commercetools.types.PaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: typing.Optional["PaymentState"]

    def __init__(
        self, *, payment_state: typing.Optional["PaymentState"] = None
    ) -> None:
        self.payment_state = payment_state
        super().__init__(action="changePaymentState")

    def __repr__(self) -> str:
        return "OrderChangePaymentStateAction(action=%r, payment_state=%r)" % (
            self.action,
            self.payment_state,
        )


class OrderChangeShipmentStateAction(OrderUpdateAction):
    #: Optional :class:`commercetools.types.ShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: typing.Optional["ShipmentState"]

    def __init__(
        self, *, shipment_state: typing.Optional["ShipmentState"] = None
    ) -> None:
        self.shipment_state = shipment_state
        super().__init__(action="changeShipmentState")

    def __repr__(self) -> str:
        return "OrderChangeShipmentStateAction(action=%r, shipment_state=%r)" % (
            self.action,
            self.shipment_state,
        )


class OrderImportCustomLineItemStateAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: List of :class:`commercetools.types.ItemState`
    state: typing.List["ItemState"]

    def __init__(
        self, *, custom_line_item_id: str, state: typing.List["ItemState"]
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.state = state
        super().__init__(action="importCustomLineItemState")

    def __repr__(self) -> str:
        return (
            "OrderImportCustomLineItemStateAction(action=%r, custom_line_item_id=%r, state=%r)"
            % (self.action, self.custom_line_item_id, self.state)
        )


class OrderImportLineItemStateAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: List of :class:`commercetools.types.ItemState`
    state: typing.List["ItemState"]

    def __init__(self, *, line_item_id: str, state: typing.List["ItemState"]) -> None:
        self.line_item_id = line_item_id
        self.state = state
        super().__init__(action="importLineItemState")

    def __repr__(self) -> str:
        return (
            "OrderImportLineItemStateAction(action=%r, line_item_id=%r, state=%r)"
            % (self.action, self.line_item_id, self.state)
        )


class OrderRemoveDeliveryAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str

    def __init__(self, *, delivery_id: str) -> None:
        self.delivery_id = delivery_id
        super().__init__(action="removeDelivery")

    def __repr__(self) -> str:
        return "OrderRemoveDeliveryAction(action=%r, delivery_id=%r)" % (
            self.action,
            self.delivery_id,
        )


class OrderRemoveItemShippingAddressAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: str

    def __init__(self, *, address_key: str) -> None:
        self.address_key = address_key
        super().__init__(action="removeItemShippingAddress")

    def __repr__(self) -> str:
        return "OrderRemoveItemShippingAddressAction(action=%r, address_key=%r)" % (
            self.action,
            self.address_key,
        )


class OrderRemoveParcelFromDeliveryAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str

    def __init__(self, *, parcel_id: str) -> None:
        self.parcel_id = parcel_id
        super().__init__(action="removeParcelFromDelivery")

    def __repr__(self) -> str:
        return "OrderRemoveParcelFromDeliveryAction(action=%r, parcel_id=%r)" % (
            self.action,
            self.parcel_id,
        )


class OrderRemovePaymentAction(OrderUpdateAction):
    #: :class:`commercetools.types.PaymentResourceIdentifier`
    payment: "PaymentResourceIdentifier"

    def __init__(self, *, payment: "PaymentResourceIdentifier") -> None:
        self.payment = payment
        super().__init__(action="removePayment")

    def __repr__(self) -> str:
        return "OrderRemovePaymentAction(action=%r, payment=%r)" % (
            self.action,
            self.payment,
        )


class OrderSetBillingAddressAction(OrderUpdateAction):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(self, *, address: typing.Optional["Address"] = None) -> None:
        self.address = address
        super().__init__(action="setBillingAddress")

    def __repr__(self) -> str:
        return "OrderSetBillingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class OrderSetCustomFieldAction(OrderUpdateAction):
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(self, *, name: str, value: typing.Optional[typing.Any] = None) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "OrderSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class OrderSetCustomLineItemCustomFieldAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        name: str,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setCustomLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "OrderSetCustomLineItemCustomFieldAction(action=%r, custom_line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.custom_line_item_id, self.name, self.value)
        )


class OrderSetCustomLineItemCustomTypeAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "OrderSetCustomLineItemCustomTypeAction(action=%r, custom_line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.custom_line_item_id, self.type, self.fields)
        )


class OrderSetCustomLineItemShippingDetailsAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.shipping_details = shipping_details
        super().__init__(action="setCustomLineItemShippingDetails")

    def __repr__(self) -> str:
        return (
            "OrderSetCustomLineItemShippingDetailsAction(action=%r, custom_line_item_id=%r, shipping_details=%r)"
            % (self.action, self.custom_line_item_id, self.shipping_details)
        )


class OrderSetCustomTypeAction(OrderUpdateAction):
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "OrderSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class OrderSetCustomerEmailAction(OrderUpdateAction):
    #: Optional :class:`str`
    email: typing.Optional[str]

    def __init__(self, *, email: typing.Optional[str] = None) -> None:
        self.email = email
        super().__init__(action="setCustomerEmail")

    def __repr__(self) -> str:
        return "OrderSetCustomerEmailAction(action=%r, email=%r)" % (
            self.action,
            self.email,
        )


class OrderSetCustomerIdAction(OrderUpdateAction):
    #: Optional :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: typing.Optional[str]

    def __init__(self, *, customer_id: typing.Optional[str] = None) -> None:
        self.customer_id = customer_id
        super().__init__(action="setCustomerId")

    def __repr__(self) -> str:
        return "OrderSetCustomerIdAction(action=%r, customer_id=%r)" % (
            self.action,
            self.customer_id,
        )


class OrderSetDeliveryAddressAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(
        self, *, delivery_id: str, address: typing.Optional["Address"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.address = address
        super().__init__(action="setDeliveryAddress")

    def __repr__(self) -> str:
        return (
            "OrderSetDeliveryAddressAction(action=%r, delivery_id=%r, address=%r)"
            % (self.action, self.delivery_id, self.address)
        )


class OrderSetDeliveryItemsAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]

    def __init__(self, *, delivery_id: str, items: typing.List["DeliveryItem"]) -> None:
        self.delivery_id = delivery_id
        self.items = items
        super().__init__(action="setDeliveryItems")

    def __repr__(self) -> str:
        return "OrderSetDeliveryItemsAction(action=%r, delivery_id=%r, items=%r)" % (
            self.action,
            self.delivery_id,
            self.items,
        )


class OrderSetLineItemCustomFieldAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self, *, line_item_id: str, name: str, value: typing.Optional[typing.Any] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "OrderSetLineItemCustomFieldAction(action=%r, line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.line_item_id, self.name, self.value)
        )


class OrderSetLineItemCustomTypeAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        line_item_id: str,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "OrderSetLineItemCustomTypeAction(action=%r, line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.line_item_id, self.type, self.fields)
        )


class OrderSetLineItemShippingDetailsAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.shipping_details = shipping_details
        super().__init__(action="setLineItemShippingDetails")

    def __repr__(self) -> str:
        return (
            "OrderSetLineItemShippingDetailsAction(action=%r, line_item_id=%r, shipping_details=%r)"
            % (self.action, self.line_item_id, self.shipping_details)
        )


class OrderSetLocaleAction(OrderUpdateAction):
    #: Optional :class:`str`
    locale: typing.Optional[str]

    def __init__(self, *, locale: typing.Optional[str] = None) -> None:
        self.locale = locale
        super().__init__(action="setLocale")

    def __repr__(self) -> str:
        return "OrderSetLocaleAction(action=%r, locale=%r)" % (self.action, self.locale)


class OrderSetOrderNumberAction(OrderUpdateAction):
    #: Optional :class:`str` `(Named` ``orderNumber`` `in Commercetools)`
    order_number: typing.Optional[str]

    def __init__(self, *, order_number: typing.Optional[str] = None) -> None:
        self.order_number = order_number
        super().__init__(action="setOrderNumber")

    def __repr__(self) -> str:
        return "OrderSetOrderNumberAction(action=%r, order_number=%r)" % (
            self.action,
            self.order_number,
        )


class OrderSetParcelItemsAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]

    def __init__(self, *, parcel_id: str, items: typing.List["DeliveryItem"]) -> None:
        self.parcel_id = parcel_id
        self.items = items
        super().__init__(action="setParcelItems")

    def __repr__(self) -> str:
        return "OrderSetParcelItemsAction(action=%r, parcel_id=%r, items=%r)" % (
            self.action,
            self.parcel_id,
            self.items,
        )


class OrderSetParcelMeasurementsAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]

    def __init__(
        self,
        *,
        parcel_id: str,
        measurements: typing.Optional["ParcelMeasurements"] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.measurements = measurements
        super().__init__(action="setParcelMeasurements")

    def __repr__(self) -> str:
        return (
            "OrderSetParcelMeasurementsAction(action=%r, parcel_id=%r, measurements=%r)"
            % (self.action, self.parcel_id, self.measurements)
        )


class OrderSetParcelTrackingDataAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]

    def __init__(
        self, *, parcel_id: str, tracking_data: typing.Optional["TrackingData"] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.tracking_data = tracking_data
        super().__init__(action="setParcelTrackingData")

    def __repr__(self) -> str:
        return (
            "OrderSetParcelTrackingDataAction(action=%r, parcel_id=%r, tracking_data=%r)"
            % (self.action, self.parcel_id, self.tracking_data)
        )


class OrderSetReturnPaymentStateAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``returnItemId`` `in Commercetools)`
    return_item_id: str
    #: :class:`commercetools.types.ReturnPaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: "ReturnPaymentState"

    def __init__(
        self, *, return_item_id: str, payment_state: "ReturnPaymentState"
    ) -> None:
        self.return_item_id = return_item_id
        self.payment_state = payment_state
        super().__init__(action="setReturnPaymentState")

    def __repr__(self) -> str:
        return (
            "OrderSetReturnPaymentStateAction(action=%r, return_item_id=%r, payment_state=%r)"
            % (self.action, self.return_item_id, self.payment_state)
        )


class OrderSetReturnShipmentStateAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``returnItemId`` `in Commercetools)`
    return_item_id: str
    #: :class:`commercetools.types.ReturnShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: "ReturnShipmentState"

    def __init__(
        self, *, return_item_id: str, shipment_state: "ReturnShipmentState"
    ) -> None:
        self.return_item_id = return_item_id
        self.shipment_state = shipment_state
        super().__init__(action="setReturnShipmentState")

    def __repr__(self) -> str:
        return (
            "OrderSetReturnShipmentStateAction(action=%r, return_item_id=%r, shipment_state=%r)"
            % (self.action, self.return_item_id, self.shipment_state)
        )


class OrderSetShippingAddressAction(OrderUpdateAction):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(self, *, address: typing.Optional["Address"] = None) -> None:
        self.address = address
        super().__init__(action="setShippingAddress")

    def __repr__(self) -> str:
        return "OrderSetShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class OrderSetStoreAction(OrderUpdateAction):
    #: Optional :class:`commercetools.types.StoreResourceIdentifier`
    store: typing.Optional["StoreResourceIdentifier"]

    def __init__(
        self, *, store: typing.Optional["StoreResourceIdentifier"] = None
    ) -> None:
        self.store = store
        super().__init__(action="setStore")

    def __repr__(self) -> str:
        return "OrderSetStoreAction(action=%r, store=%r)" % (self.action, self.store)


class OrderTransitionCustomLineItemStateAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``fromState`` `in Commercetools)`
    from_state: "StateResourceIdentifier"
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``toState`` `in Commercetools)`
    to_state: "StateResourceIdentifier"
    #: Optional :class:`datetime.datetime` `(Named` ``actualTransitionDate`` `in Commercetools)`
    actual_transition_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        quantity: int,
        from_state: "StateResourceIdentifier",
        to_state: "StateResourceIdentifier",
        actual_transition_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        self.actual_transition_date = actual_transition_date
        super().__init__(action="transitionCustomLineItemState")

    def __repr__(self) -> str:
        return (
            "OrderTransitionCustomLineItemStateAction(action=%r, custom_line_item_id=%r, quantity=%r, from_state=%r, to_state=%r, actual_transition_date=%r)"
            % (
                self.action,
                self.custom_line_item_id,
                self.quantity,
                self.from_state,
                self.to_state,
                self.actual_transition_date,
            )
        )


class OrderTransitionLineItemStateAction(OrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``fromState`` `in Commercetools)`
    from_state: "StateResourceIdentifier"
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``toState`` `in Commercetools)`
    to_state: "StateResourceIdentifier"
    #: Optional :class:`datetime.datetime` `(Named` ``actualTransitionDate`` `in Commercetools)`
    actual_transition_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        line_item_id: str,
        quantity: int,
        from_state: "StateResourceIdentifier",
        to_state: "StateResourceIdentifier",
        actual_transition_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        self.actual_transition_date = actual_transition_date
        super().__init__(action="transitionLineItemState")

    def __repr__(self) -> str:
        return (
            "OrderTransitionLineItemStateAction(action=%r, line_item_id=%r, quantity=%r, from_state=%r, to_state=%r, actual_transition_date=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.from_state,
                self.to_state,
                self.actual_transition_date,
            )
        )


class OrderTransitionStateAction(OrderUpdateAction):
    #: :class:`commercetools.types.StateResourceIdentifier`
    state: "StateResourceIdentifier"
    #: Optional :class:`bool`
    force: typing.Optional[bool]

    def __init__(
        self, *, state: "StateResourceIdentifier", force: typing.Optional[bool] = None
    ) -> None:
        self.state = state
        self.force = force
        super().__init__(action="transitionState")

    def __repr__(self) -> str:
        return "OrderTransitionStateAction(action=%r, state=%r, force=%r)" % (
            self.action,
            self.state,
            self.force,
        )


class OrderUpdateItemShippingAddressAction(OrderUpdateAction):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(action="updateItemShippingAddress")

    def __repr__(self) -> str:
        return "OrderUpdateItemShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class OrderUpdateSyncInfoAction(OrderUpdateAction):
    #: :class:`commercetools.types.ChannelResourceIdentifier`
    channel: "ChannelResourceIdentifier"
    #: Optional :class:`str` `(Named` ``externalId`` `in Commercetools)`
    external_id: typing.Optional[str]
    #: Optional :class:`datetime.datetime` `(Named` ``syncedAt`` `in Commercetools)`
    synced_at: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        channel: "ChannelResourceIdentifier",
        external_id: typing.Optional[str] = None,
        synced_at: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.channel = channel
        self.external_id = external_id
        self.synced_at = synced_at
        super().__init__(action="updateSyncInfo")

    def __repr__(self) -> str:
        return (
            "OrderUpdateSyncInfoAction(action=%r, channel=%r, external_id=%r, synced_at=%r)"
            % (self.action, self.channel, self.external_id, self.synced_at)
        )
