# DO NOT EDIT! This file is automatically generated
import datetime
import enum
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._cart_discount import CartDiscountReference
    from ._channel import ChannelReference, ChannelResourceIdentifier
    from ._common import (
        Address,
        CreatedBy,
        LastModifiedBy,
        LocalizedString,
        Money,
        Price,
        TypedMoney,
        TypedMoneyDraft,
    )
    from ._customer_group import CustomerGroupReference, CustomerGroupResourceIdentifier
    from ._discount_code import DiscountCodeReference
    from ._order import Delivery, ItemState, PaymentInfo
    from ._payment import PaymentResourceIdentifier
    from ._product import ProductVariant
    from ._product_type import ProductTypeReference
    from ._shipping_method import (
        ShippingMethodReference,
        ShippingMethodResourceIdentifier,
        ShippingRate,
        ShippingRateDraft,
    )
    from ._shopping_list import ShoppingListResourceIdentifier
    from ._store import StoreKeyReference, StoreResourceIdentifier
    from ._tax_category import (
        SubRate,
        TaxCategoryReference,
        TaxCategoryResourceIdentifier,
        TaxRate,
    )
    from ._type import (
        CustomFields,
        CustomFieldsDraft,
        FieldContainer,
        TypeResourceIdentifier,
    )
__all__ = [
    "Cart",
    "CartAddCustomLineItemAction",
    "CartAddDiscountCodeAction",
    "CartAddItemShippingAddressAction",
    "CartAddLineItemAction",
    "CartAddPaymentAction",
    "CartAddShoppingListAction",
    "CartApplyDeltaToCustomLineItemShippingDetailsTargetsAction",
    "CartApplyDeltaToLineItemShippingDetailsTargetsAction",
    "CartChangeCustomLineItemMoneyAction",
    "CartChangeCustomLineItemQuantityAction",
    "CartChangeLineItemQuantityAction",
    "CartChangeTaxCalculationModeAction",
    "CartChangeTaxModeAction",
    "CartChangeTaxRoundingModeAction",
    "CartDraft",
    "CartOrigin",
    "CartPagedQueryResponse",
    "CartRecalculateAction",
    "CartReference",
    "CartRemoveCustomLineItemAction",
    "CartRemoveDiscountCodeAction",
    "CartRemoveItemShippingAddressAction",
    "CartRemoveLineItemAction",
    "CartRemovePaymentAction",
    "CartResourceIdentifier",
    "CartSetAnonymousIdAction",
    "CartSetBillingAddressAction",
    "CartSetCartTotalTaxAction",
    "CartSetCountryAction",
    "CartSetCustomFieldAction",
    "CartSetCustomLineItemCustomFieldAction",
    "CartSetCustomLineItemCustomTypeAction",
    "CartSetCustomLineItemShippingDetailsAction",
    "CartSetCustomLineItemTaxAmountAction",
    "CartSetCustomLineItemTaxRateAction",
    "CartSetCustomShippingMethodAction",
    "CartSetCustomTypeAction",
    "CartSetCustomerEmailAction",
    "CartSetCustomerGroupAction",
    "CartSetCustomerIdAction",
    "CartSetDeleteDaysAfterLastModificationAction",
    "CartSetLineItemCustomFieldAction",
    "CartSetLineItemCustomTypeAction",
    "CartSetLineItemPriceAction",
    "CartSetLineItemShippingDetailsAction",
    "CartSetLineItemTaxAmountAction",
    "CartSetLineItemTaxRateAction",
    "CartSetLineItemTotalPriceAction",
    "CartSetLocaleAction",
    "CartSetShippingAddressAction",
    "CartSetShippingMethodAction",
    "CartSetShippingMethodTaxAmountAction",
    "CartSetShippingMethodTaxRateAction",
    "CartSetShippingRateInputAction",
    "CartState",
    "CartUpdate",
    "CartUpdateAction",
    "CartUpdateItemShippingAddressAction",
    "ClassificationShippingRateInput",
    "ClassificationShippingRateInputDraft",
    "CustomLineItem",
    "CustomLineItemDraft",
    "DiscountCodeInfo",
    "DiscountCodeState",
    "DiscountedLineItemPortion",
    "DiscountedLineItemPrice",
    "DiscountedLineItemPriceForQuantity",
    "ExternalLineItemTotalPrice",
    "ExternalTaxAmountDraft",
    "ExternalTaxRateDraft",
    "InventoryMode",
    "ItemShippingDetails",
    "ItemShippingDetailsDraft",
    "ItemShippingTarget",
    "LineItem",
    "LineItemDraft",
    "LineItemMode",
    "LineItemPriceMode",
    "ProductPublishScope",
    "ReplicaCartDraft",
    "RoundingMode",
    "ScoreShippingRateInput",
    "ScoreShippingRateInputDraft",
    "ShippingInfo",
    "ShippingMethodState",
    "ShippingRateInput",
    "ShippingRateInputDraft",
    "TaxCalculationMode",
    "TaxMode",
    "TaxPortion",
    "TaxPortionDraft",
    "TaxedItemPrice",
    "TaxedPrice",
    "TaxedPriceDraft",
]


class Cart(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``customerEmail`` `in Commercetools)`
    customer_email: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.StoreKeyReference`
    store: typing.Optional["StoreKeyReference"]
    #: List of :class:`commercetools.types.LineItem` `(Named` ``lineItems`` `in Commercetools)`
    line_items: typing.List["LineItem"]
    #: List of :class:`commercetools.types.CustomLineItem` `(Named` ``customLineItems`` `in Commercetools)`
    custom_line_items: typing.List["CustomLineItem"]
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "TypedMoney"
    #: Optional :class:`commercetools.types.TaxedPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedPrice"]
    #: :class:`commercetools.types.CartState` `(Named` ``cartState`` `in Commercetools)`
    cart_state: "CartState"
    #: Optional :class:`commercetools.types.Address` `(Named` ``shippingAddress`` `in Commercetools)`
    shipping_address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``billingAddress`` `in Commercetools)`
    billing_address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.InventoryMode` `(Named` ``inventoryMode`` `in Commercetools)`
    inventory_mode: typing.Optional["InventoryMode"]
    #: :class:`commercetools.types.TaxMode` `(Named` ``taxMode`` `in Commercetools)`
    tax_mode: "TaxMode"
    #: :class:`commercetools.types.RoundingMode` `(Named` ``taxRoundingMode`` `in Commercetools)`
    tax_rounding_mode: "RoundingMode"
    #: :class:`commercetools.types.TaxCalculationMode` `(Named` ``taxCalculationMode`` `in Commercetools)`
    tax_calculation_mode: "TaxCalculationMode"
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupReference"]
    #: Optional :class:`str`
    country: typing.Optional["str"]
    #: Optional :class:`commercetools.types.ShippingInfo` `(Named` ``shippingInfo`` `in Commercetools)`
    shipping_info: typing.Optional["ShippingInfo"]
    #: Optional list of :class:`commercetools.types.DiscountCodeInfo` `(Named` ``discountCodes`` `in Commercetools)`
    discount_codes: typing.Optional[typing.List["DiscountCodeInfo"]]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`commercetools.types.PaymentInfo` `(Named` ``paymentInfo`` `in Commercetools)`
    payment_info: typing.Optional["PaymentInfo"]
    #: Optional :class:`str`
    locale: typing.Optional[str]
    #: Optional :class:`int` `(Named` ``deleteDaysAfterLastModification`` `in Commercetools)`
    delete_days_after_last_modification: typing.Optional[int]
    #: List of :class:`commercetools.types.CartDiscountReference` `(Named` ``refusedGifts`` `in Commercetools)`
    refused_gifts: typing.List["CartDiscountReference"]
    #: :class:`commercetools.types.CartOrigin`
    origin: "CartOrigin"
    #: Optional :class:`commercetools.types.ShippingRateInput` `(Named` ``shippingRateInput`` `in Commercetools)`
    shipping_rate_input: typing.Optional["ShippingRateInput"]
    #: Optional list of :class:`commercetools.types.Address` `(Named` ``itemShippingAddresses`` `in Commercetools)`
    item_shipping_addresses: typing.Optional[typing.List["Address"]]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        line_items: typing.List["LineItem"],
        custom_line_items: typing.List["CustomLineItem"],
        total_price: "TypedMoney",
        cart_state: "CartState",
        tax_mode: "TaxMode",
        tax_rounding_mode: "RoundingMode",
        tax_calculation_mode: "TaxCalculationMode",
        refused_gifts: typing.List["CartDiscountReference"],
        origin: "CartOrigin",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        customer_id: typing.Optional[str] = None,
        customer_email: typing.Optional[str] = None,
        anonymous_id: typing.Optional[str] = None,
        store: typing.Optional["StoreKeyReference"] = None,
        taxed_price: typing.Optional["TaxedPrice"] = None,
        shipping_address: typing.Optional["Address"] = None,
        billing_address: typing.Optional["Address"] = None,
        inventory_mode: typing.Optional["InventoryMode"] = None,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        country: typing.Optional["str"] = None,
        shipping_info: typing.Optional["ShippingInfo"] = None,
        discount_codes: typing.Optional[typing.List["DiscountCodeInfo"]] = None,
        custom: typing.Optional["CustomFields"] = None,
        payment_info: typing.Optional["PaymentInfo"] = None,
        locale: typing.Optional[str] = None,
        delete_days_after_last_modification: typing.Optional[int] = None,
        shipping_rate_input: typing.Optional["ShippingRateInput"] = None,
        item_shipping_addresses: typing.Optional[typing.List["Address"]] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.customer_id = customer_id
        self.customer_email = customer_email
        self.anonymous_id = anonymous_id
        self.store = store
        self.line_items = line_items
        self.custom_line_items = custom_line_items
        self.total_price = total_price
        self.taxed_price = taxed_price
        self.cart_state = cart_state
        self.shipping_address = shipping_address
        self.billing_address = billing_address
        self.inventory_mode = inventory_mode
        self.tax_mode = tax_mode
        self.tax_rounding_mode = tax_rounding_mode
        self.tax_calculation_mode = tax_calculation_mode
        self.customer_group = customer_group
        self.country = country
        self.shipping_info = shipping_info
        self.discount_codes = discount_codes
        self.custom = custom
        self.payment_info = payment_info
        self.locale = locale
        self.delete_days_after_last_modification = delete_days_after_last_modification
        self.refused_gifts = refused_gifts
        self.origin = origin
        self.shipping_rate_input = shipping_rate_input
        self.item_shipping_addresses = item_shipping_addresses
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "Cart(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, customer_id=%r, customer_email=%r, anonymous_id=%r, store=%r, line_items=%r, custom_line_items=%r, total_price=%r, taxed_price=%r, cart_state=%r, shipping_address=%r, billing_address=%r, inventory_mode=%r, tax_mode=%r, tax_rounding_mode=%r, tax_calculation_mode=%r, customer_group=%r, country=%r, shipping_info=%r, discount_codes=%r, custom=%r, payment_info=%r, locale=%r, delete_days_after_last_modification=%r, refused_gifts=%r, origin=%r, shipping_rate_input=%r, item_shipping_addresses=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.customer_id,
                self.customer_email,
                self.anonymous_id,
                self.store,
                self.line_items,
                self.custom_line_items,
                self.total_price,
                self.taxed_price,
                self.cart_state,
                self.shipping_address,
                self.billing_address,
                self.inventory_mode,
                self.tax_mode,
                self.tax_rounding_mode,
                self.tax_calculation_mode,
                self.customer_group,
                self.country,
                self.shipping_info,
                self.discount_codes,
                self.custom,
                self.payment_info,
                self.locale,
                self.delete_days_after_last_modification,
                self.refused_gifts,
                self.origin,
                self.shipping_rate_input,
                self.item_shipping_addresses,
            )
        )


class CartDraft(_BaseType):
    #: :class:`str`
    currency: "str"
    #: Optional :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``customerEmail`` `in Commercetools)`
    customer_email: typing.Optional[str]
    #: Optional :class:`commercetools.types.CustomerGroupResourceIdentifier` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupResourceIdentifier"]
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.StoreResourceIdentifier`
    store: typing.Optional["StoreResourceIdentifier"]
    #: Optional :class:`str`
    country: typing.Optional[str]
    #: Optional :class:`commercetools.types.InventoryMode` `(Named` ``inventoryMode`` `in Commercetools)`
    inventory_mode: typing.Optional["InventoryMode"]
    #: Optional :class:`commercetools.types.TaxMode` `(Named` ``taxMode`` `in Commercetools)`
    tax_mode: typing.Optional["TaxMode"]
    #: Optional :class:`commercetools.types.RoundingMode` `(Named` ``taxRoundingMode`` `in Commercetools)`
    tax_rounding_mode: typing.Optional["RoundingMode"]
    #: Optional :class:`commercetools.types.TaxCalculationMode` `(Named` ``taxCalculationMode`` `in Commercetools)`
    tax_calculation_mode: typing.Optional["TaxCalculationMode"]
    #: Optional list of :class:`commercetools.types.LineItemDraft` `(Named` ``lineItems`` `in Commercetools)`
    line_items: typing.Optional[typing.List["LineItemDraft"]]
    #: Optional list of :class:`commercetools.types.CustomLineItemDraft` `(Named` ``customLineItems`` `in Commercetools)`
    custom_line_items: typing.Optional[typing.List["CustomLineItemDraft"]]
    #: Optional :class:`commercetools.types.Address` `(Named` ``shippingAddress`` `in Commercetools)`
    shipping_address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``billingAddress`` `in Commercetools)`
    billing_address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.ShippingMethodResourceIdentifier` `(Named` ``shippingMethod`` `in Commercetools)`
    shipping_method: typing.Optional["ShippingMethodResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRateForShippingMethod`` `in Commercetools)`
    external_tax_rate_for_shipping_method: typing.Optional["ExternalTaxRateDraft"]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`str`
    locale: typing.Optional[str]
    #: Optional :class:`int` `(Named` ``deleteDaysAfterLastModification`` `in Commercetools)`
    delete_days_after_last_modification: typing.Optional[int]
    #: Optional :class:`commercetools.types.CartOrigin`
    origin: typing.Optional["CartOrigin"]
    #: Optional :class:`commercetools.types.ShippingRateInputDraft` `(Named` ``shippingRateInput`` `in Commercetools)`
    shipping_rate_input: typing.Optional["ShippingRateInputDraft"]
    #: Optional list of :class:`commercetools.types.Address` `(Named` ``itemShippingAddresses`` `in Commercetools)`
    item_shipping_addresses: typing.Optional[typing.List["Address"]]

    def __init__(
        self,
        *,
        currency: "str",
        customer_id: typing.Optional[str] = None,
        customer_email: typing.Optional[str] = None,
        customer_group: typing.Optional["CustomerGroupResourceIdentifier"] = None,
        anonymous_id: typing.Optional[str] = None,
        store: typing.Optional["StoreResourceIdentifier"] = None,
        country: typing.Optional[str] = None,
        inventory_mode: typing.Optional["InventoryMode"] = None,
        tax_mode: typing.Optional["TaxMode"] = None,
        tax_rounding_mode: typing.Optional["RoundingMode"] = None,
        tax_calculation_mode: typing.Optional["TaxCalculationMode"] = None,
        line_items: typing.Optional[typing.List["LineItemDraft"]] = None,
        custom_line_items: typing.Optional[typing.List["CustomLineItemDraft"]] = None,
        shipping_address: typing.Optional["Address"] = None,
        billing_address: typing.Optional["Address"] = None,
        shipping_method: typing.Optional["ShippingMethodResourceIdentifier"] = None,
        external_tax_rate_for_shipping_method: typing.Optional[
            "ExternalTaxRateDraft"
        ] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        locale: typing.Optional[str] = None,
        delete_days_after_last_modification: typing.Optional[int] = None,
        origin: typing.Optional["CartOrigin"] = None,
        shipping_rate_input: typing.Optional["ShippingRateInputDraft"] = None,
        item_shipping_addresses: typing.Optional[typing.List["Address"]] = None
    ) -> None:
        self.currency = currency
        self.customer_id = customer_id
        self.customer_email = customer_email
        self.customer_group = customer_group
        self.anonymous_id = anonymous_id
        self.store = store
        self.country = country
        self.inventory_mode = inventory_mode
        self.tax_mode = tax_mode
        self.tax_rounding_mode = tax_rounding_mode
        self.tax_calculation_mode = tax_calculation_mode
        self.line_items = line_items
        self.custom_line_items = custom_line_items
        self.shipping_address = shipping_address
        self.billing_address = billing_address
        self.shipping_method = shipping_method
        self.external_tax_rate_for_shipping_method = (
            external_tax_rate_for_shipping_method
        )
        self.custom = custom
        self.locale = locale
        self.delete_days_after_last_modification = delete_days_after_last_modification
        self.origin = origin
        self.shipping_rate_input = shipping_rate_input
        self.item_shipping_addresses = item_shipping_addresses
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CartDraft(currency=%r, customer_id=%r, customer_email=%r, customer_group=%r, anonymous_id=%r, store=%r, country=%r, inventory_mode=%r, tax_mode=%r, tax_rounding_mode=%r, tax_calculation_mode=%r, line_items=%r, custom_line_items=%r, shipping_address=%r, billing_address=%r, shipping_method=%r, external_tax_rate_for_shipping_method=%r, custom=%r, locale=%r, delete_days_after_last_modification=%r, origin=%r, shipping_rate_input=%r, item_shipping_addresses=%r)"
            % (
                self.currency,
                self.customer_id,
                self.customer_email,
                self.customer_group,
                self.anonymous_id,
                self.store,
                self.country,
                self.inventory_mode,
                self.tax_mode,
                self.tax_rounding_mode,
                self.tax_calculation_mode,
                self.line_items,
                self.custom_line_items,
                self.shipping_address,
                self.billing_address,
                self.shipping_method,
                self.external_tax_rate_for_shipping_method,
                self.custom,
                self.locale,
                self.delete_days_after_last_modification,
                self.origin,
                self.shipping_rate_input,
                self.item_shipping_addresses,
            )
        )


class CartOrigin(enum.Enum):
    CUSTOMER = "Customer"
    MERCHANT = "Merchant"


class CartPagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.Cart`
    results: typing.Sequence["Cart"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["Cart"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CartPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class CartReference(Reference):
    #: Optional :class:`commercetools.types.Cart`
    obj: typing.Optional["Cart"]

    def __init__(self, *, id: str, obj: typing.Optional["Cart"] = None) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.CART, id=id)

    def __repr__(self) -> str:
        return "CartReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class CartResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.CART, id=id, key=key)

    def __repr__(self) -> str:
        return "CartResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class CartState(enum.Enum):
    ACTIVE = "Active"
    MERGED = "Merged"
    ORDERED = "Ordered"


class CartUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int, actions: list) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "CartUpdate(version=%r, actions=%r)" % (self.version, self.actions)


class CartUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "CartUpdateAction(action=%r)" % (self.action,)


class CustomLineItem(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"
    #: :class:`commercetools.types.TypedMoney`
    money: "TypedMoney"
    #: Optional :class:`commercetools.types.TaxedItemPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedItemPrice"]
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "TypedMoney"
    #: :class:`str`
    slug: str
    #: :class:`int`
    quantity: int
    #: List of :class:`commercetools.types.ItemState`
    state: typing.List["ItemState"]
    #: Optional :class:`commercetools.types.TaxCategoryReference` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryReference"]
    #: Optional :class:`commercetools.types.TaxRate` `(Named` ``taxRate`` `in Commercetools)`
    tax_rate: typing.Optional["TaxRate"]
    #: List of :class:`commercetools.types.DiscountedLineItemPriceForQuantity` `(Named` ``discountedPricePerQuantity`` `in Commercetools)`
    discounted_price_per_quantity: typing.List["DiscountedLineItemPriceForQuantity"]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`commercetools.types.ItemShippingDetails` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetails"]

    def __init__(
        self,
        *,
        id: str,
        name: "LocalizedString",
        money: "TypedMoney",
        total_price: "TypedMoney",
        slug: str,
        quantity: int,
        state: typing.List["ItemState"],
        discounted_price_per_quantity: typing.List[
            "DiscountedLineItemPriceForQuantity"
        ],
        taxed_price: typing.Optional["TaxedItemPrice"] = None,
        tax_category: typing.Optional["TaxCategoryReference"] = None,
        tax_rate: typing.Optional["TaxRate"] = None,
        custom: typing.Optional["CustomFields"] = None,
        shipping_details: typing.Optional["ItemShippingDetails"] = None
    ) -> None:
        self.id = id
        self.name = name
        self.money = money
        self.taxed_price = taxed_price
        self.total_price = total_price
        self.slug = slug
        self.quantity = quantity
        self.state = state
        self.tax_category = tax_category
        self.tax_rate = tax_rate
        self.discounted_price_per_quantity = discounted_price_per_quantity
        self.custom = custom
        self.shipping_details = shipping_details
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomLineItem(id=%r, name=%r, money=%r, taxed_price=%r, total_price=%r, slug=%r, quantity=%r, state=%r, tax_category=%r, tax_rate=%r, discounted_price_per_quantity=%r, custom=%r, shipping_details=%r)"
            % (
                self.id,
                self.name,
                self.money,
                self.taxed_price,
                self.total_price,
                self.slug,
                self.quantity,
                self.state,
                self.tax_category,
                self.tax_rate,
                self.discounted_price_per_quantity,
                self.custom,
                self.shipping_details,
            )
        )


class CustomLineItemDraft(_BaseType):
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.Money`
    money: "Money"
    #: :class:`str`
    slug: str
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        name: "LocalizedString",
        quantity: int,
        money: "Money",
        slug: str,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None,
        custom: typing.Optional["CustomFields"] = None,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.name = name
        self.quantity = quantity
        self.money = money
        self.slug = slug
        self.tax_category = tax_category
        self.external_tax_rate = external_tax_rate
        self.custom = custom
        self.shipping_details = shipping_details
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomLineItemDraft(name=%r, quantity=%r, money=%r, slug=%r, tax_category=%r, external_tax_rate=%r, custom=%r, shipping_details=%r)"
            % (
                self.name,
                self.quantity,
                self.money,
                self.slug,
                self.tax_category,
                self.external_tax_rate,
                self.custom,
                self.shipping_details,
            )
        )


class DiscountCodeInfo(_BaseType):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"
    #: :class:`commercetools.types.DiscountCodeState`
    state: "DiscountCodeState"

    def __init__(
        self, *, discount_code: "DiscountCodeReference", state: "DiscountCodeState"
    ) -> None:
        self.discount_code = discount_code
        self.state = state
        super().__init__()

    def __repr__(self) -> str:
        return "DiscountCodeInfo(discount_code=%r, state=%r)" % (
            self.discount_code,
            self.state,
        )


class DiscountCodeState(enum.Enum):
    NOT_ACTIVE = "NotActive"
    DOES_NOT_MATCH_CART = "DoesNotMatchCart"
    MATCHES_CART = "MatchesCart"
    MAX_APPLICATION_REACHED = "MaxApplicationReached"
    APPLICATION_STOPPED_BY_PREVIOUS_DISCOUNT = "ApplicationStoppedByPreviousDiscount"
    NOT_VALID = "NotValid"


class DiscountedLineItemPortion(_BaseType):
    #: :class:`commercetools.types.CartDiscountReference`
    discount: "CartDiscountReference"
    #: :class:`commercetools.types.TypedMoney` `(Named` ``discountedAmount`` `in Commercetools)`
    discounted_amount: "TypedMoney"

    def __init__(
        self, *, discount: "CartDiscountReference", discounted_amount: "TypedMoney"
    ) -> None:
        self.discount = discount
        self.discounted_amount = discounted_amount
        super().__init__()

    def __repr__(self) -> str:
        return "DiscountedLineItemPortion(discount=%r, discounted_amount=%r)" % (
            self.discount,
            self.discounted_amount,
        )


class DiscountedLineItemPrice(_BaseType):
    #: :class:`commercetools.types.TypedMoney`
    value: "TypedMoney"
    #: List of :class:`commercetools.types.DiscountedLineItemPortion` `(Named` ``includedDiscounts`` `in Commercetools)`
    included_discounts: typing.List["DiscountedLineItemPortion"]

    def __init__(
        self,
        *,
        value: "TypedMoney",
        included_discounts: typing.List["DiscountedLineItemPortion"]
    ) -> None:
        self.value = value
        self.included_discounts = included_discounts
        super().__init__()

    def __repr__(self) -> str:
        return "DiscountedLineItemPrice(value=%r, included_discounts=%r)" % (
            self.value,
            self.included_discounts,
        )


class DiscountedLineItemPriceForQuantity(_BaseType):
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.DiscountedLineItemPrice` `(Named` ``discountedPrice`` `in Commercetools)`
    discounted_price: "DiscountedLineItemPrice"

    def __init__(
        self, *, quantity: int, discounted_price: "DiscountedLineItemPrice"
    ) -> None:
        self.quantity = quantity
        self.discounted_price = discounted_price
        super().__init__()

    def __repr__(self) -> str:
        return (
            "DiscountedLineItemPriceForQuantity(quantity=%r, discounted_price=%r)"
            % (self.quantity, self.discounted_price)
        )


class ExternalLineItemTotalPrice(_BaseType):
    #: :class:`commercetools.types.Money`
    price: "Money"
    #: :class:`commercetools.types.Money` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "Money"

    def __init__(self, *, price: "Money", total_price: "Money") -> None:
        self.price = price
        self.total_price = total_price
        super().__init__()

    def __repr__(self) -> str:
        return "ExternalLineItemTotalPrice(price=%r, total_price=%r)" % (
            self.price,
            self.total_price,
        )


class ExternalTaxAmountDraft(_BaseType):
    #: :class:`commercetools.types.Money` `(Named` ``totalGross`` `in Commercetools)`
    total_gross: "Money"
    #: :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``taxRate`` `in Commercetools)`
    tax_rate: "ExternalTaxRateDraft"

    def __init__(
        self, *, total_gross: "Money", tax_rate: "ExternalTaxRateDraft"
    ) -> None:
        self.total_gross = total_gross
        self.tax_rate = tax_rate
        super().__init__()

    def __repr__(self) -> str:
        return "ExternalTaxAmountDraft(total_gross=%r, tax_rate=%r)" % (
            self.total_gross,
            self.tax_rate,
        )


class ExternalTaxRateDraft(_BaseType):
    #: :class:`str`
    name: str
    #: Optional :class:`int`
    amount: typing.Optional[int]
    #: :class:`str`
    country: str
    #: Optional :class:`str`
    state: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.SubRate` `(Named` ``subRates`` `in Commercetools)`
    sub_rates: typing.Optional[typing.List["SubRate"]]
    #: Optional :class:`bool` `(Named` ``includedInPrice`` `in Commercetools)`
    included_in_price: typing.Optional[bool]

    def __init__(
        self,
        *,
        name: str,
        country: str,
        amount: typing.Optional[int] = None,
        state: typing.Optional[str] = None,
        sub_rates: typing.Optional[typing.List["SubRate"]] = None,
        included_in_price: typing.Optional[bool] = None
    ) -> None:
        self.name = name
        self.amount = amount
        self.country = country
        self.state = state
        self.sub_rates = sub_rates
        self.included_in_price = included_in_price
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ExternalTaxRateDraft(name=%r, amount=%r, country=%r, state=%r, sub_rates=%r, included_in_price=%r)"
            % (
                self.name,
                self.amount,
                self.country,
                self.state,
                self.sub_rates,
                self.included_in_price,
            )
        )


class InventoryMode(enum.Enum):
    TRACK_ONLY = "TrackOnly"
    RESERVE_ON_ORDER = "ReserveOnOrder"
    NONE = "None"


class ItemShippingDetails(_BaseType):
    #: List of :class:`commercetools.types.ItemShippingTarget`
    targets: typing.List["ItemShippingTarget"]
    #: :class:`bool`
    valid: bool

    def __init__(
        self, *, targets: typing.List["ItemShippingTarget"], valid: bool
    ) -> None:
        self.targets = targets
        self.valid = valid
        super().__init__()

    def __repr__(self) -> str:
        return "ItemShippingDetails(targets=%r, valid=%r)" % (self.targets, self.valid)


class ItemShippingDetailsDraft(_BaseType):
    #: List of :class:`commercetools.types.ItemShippingTarget`
    targets: typing.List["ItemShippingTarget"]

    def __init__(self, *, targets: typing.List["ItemShippingTarget"]) -> None:
        self.targets = targets
        super().__init__()

    def __repr__(self) -> str:
        return "ItemShippingDetailsDraft(targets=%r)" % (self.targets,)


class ItemShippingTarget(_BaseType):
    #: :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: str
    #: :class:`int`
    quantity: int

    def __init__(self, *, address_key: str, quantity: int) -> None:
        self.address_key = address_key
        self.quantity = quantity
        super().__init__()

    def __repr__(self) -> str:
        return "ItemShippingTarget(address_key=%r, quantity=%r)" % (
            self.address_key,
            self.quantity,
        )


class LineItem(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: str
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``productSlug`` `in Commercetools)`
    product_slug: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.ProductTypeReference` `(Named` ``productType`` `in Commercetools)`
    product_type: "ProductTypeReference"
    #: :class:`commercetools.types.ProductVariant`
    variant: "ProductVariant"
    #: :class:`commercetools.types.Price`
    price: "Price"
    #: Optional :class:`commercetools.types.TaxedItemPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedItemPrice"]
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "TypedMoney"
    #: :class:`int`
    quantity: int
    #: List of :class:`commercetools.types.ItemState`
    state: typing.List["ItemState"]
    #: Optional :class:`commercetools.types.TaxRate` `(Named` ``taxRate`` `in Commercetools)`
    tax_rate: typing.Optional["TaxRate"]
    #: Optional :class:`commercetools.types.ChannelReference` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelReference"]
    #: Optional :class:`commercetools.types.ChannelReference` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelReference"]
    #: List of :class:`commercetools.types.DiscountedLineItemPriceForQuantity` `(Named` ``discountedPricePerQuantity`` `in Commercetools)`
    discounted_price_per_quantity: typing.List["DiscountedLineItemPriceForQuantity"]
    #: :class:`commercetools.types.LineItemPriceMode` `(Named` ``priceMode`` `in Commercetools)`
    price_mode: "LineItemPriceMode"
    #: :class:`commercetools.types.LineItemMode` `(Named` ``lineItemMode`` `in Commercetools)`
    line_item_mode: "LineItemMode"
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`commercetools.types.ItemShippingDetails` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetails"]

    def __init__(
        self,
        *,
        id: str,
        product_id: str,
        name: "LocalizedString",
        product_type: "ProductTypeReference",
        variant: "ProductVariant",
        price: "Price",
        total_price: "TypedMoney",
        quantity: int,
        state: typing.List["ItemState"],
        discounted_price_per_quantity: typing.List[
            "DiscountedLineItemPriceForQuantity"
        ],
        price_mode: "LineItemPriceMode",
        line_item_mode: "LineItemMode",
        product_slug: typing.Optional["LocalizedString"] = None,
        taxed_price: typing.Optional["TaxedItemPrice"] = None,
        tax_rate: typing.Optional["TaxRate"] = None,
        supply_channel: typing.Optional["ChannelReference"] = None,
        distribution_channel: typing.Optional["ChannelReference"] = None,
        custom: typing.Optional["CustomFields"] = None,
        shipping_details: typing.Optional["ItemShippingDetails"] = None
    ) -> None:
        self.id = id
        self.product_id = product_id
        self.name = name
        self.product_slug = product_slug
        self.product_type = product_type
        self.variant = variant
        self.price = price
        self.taxed_price = taxed_price
        self.total_price = total_price
        self.quantity = quantity
        self.state = state
        self.tax_rate = tax_rate
        self.supply_channel = supply_channel
        self.distribution_channel = distribution_channel
        self.discounted_price_per_quantity = discounted_price_per_quantity
        self.price_mode = price_mode
        self.line_item_mode = line_item_mode
        self.custom = custom
        self.shipping_details = shipping_details
        super().__init__()

    def __repr__(self) -> str:
        return (
            "LineItem(id=%r, product_id=%r, name=%r, product_slug=%r, product_type=%r, variant=%r, price=%r, taxed_price=%r, total_price=%r, quantity=%r, state=%r, tax_rate=%r, supply_channel=%r, distribution_channel=%r, discounted_price_per_quantity=%r, price_mode=%r, line_item_mode=%r, custom=%r, shipping_details=%r)"
            % (
                self.id,
                self.product_id,
                self.name,
                self.product_slug,
                self.product_type,
                self.variant,
                self.price,
                self.taxed_price,
                self.total_price,
                self.quantity,
                self.state,
                self.tax_rate,
                self.supply_channel,
                self.distribution_channel,
                self.discounted_price_per_quantity,
                self.price_mode,
                self.line_item_mode,
                self.custom,
                self.shipping_details,
            )
        )


class LineItemDraft(_BaseType):
    #: Optional :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: typing.Optional[str]
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        product_id: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        distribution_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.product_id = product_id
        self.variant_id = variant_id
        self.sku = sku
        self.quantity = quantity
        self.supply_channel = supply_channel
        self.distribution_channel = distribution_channel
        self.external_tax_rate = external_tax_rate
        self.custom = custom
        self.external_price = external_price
        self.external_total_price = external_total_price
        self.shipping_details = shipping_details
        super().__init__()

    def __repr__(self) -> str:
        return (
            "LineItemDraft(product_id=%r, variant_id=%r, sku=%r, quantity=%r, supply_channel=%r, distribution_channel=%r, external_tax_rate=%r, custom=%r, external_price=%r, external_total_price=%r, shipping_details=%r)"
            % (
                self.product_id,
                self.variant_id,
                self.sku,
                self.quantity,
                self.supply_channel,
                self.distribution_channel,
                self.external_tax_rate,
                self.custom,
                self.external_price,
                self.external_total_price,
                self.shipping_details,
            )
        )


class LineItemMode(enum.Enum):
    STANDARD = "Standard"
    GIFT_LINE_ITEM = "GiftLineItem"


class LineItemPriceMode(enum.Enum):
    PLATFORM = "Platform"
    EXTERNAL_TOTAL = "ExternalTotal"
    EXTERNAL_PRICE = "ExternalPrice"


class ProductPublishScope(enum.Enum):
    ALL = "All"
    PRICES = "Prices"


class ReplicaCartDraft(_BaseType):
    #: :class:`commercetools.types.CartReference`
    reference: "CartReference"

    def __init__(self, *, reference: "CartReference") -> None:
        self.reference = reference
        super().__init__()

    def __repr__(self) -> str:
        return "ReplicaCartDraft(reference=%r)" % (self.reference,)


class RoundingMode(enum.Enum):
    HALF_EVEN = "HalfEven"
    HALF_UP = "HalfUp"
    HALF_DOWN = "HalfDown"


class ShippingInfo(_BaseType):
    #: :class:`str` `(Named` ``shippingMethodName`` `in Commercetools)`
    shipping_method_name: str
    #: :class:`commercetools.types.TypedMoney`
    price: "TypedMoney"
    #: :class:`commercetools.types.ShippingRate` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: "ShippingRate"
    #: Optional :class:`commercetools.types.TaxedItemPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedItemPrice"]
    #: Optional :class:`commercetools.types.TaxRate` `(Named` ``taxRate`` `in Commercetools)`
    tax_rate: typing.Optional["TaxRate"]
    #: Optional :class:`commercetools.types.TaxCategoryReference` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryReference"]
    #: Optional :class:`commercetools.types.ShippingMethodReference` `(Named` ``shippingMethod`` `in Commercetools)`
    shipping_method: typing.Optional["ShippingMethodReference"]
    #: Optional list of :class:`commercetools.types.Delivery`
    deliveries: typing.Optional[typing.List["Delivery"]]
    #: Optional :class:`commercetools.types.DiscountedLineItemPrice` `(Named` ``discountedPrice`` `in Commercetools)`
    discounted_price: typing.Optional["DiscountedLineItemPrice"]
    #: :class:`commercetools.types.ShippingMethodState` `(Named` ``shippingMethodState`` `in Commercetools)`
    shipping_method_state: "ShippingMethodState"

    def __init__(
        self,
        *,
        shipping_method_name: str,
        price: "TypedMoney",
        shipping_rate: "ShippingRate",
        shipping_method_state: "ShippingMethodState",
        taxed_price: typing.Optional["TaxedItemPrice"] = None,
        tax_rate: typing.Optional["TaxRate"] = None,
        tax_category: typing.Optional["TaxCategoryReference"] = None,
        shipping_method: typing.Optional["ShippingMethodReference"] = None,
        deliveries: typing.Optional[typing.List["Delivery"]] = None,
        discounted_price: typing.Optional["DiscountedLineItemPrice"] = None
    ) -> None:
        self.shipping_method_name = shipping_method_name
        self.price = price
        self.shipping_rate = shipping_rate
        self.taxed_price = taxed_price
        self.tax_rate = tax_rate
        self.tax_category = tax_category
        self.shipping_method = shipping_method
        self.deliveries = deliveries
        self.discounted_price = discounted_price
        self.shipping_method_state = shipping_method_state
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ShippingInfo(shipping_method_name=%r, price=%r, shipping_rate=%r, taxed_price=%r, tax_rate=%r, tax_category=%r, shipping_method=%r, deliveries=%r, discounted_price=%r, shipping_method_state=%r)"
            % (
                self.shipping_method_name,
                self.price,
                self.shipping_rate,
                self.taxed_price,
                self.tax_rate,
                self.tax_category,
                self.shipping_method,
                self.deliveries,
                self.discounted_price,
                self.shipping_method_state,
            )
        )


class ShippingMethodState(enum.Enum):
    DOES_NOT_MATCH_CART = "DoesNotMatchCart"
    MATCHES_CART = "MatchesCart"


class ShippingRateInput(_BaseType):
    #: :class:`str`
    type: str

    def __init__(self, *, type: str) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "ShippingRateInput(type=%r)" % (self.type,)


class ShippingRateInputDraft(_BaseType):
    #: :class:`str`
    type: str

    def __init__(self, *, type: str) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "ShippingRateInputDraft(type=%r)" % (self.type,)


class TaxCalculationMode(enum.Enum):
    LINE_ITEM_LEVEL = "LineItemLevel"
    UNIT_PRICE_LEVEL = "UnitPriceLevel"


class TaxMode(enum.Enum):
    PLATFORM = "Platform"
    EXTERNAL = "External"
    EXTERNAL_AMOUNT = "ExternalAmount"
    DISABLED = "Disabled"


class TaxPortion(_BaseType):
    #: Optional :class:`str`
    name: typing.Optional[str]
    #: :class:`float`
    rate: float
    #: :class:`commercetools.types.TypedMoney`
    amount: "TypedMoney"

    def __init__(
        self, *, rate: float, amount: "TypedMoney", name: typing.Optional[str] = None
    ) -> None:
        self.name = name
        self.rate = rate
        self.amount = amount
        super().__init__()

    def __repr__(self) -> str:
        return "TaxPortion(name=%r, rate=%r, amount=%r)" % (
            self.name,
            self.rate,
            self.amount,
        )


class TaxPortionDraft(_BaseType):
    #: Optional :class:`str`
    name: typing.Optional[str]
    #: :class:`float`
    rate: float
    #: :class:`commercetools.types.Money`
    amount: "Money"

    def __init__(
        self, *, rate: float, amount: "Money", name: typing.Optional[str] = None
    ) -> None:
        self.name = name
        self.rate = rate
        self.amount = amount
        super().__init__()

    def __repr__(self) -> str:
        return "TaxPortionDraft(name=%r, rate=%r, amount=%r)" % (
            self.name,
            self.rate,
            self.amount,
        )


class TaxedItemPrice(_BaseType):
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalNet`` `in Commercetools)`
    total_net: "TypedMoney"
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalGross`` `in Commercetools)`
    total_gross: "TypedMoney"

    def __init__(self, *, total_net: "TypedMoney", total_gross: "TypedMoney") -> None:
        self.total_net = total_net
        self.total_gross = total_gross
        super().__init__()

    def __repr__(self) -> str:
        return "TaxedItemPrice(total_net=%r, total_gross=%r)" % (
            self.total_net,
            self.total_gross,
        )


class TaxedPrice(_BaseType):
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalNet`` `in Commercetools)`
    total_net: "TypedMoney"
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalGross`` `in Commercetools)`
    total_gross: "TypedMoney"
    #: List of :class:`commercetools.types.TaxPortion` `(Named` ``taxPortions`` `in Commercetools)`
    tax_portions: typing.List["TaxPortion"]

    def __init__(
        self,
        *,
        total_net: "TypedMoney",
        total_gross: "TypedMoney",
        tax_portions: typing.List["TaxPortion"]
    ) -> None:
        self.total_net = total_net
        self.total_gross = total_gross
        self.tax_portions = tax_portions
        super().__init__()

    def __repr__(self) -> str:
        return "TaxedPrice(total_net=%r, total_gross=%r, tax_portions=%r)" % (
            self.total_net,
            self.total_gross,
            self.tax_portions,
        )


class TaxedPriceDraft(_BaseType):
    #: :class:`commercetools.types.TypedMoneyDraft` `(Named` ``totalNet`` `in Commercetools)`
    total_net: "TypedMoneyDraft"
    #: :class:`commercetools.types.TypedMoneyDraft` `(Named` ``totalGross`` `in Commercetools)`
    total_gross: "TypedMoneyDraft"
    #: List of :class:`commercetools.types.TaxPortionDraft` `(Named` ``taxPortions`` `in Commercetools)`
    tax_portions: typing.List["TaxPortionDraft"]

    def __init__(
        self,
        *,
        total_net: "TypedMoneyDraft",
        total_gross: "TypedMoneyDraft",
        tax_portions: typing.List["TaxPortionDraft"]
    ) -> None:
        self.total_net = total_net
        self.total_gross = total_gross
        self.tax_portions = tax_portions
        super().__init__()

    def __repr__(self) -> str:
        return "TaxedPriceDraft(total_net=%r, total_gross=%r, tax_portions=%r)" % (
            self.total_net,
            self.total_gross,
            self.tax_portions,
        )


class CartAddCustomLineItemAction(CartUpdateAction):
    #: :class:`commercetools.types.Money`
    money: "Money"
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"
    #: :class:`int`
    quantity: int
    #: :class:`str`
    slug: str
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        money: "Money",
        name: "LocalizedString",
        quantity: int,
        slug: str,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.money = money
        self.name = name
        self.quantity = quantity
        self.slug = slug
        self.tax_category = tax_category
        self.custom = custom
        self.external_tax_rate = external_tax_rate
        super().__init__(action="addCustomLineItem")

    def __repr__(self) -> str:
        return (
            "CartAddCustomLineItemAction(action=%r, money=%r, name=%r, quantity=%r, slug=%r, tax_category=%r, custom=%r, external_tax_rate=%r)"
            % (
                self.action,
                self.money,
                self.name,
                self.quantity,
                self.slug,
                self.tax_category,
                self.custom,
                self.external_tax_rate,
            )
        )


class CartAddDiscountCodeAction(CartUpdateAction):
    #: :class:`str`
    code: str

    def __init__(self, *, code: str) -> None:
        self.code = code
        super().__init__(action="addDiscountCode")

    def __repr__(self) -> str:
        return "CartAddDiscountCodeAction(action=%r, code=%r)" % (
            self.action,
            self.code,
        )


class CartAddItemShippingAddressAction(CartUpdateAction):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(action="addItemShippingAddress")

    def __repr__(self) -> str:
        return "CartAddItemShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class CartAddLineItemAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]
    #: Optional :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: typing.Optional[str]
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        distribution_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None,
        product_id: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.custom = custom
        self.distribution_channel = distribution_channel
        self.external_tax_rate = external_tax_rate
        self.product_id = product_id
        self.variant_id = variant_id
        self.sku = sku
        self.quantity = quantity
        self.supply_channel = supply_channel
        self.external_price = external_price
        self.external_total_price = external_total_price
        self.shipping_details = shipping_details
        super().__init__(action="addLineItem")

    def __repr__(self) -> str:
        return (
            "CartAddLineItemAction(action=%r, custom=%r, distribution_channel=%r, external_tax_rate=%r, product_id=%r, variant_id=%r, sku=%r, quantity=%r, supply_channel=%r, external_price=%r, external_total_price=%r, shipping_details=%r)"
            % (
                self.action,
                self.custom,
                self.distribution_channel,
                self.external_tax_rate,
                self.product_id,
                self.variant_id,
                self.sku,
                self.quantity,
                self.supply_channel,
                self.external_price,
                self.external_total_price,
                self.shipping_details,
            )
        )


class CartAddPaymentAction(CartUpdateAction):
    #: :class:`commercetools.types.PaymentResourceIdentifier`
    payment: "PaymentResourceIdentifier"

    def __init__(self, *, payment: "PaymentResourceIdentifier") -> None:
        self.payment = payment
        super().__init__(action="addPayment")

    def __repr__(self) -> str:
        return "CartAddPaymentAction(action=%r, payment=%r)" % (
            self.action,
            self.payment,
        )


class CartAddShoppingListAction(CartUpdateAction):
    #: :class:`commercetools.types.ShoppingListResourceIdentifier` `(Named` ``shoppingList`` `in Commercetools)`
    shopping_list: "ShoppingListResourceIdentifier"
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelResourceIdentifier"]

    def __init__(
        self,
        *,
        shopping_list: "ShoppingListResourceIdentifier",
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        distribution_channel: typing.Optional["ChannelResourceIdentifier"] = None
    ) -> None:
        self.shopping_list = shopping_list
        self.supply_channel = supply_channel
        self.distribution_channel = distribution_channel
        super().__init__(action="addShoppingList")

    def __repr__(self) -> str:
        return (
            "CartAddShoppingListAction(action=%r, shopping_list=%r, supply_channel=%r, distribution_channel=%r)"
            % (
                self.action,
                self.shopping_list,
                self.supply_channel,
                self.distribution_channel,
            )
        )


class CartApplyDeltaToCustomLineItemShippingDetailsTargetsAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: List of :class:`commercetools.types.ItemShippingTarget` `(Named` ``targetsDelta`` `in Commercetools)`
    targets_delta: typing.List["ItemShippingTarget"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        targets_delta: typing.List["ItemShippingTarget"]
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.targets_delta = targets_delta
        super().__init__(action="applyDeltaToCustomLineItemShippingDetailsTargets")

    def __repr__(self) -> str:
        return (
            "CartApplyDeltaToCustomLineItemShippingDetailsTargetsAction(action=%r, custom_line_item_id=%r, targets_delta=%r)"
            % (self.action, self.custom_line_item_id, self.targets_delta)
        )


class CartApplyDeltaToLineItemShippingDetailsTargetsAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: List of :class:`commercetools.types.ItemShippingTarget` `(Named` ``targetsDelta`` `in Commercetools)`
    targets_delta: typing.List["ItemShippingTarget"]

    def __init__(
        self, *, line_item_id: str, targets_delta: typing.List["ItemShippingTarget"]
    ) -> None:
        self.line_item_id = line_item_id
        self.targets_delta = targets_delta
        super().__init__(action="applyDeltaToLineItemShippingDetailsTargets")

    def __repr__(self) -> str:
        return (
            "CartApplyDeltaToLineItemShippingDetailsTargetsAction(action=%r, line_item_id=%r, targets_delta=%r)"
            % (self.action, self.line_item_id, self.targets_delta)
        )


class CartChangeCustomLineItemMoneyAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`commercetools.types.Money`
    money: "Money"

    def __init__(self, *, custom_line_item_id: str, money: "Money") -> None:
        self.custom_line_item_id = custom_line_item_id
        self.money = money
        super().__init__(action="changeCustomLineItemMoney")

    def __repr__(self) -> str:
        return (
            "CartChangeCustomLineItemMoneyAction(action=%r, custom_line_item_id=%r, money=%r)"
            % (self.action, self.custom_line_item_id, self.money)
        )


class CartChangeCustomLineItemQuantityAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`int`
    quantity: int

    def __init__(self, *, custom_line_item_id: str, quantity: int) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.quantity = quantity
        super().__init__(action="changeCustomLineItemQuantity")

    def __repr__(self) -> str:
        return (
            "CartChangeCustomLineItemQuantityAction(action=%r, custom_line_item_id=%r, quantity=%r)"
            % (self.action, self.custom_line_item_id, self.quantity)
        )


class CartChangeLineItemQuantityAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`int`
    quantity: int
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]

    def __init__(
        self,
        *,
        line_item_id: str,
        quantity: int,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.external_price = external_price
        self.external_total_price = external_total_price
        super().__init__(action="changeLineItemQuantity")

    def __repr__(self) -> str:
        return (
            "CartChangeLineItemQuantityAction(action=%r, line_item_id=%r, quantity=%r, external_price=%r, external_total_price=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.external_price,
                self.external_total_price,
            )
        )


class CartChangeTaxCalculationModeAction(CartUpdateAction):
    #: :class:`commercetools.types.TaxCalculationMode` `(Named` ``taxCalculationMode`` `in Commercetools)`
    tax_calculation_mode: "TaxCalculationMode"

    def __init__(self, *, tax_calculation_mode: "TaxCalculationMode") -> None:
        self.tax_calculation_mode = tax_calculation_mode
        super().__init__(action="changeTaxCalculationMode")

    def __repr__(self) -> str:
        return (
            "CartChangeTaxCalculationModeAction(action=%r, tax_calculation_mode=%r)"
            % (self.action, self.tax_calculation_mode)
        )


class CartChangeTaxModeAction(CartUpdateAction):
    #: :class:`commercetools.types.TaxMode` `(Named` ``taxMode`` `in Commercetools)`
    tax_mode: "TaxMode"

    def __init__(self, *, tax_mode: "TaxMode") -> None:
        self.tax_mode = tax_mode
        super().__init__(action="changeTaxMode")

    def __repr__(self) -> str:
        return "CartChangeTaxModeAction(action=%r, tax_mode=%r)" % (
            self.action,
            self.tax_mode,
        )


class CartChangeTaxRoundingModeAction(CartUpdateAction):
    #: :class:`commercetools.types.RoundingMode` `(Named` ``taxRoundingMode`` `in Commercetools)`
    tax_rounding_mode: "RoundingMode"

    def __init__(self, *, tax_rounding_mode: "RoundingMode") -> None:
        self.tax_rounding_mode = tax_rounding_mode
        super().__init__(action="changeTaxRoundingMode")

    def __repr__(self) -> str:
        return "CartChangeTaxRoundingModeAction(action=%r, tax_rounding_mode=%r)" % (
            self.action,
            self.tax_rounding_mode,
        )


class CartRecalculateAction(CartUpdateAction):
    #: Optional :class:`bool` `(Named` ``updateProductData`` `in Commercetools)`
    update_product_data: typing.Optional[bool]

    def __init__(self, *, update_product_data: typing.Optional[bool] = None) -> None:
        self.update_product_data = update_product_data
        super().__init__(action="recalculate")

    def __repr__(self) -> str:
        return "CartRecalculateAction(action=%r, update_product_data=%r)" % (
            self.action,
            self.update_product_data,
        )


class CartRemoveCustomLineItemAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str

    def __init__(self, *, custom_line_item_id: str) -> None:
        self.custom_line_item_id = custom_line_item_id
        super().__init__(action="removeCustomLineItem")

    def __repr__(self) -> str:
        return "CartRemoveCustomLineItemAction(action=%r, custom_line_item_id=%r)" % (
            self.action,
            self.custom_line_item_id,
        )


class CartRemoveDiscountCodeAction(CartUpdateAction):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"

    def __init__(self, *, discount_code: "DiscountCodeReference") -> None:
        self.discount_code = discount_code
        super().__init__(action="removeDiscountCode")

    def __repr__(self) -> str:
        return "CartRemoveDiscountCodeAction(action=%r, discount_code=%r)" % (
            self.action,
            self.discount_code,
        )


class CartRemoveItemShippingAddressAction(CartUpdateAction):
    #: :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: str

    def __init__(self, *, address_key: str) -> None:
        self.address_key = address_key
        super().__init__(action="removeItemShippingAddress")

    def __repr__(self) -> str:
        return "CartRemoveItemShippingAddressAction(action=%r, address_key=%r)" % (
            self.action,
            self.address_key,
        )


class CartRemoveLineItemAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetailsToRemove`` `in Commercetools)`
    shipping_details_to_remove: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        quantity: typing.Optional[int] = None,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None,
        shipping_details_to_remove: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.external_price = external_price
        self.external_total_price = external_total_price
        self.shipping_details_to_remove = shipping_details_to_remove
        super().__init__(action="removeLineItem")

    def __repr__(self) -> str:
        return (
            "CartRemoveLineItemAction(action=%r, line_item_id=%r, quantity=%r, external_price=%r, external_total_price=%r, shipping_details_to_remove=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.external_price,
                self.external_total_price,
                self.shipping_details_to_remove,
            )
        )


class CartRemovePaymentAction(CartUpdateAction):
    #: :class:`commercetools.types.PaymentResourceIdentifier`
    payment: "PaymentResourceIdentifier"

    def __init__(self, *, payment: "PaymentResourceIdentifier") -> None:
        self.payment = payment
        super().__init__(action="removePayment")

    def __repr__(self) -> str:
        return "CartRemovePaymentAction(action=%r, payment=%r)" % (
            self.action,
            self.payment,
        )


class CartSetAnonymousIdAction(CartUpdateAction):
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]

    def __init__(self, *, anonymous_id: typing.Optional[str] = None) -> None:
        self.anonymous_id = anonymous_id
        super().__init__(action="setAnonymousId")

    def __repr__(self) -> str:
        return "CartSetAnonymousIdAction(action=%r, anonymous_id=%r)" % (
            self.action,
            self.anonymous_id,
        )


class CartSetBillingAddressAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(self, *, address: typing.Optional["Address"] = None) -> None:
        self.address = address
        super().__init__(action="setBillingAddress")

    def __repr__(self) -> str:
        return "CartSetBillingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class CartSetCartTotalTaxAction(CartUpdateAction):
    #: :class:`commercetools.types.Money` `(Named` ``externalTotalGross`` `in Commercetools)`
    external_total_gross: "Money"
    #: Optional list of :class:`commercetools.types.TaxPortionDraft` `(Named` ``externalTaxPortions`` `in Commercetools)`
    external_tax_portions: typing.Optional[typing.List["TaxPortionDraft"]]

    def __init__(
        self,
        *,
        external_total_gross: "Money",
        external_tax_portions: typing.Optional[typing.List["TaxPortionDraft"]] = None
    ) -> None:
        self.external_total_gross = external_total_gross
        self.external_tax_portions = external_tax_portions
        super().__init__(action="setCartTotalTax")

    def __repr__(self) -> str:
        return (
            "CartSetCartTotalTaxAction(action=%r, external_total_gross=%r, external_tax_portions=%r)"
            % (self.action, self.external_total_gross, self.external_tax_portions)
        )


class CartSetCountryAction(CartUpdateAction):
    #: Optional :class:`str`
    country: typing.Optional["str"]

    def __init__(self, *, country: typing.Optional["str"] = None) -> None:
        self.country = country
        super().__init__(action="setCountry")

    def __repr__(self) -> str:
        return "CartSetCountryAction(action=%r, country=%r)" % (
            self.action,
            self.country,
        )


class CartSetCustomFieldAction(CartUpdateAction):
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(self, *, name: str, value: typing.Optional[typing.Any] = None) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "CartSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class CartSetCustomLineItemCustomFieldAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        name: str,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setCustomLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "CartSetCustomLineItemCustomFieldAction(action=%r, custom_line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.custom_line_item_id, self.name, self.value)
        )


class CartSetCustomLineItemCustomTypeAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "CartSetCustomLineItemCustomTypeAction(action=%r, custom_line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.custom_line_item_id, self.type, self.fields)
        )


class CartSetCustomLineItemShippingDetailsAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.shipping_details = shipping_details
        super().__init__(action="setCustomLineItemShippingDetails")

    def __repr__(self) -> str:
        return (
            "CartSetCustomLineItemShippingDetailsAction(action=%r, custom_line_item_id=%r, shipping_details=%r)"
            % (self.action, self.custom_line_item_id, self.shipping_details)
        )


class CartSetCustomLineItemTaxAmountAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setCustomLineItemTaxAmount")

    def __repr__(self) -> str:
        return (
            "CartSetCustomLineItemTaxAmountAction(action=%r, custom_line_item_id=%r, external_tax_amount=%r)"
            % (self.action, self.custom_line_item_id, self.external_tax_amount)
        )


class CartSetCustomLineItemTaxRateAction(CartUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setCustomLineItemTaxRate")

    def __repr__(self) -> str:
        return (
            "CartSetCustomLineItemTaxRateAction(action=%r, custom_line_item_id=%r, external_tax_rate=%r)"
            % (self.action, self.custom_line_item_id, self.external_tax_rate)
        )


class CartSetCustomShippingMethodAction(CartUpdateAction):
    #: :class:`str` `(Named` ``shippingMethodName`` `in Commercetools)`
    shipping_method_name: str
    #: :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: "ShippingRateDraft"
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        shipping_method_name: str,
        shipping_rate: "ShippingRateDraft",
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.shipping_method_name = shipping_method_name
        self.shipping_rate = shipping_rate
        self.tax_category = tax_category
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setCustomShippingMethod")

    def __repr__(self) -> str:
        return (
            "CartSetCustomShippingMethodAction(action=%r, shipping_method_name=%r, shipping_rate=%r, tax_category=%r, external_tax_rate=%r)"
            % (
                self.action,
                self.shipping_method_name,
                self.shipping_rate,
                self.tax_category,
                self.external_tax_rate,
            )
        )


class CartSetCustomTypeAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "CartSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class CartSetCustomerEmailAction(CartUpdateAction):
    #: :class:`str`
    email: str

    def __init__(self, *, email: str) -> None:
        self.email = email
        super().__init__(action="setCustomerEmail")

    def __repr__(self) -> str:
        return "CartSetCustomerEmailAction(action=%r, email=%r)" % (
            self.action,
            self.email,
        )


class CartSetCustomerGroupAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.CustomerGroupResourceIdentifier` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupResourceIdentifier"]

    def __init__(
        self,
        *,
        customer_group: typing.Optional["CustomerGroupResourceIdentifier"] = None
    ) -> None:
        self.customer_group = customer_group
        super().__init__(action="setCustomerGroup")

    def __repr__(self) -> str:
        return "CartSetCustomerGroupAction(action=%r, customer_group=%r)" % (
            self.action,
            self.customer_group,
        )


class CartSetCustomerIdAction(CartUpdateAction):
    #: Optional :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: typing.Optional[str]

    def __init__(self, *, customer_id: typing.Optional[str] = None) -> None:
        self.customer_id = customer_id
        super().__init__(action="setCustomerId")

    def __repr__(self) -> str:
        return "CartSetCustomerIdAction(action=%r, customer_id=%r)" % (
            self.action,
            self.customer_id,
        )


class CartSetDeleteDaysAfterLastModificationAction(CartUpdateAction):
    #: Optional :class:`int` `(Named` ``deleteDaysAfterLastModification`` `in Commercetools)`
    delete_days_after_last_modification: typing.Optional[int]

    def __init__(
        self, *, delete_days_after_last_modification: typing.Optional[int] = None
    ) -> None:
        self.delete_days_after_last_modification = delete_days_after_last_modification
        super().__init__(action="setDeleteDaysAfterLastModification")

    def __repr__(self) -> str:
        return (
            "CartSetDeleteDaysAfterLastModificationAction(action=%r, delete_days_after_last_modification=%r)"
            % (self.action, self.delete_days_after_last_modification)
        )


class CartSetLineItemCustomFieldAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self, *, line_item_id: str, name: str, value: typing.Optional[typing.Any] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "CartSetLineItemCustomFieldAction(action=%r, line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.line_item_id, self.name, self.value)
        )


class CartSetLineItemCustomTypeAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        line_item_id: str,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "CartSetLineItemCustomTypeAction(action=%r, line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.line_item_id, self.type, self.fields)
        )


class CartSetLineItemPriceAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]

    def __init__(
        self, *, line_item_id: str, external_price: typing.Optional["Money"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_price = external_price
        super().__init__(action="setLineItemPrice")

    def __repr__(self) -> str:
        return (
            "CartSetLineItemPriceAction(action=%r, line_item_id=%r, external_price=%r)"
            % (self.action, self.line_item_id, self.external_price)
        )


class CartSetLineItemShippingDetailsAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.shipping_details = shipping_details
        super().__init__(action="setLineItemShippingDetails")

    def __repr__(self) -> str:
        return (
            "CartSetLineItemShippingDetailsAction(action=%r, line_item_id=%r, shipping_details=%r)"
            % (self.action, self.line_item_id, self.shipping_details)
        )


class CartSetLineItemTaxAmountAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setLineItemTaxAmount")

    def __repr__(self) -> str:
        return (
            "CartSetLineItemTaxAmountAction(action=%r, line_item_id=%r, external_tax_amount=%r)"
            % (self.action, self.line_item_id, self.external_tax_amount)
        )


class CartSetLineItemTaxRateAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setLineItemTaxRate")

    def __repr__(self) -> str:
        return (
            "CartSetLineItemTaxRateAction(action=%r, line_item_id=%r, external_tax_rate=%r)"
            % (self.action, self.line_item_id, self.external_tax_rate)
        )


class CartSetLineItemTotalPriceAction(CartUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]

    def __init__(
        self,
        *,
        line_item_id: str,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_total_price = external_total_price
        super().__init__(action="setLineItemTotalPrice")

    def __repr__(self) -> str:
        return (
            "CartSetLineItemTotalPriceAction(action=%r, line_item_id=%r, external_total_price=%r)"
            % (self.action, self.line_item_id, self.external_total_price)
        )


class CartSetLocaleAction(CartUpdateAction):
    #: Optional :class:`str`
    locale: typing.Optional[str]

    def __init__(self, *, locale: typing.Optional[str] = None) -> None:
        self.locale = locale
        super().__init__(action="setLocale")

    def __repr__(self) -> str:
        return "CartSetLocaleAction(action=%r, locale=%r)" % (self.action, self.locale)


class CartSetShippingAddressAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(self, *, address: typing.Optional["Address"] = None) -> None:
        self.address = address
        super().__init__(action="setShippingAddress")

    def __repr__(self) -> str:
        return "CartSetShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class CartSetShippingMethodAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.ShippingMethodResourceIdentifier` `(Named` ``shippingMethod`` `in Commercetools)`
    shipping_method: typing.Optional["ShippingMethodResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        shipping_method: typing.Optional["ShippingMethodResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.shipping_method = shipping_method
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingMethod")

    def __repr__(self) -> str:
        return (
            "CartSetShippingMethodAction(action=%r, shipping_method=%r, external_tax_rate=%r)"
            % (self.action, self.shipping_method, self.external_tax_rate)
        )


class CartSetShippingMethodTaxAmountAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self, *, external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setShippingMethodTaxAmount")

    def __repr__(self) -> str:
        return (
            "CartSetShippingMethodTaxAmountAction(action=%r, external_tax_amount=%r)"
            % (self.action, self.external_tax_amount)
        )


class CartSetShippingMethodTaxRateAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self, *, external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingMethodTaxRate")

    def __repr__(self) -> str:
        return "CartSetShippingMethodTaxRateAction(action=%r, external_tax_rate=%r)" % (
            self.action,
            self.external_tax_rate,
        )


class CartSetShippingRateInputAction(CartUpdateAction):
    #: Optional :class:`commercetools.types.ShippingRateInputDraft` `(Named` ``shippingRateInput`` `in Commercetools)`
    shipping_rate_input: typing.Optional["ShippingRateInputDraft"]

    def __init__(
        self, *, shipping_rate_input: typing.Optional["ShippingRateInputDraft"] = None
    ) -> None:
        self.shipping_rate_input = shipping_rate_input
        super().__init__(action="setShippingRateInput")

    def __repr__(self) -> str:
        return "CartSetShippingRateInputAction(action=%r, shipping_rate_input=%r)" % (
            self.action,
            self.shipping_rate_input,
        )


class CartUpdateItemShippingAddressAction(CartUpdateAction):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(action="updateItemShippingAddress")

    def __repr__(self) -> str:
        return "CartUpdateItemShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class ClassificationShippingRateInput(ShippingRateInput):
    #: :class:`str`
    key: str
    #: :class:`commercetools.types.LocalizedString`
    label: "LocalizedString"

    def __init__(self, *, key: str, label: "LocalizedString") -> None:
        self.key = key
        self.label = label
        super().__init__(type="Classification")

    def __repr__(self) -> str:
        return "ClassificationShippingRateInput(type=%r, key=%r, label=%r)" % (
            self.type,
            self.key,
            self.label,
        )


class ClassificationShippingRateInputDraft(ShippingRateInputDraft):
    #: :class:`str`
    key: str

    def __init__(self, *, key: str) -> None:
        self.key = key
        super().__init__(type="Classification")

    def __repr__(self) -> str:
        return "ClassificationShippingRateInputDraft(type=%r, key=%r)" % (
            self.type,
            self.key,
        )


class ScoreShippingRateInput(ShippingRateInput):
    #: :class:`int`
    score: int

    def __init__(self, *, score: int) -> None:
        self.score = score
        super().__init__(type="Score")

    def __repr__(self) -> str:
        return "ScoreShippingRateInput(type=%r, score=%r)" % (self.type, self.score)


class ScoreShippingRateInputDraft(ShippingRateInputDraft):
    #: :class:`int`
    score: int

    def __init__(self, *, score: int) -> None:
        self.score = score
        super().__init__(type="Score")

    def __repr__(self) -> str:
        return "ScoreShippingRateInputDraft(type=%r, score=%r)" % (
            self.type,
            self.score,
        )
