# DO NOT EDIT! This file is automatically generated
import typing

from commercetools._schemas._category import (
    CategoryDraftSchema,
    CategoryPagedQueryResponseSchema,
    CategorySchema,
    CategoryUpdateSchema,
)
from commercetools.helpers import RemoveEmptyValuesMixin
from commercetools.types._category import (
    Category,
    CategoryDraft,
    CategoryPagedQueryResponse,
    CategoryUpdate,
    CategoryUpdateAction,
)
from commercetools.typing import OptionalListStr

from . import abstract, traits


class _CategoryQuerySchema(
    traits.ExpandableSchema,
    traits.SortableSchema,
    traits.PagingSchema,
    traits.QuerySchema,
):
    pass


class _CategoryUpdateSchema(traits.ExpandableSchema, traits.VersionedSchema):
    pass


class _CategoryDeleteSchema(traits.VersionedSchema, traits.ExpandableSchema):
    pass


class CategoryService(abstract.AbstractService):
    """Categories are used to organize products in a hierarchical structure."""

    def get_by_id(self, id: str, *, expand: OptionalListStr = None) -> Category:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"categories/{id}", params=params, schema_cls=CategorySchema
        )

    def get_by_key(self, key: str, *, expand: OptionalListStr = None) -> Category:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"categories/key={key}", params=params, schema_cls=CategorySchema
        )

    def query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> CategoryPagedQueryResponse:
        """Categories are used to organize products in a hierarchical structure.
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "withTotal": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _CategoryQuerySchema,
        )
        return self._client._get(
            endpoint="categories",
            params=params,
            schema_cls=CategoryPagedQueryResponseSchema,
        )

    def create(
        self, draft: CategoryDraft, *, expand: OptionalListStr = None
    ) -> Category:
        """Creating a category produces the CategoryCreated message.

        Categories are used to organize products in a hierarchical structure.
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="categories",
            params=params,
            data_object=draft,
            request_schema_cls=CategoryDraftSchema,
            response_schema_cls=CategorySchema,
        )

    def update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[CategoryUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> Category:
        params = self._serialize_params({"expand": expand}, _CategoryUpdateSchema)
        update_action = CategoryUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"categories/{id}",
            params=params,
            data_object=update_action,
            request_schema_cls=CategoryUpdateSchema,
            response_schema_cls=CategorySchema,
            force_update=force_update,
        )

    def update_by_key(
        self,
        key: str,
        version: int,
        actions: typing.List[CategoryUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> Category:
        params = self._serialize_params({"expand": expand}, _CategoryUpdateSchema)
        update_action = CategoryUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"categories/key={key}",
            params=params,
            data_object=update_action,
            request_schema_cls=CategoryUpdateSchema,
            response_schema_cls=CategorySchema,
            force_update=force_update,
        )

    def delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> Category:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _CategoryDeleteSchema
        )
        return self._client._delete(
            endpoint=f"categories/{id}",
            params=params,
            response_schema_cls=CategorySchema,
            force_delete=force_delete,
        )

    def delete_by_key(
        self,
        key: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> Category:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _CategoryDeleteSchema
        )
        return self._client._delete(
            endpoint=f"categories/key={key}",
            params=params,
            response_schema_cls=CategorySchema,
            force_delete=force_delete,
        )
