from typing import Any, Dict, Optional

import requests

from ...client import AuthenticatedClient
from ...models.exploits_api_v1_report_explanations_retrieve_response_200 import (
    ExploitsApiV1ReportExplanationsRetrieveResponse200,
)
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    client: AuthenticatedClient,
) -> Dict[str, Any]:
    url = "{}/exploits/api/v1/report/explanations".format(
        client.base_url,
    )

    headers: Dict[str, Any] = client.get_headers()

    return {
        "url": url,
        "headers": headers,
    }


def _parse_response(*, response: requests.Response) -> Optional[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    if response.status_code == 200:
        _response_200 = response.json()
        response_200: ExploitsApiV1ReportExplanationsRetrieveResponse200
        if isinstance(_response_200, Unset):
            response_200 = UNSET
        else:
            response_200 = ExploitsApiV1ReportExplanationsRetrieveResponse200.from_dict(_response_200)

        return response_200
    return None


def _build_response(*, response: requests.Response) -> Response[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    kwargs = _get_kwargs(
        client=client,
    )

    response = requests.get(
        verify=client.verify_ssl,
        auth=client.auth,
        timeout=client.timeout,
        **kwargs,
    )
    response.raise_for_status()

    return _build_response(response=response)


def sync(
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV1ReportExplanationsRetrieveResponse200]:
    """API endpoint for getting a report of all CVEs with exploit and their status
    for Incident Response.

    Format of results:
    ```
    {
       \"page_size\": <Number of CVEs on the page>,
       \"explanations\": [<List of CVEs with exploit together with current status explanation>],
    }
    ```"""

    return sync_detailed(
        client=client,
    ).parsed
