from typing import Any, Dict, Optional

import requests

from ...client import AuthenticatedClient
from ...models.exploits_api_v1_cve_map_retrieve_response_200 import ExploitsApiV1CveMapRetrieveResponse200
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    client: AuthenticatedClient,
) -> Dict[str, Any]:
    url = "{}/exploits/api/v1/cve_map".format(
        client.base_url,
    )

    headers: Dict[str, Any] = client.get_headers()

    return {
        "url": url,
        "headers": headers,
    }


def _parse_response(*, response: requests.Response) -> Optional[ExploitsApiV1CveMapRetrieveResponse200]:
    if response.status_code == 200:
        _response_200 = response.json()
        response_200: ExploitsApiV1CveMapRetrieveResponse200
        if isinstance(_response_200, Unset):
            response_200 = UNSET
        else:
            response_200 = ExploitsApiV1CveMapRetrieveResponse200.from_dict(_response_200)

        return response_200
    return None


def _build_response(*, response: requests.Response) -> Response[ExploitsApiV1CveMapRetrieveResponse200]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV1CveMapRetrieveResponse200]:
    kwargs = _get_kwargs(
        client=client,
    )

    response = requests.get(
        verify=client.verify_ssl,
        auth=client.auth,
        timeout=client.timeout,
        **kwargs,
    )
    response.raise_for_status()

    return _build_response(response=response)


def sync(
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV1CveMapRetrieveResponse200]:
    """API endpoint for getting simple exploits information mapped to impacted CVEs.

    The Insights Vulnerability application needs this format.

    Format of results:
    ```
    {
      \"page_size\": <Number of CVEs on the page>,
      \"cves\": {
        \"CVE-2222-0001\": [<List of exploits>],
        \"CVE-2222-0002\": [<List of exploits>],
        ...
      },
    }
    ```"""

    return sync_detailed(
        client=client,
    ).parsed
