# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.bounding_box_with_score import BoundingBoxWithScore

class TestPretrainedModelResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    result: Optional[Dict[str, float]] = Field(None, description="Classification value per label. For a neural network this will be the confidence, for anomalies the anomaly score.")
    bounding_boxes: Optional[List[BoundingBoxWithScore]] = Field(None, alias="boundingBoxes")
    __properties = ["success", "error", "result", "boundingBoxes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestPretrainedModelResponse:
        """Create an instance of TestPretrainedModelResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in bounding_boxes (list)
        _items = []
        if self.bounding_boxes:
            for _item in self.bounding_boxes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['boundingBoxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestPretrainedModelResponse:
        """Create an instance of TestPretrainedModelResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TestPretrainedModelResponse.parse_obj(obj)

        _obj = TestPretrainedModelResponse.parse_obj({
            "success": obj.get("success"),
            "error": obj.get("error"),
            "result": obj.get("result"),
            "bounding_boxes": [BoundingBoxWithScore.from_dict(_item) for _item in obj.get("boundingBoxes")] if obj.get("boundingBoxes") is not None else None
        })
        return _obj

