# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from edgeimpulse_api.models.performance_calibration_ground_truth_samples_inner import PerformanceCalibrationGroundTruthSamplesInner

class PerformanceCalibrationGroundTruth(BaseModel):
    type: StrictStr = Field(..., description="Whether this region is a single sample, a region of background noise, or a region of background noise that contains samples.")
    label_idx: StrictInt = Field(..., alias="labelIdx", description="Index of the label in the array of all labels")
    label_string: StrictStr = Field(..., alias="labelString", description="String label of the sample")
    start: StrictInt = Field(..., description="The start time of the region in milliseconds")
    length: StrictInt = Field(..., description="The length of the region in milliseconds")
    samples: Optional[List[PerformanceCalibrationGroundTruthSamplesInner]] = Field(None, description="If the region contains samples, all the samples within this region")
    __properties = ["type", "labelIdx", "labelString", "start", "length", "samples"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('sample', 'noise', 'combined_noise'):
            raise ValueError("must validate the enum values ('sample', 'noise', 'combined_noise')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PerformanceCalibrationGroundTruth:
        """Create an instance of PerformanceCalibrationGroundTruth from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in samples (list)
        _items = []
        if self.samples:
            for _item in self.samples:
                if _item:
                    _items.append(_item.to_dict())
            _dict['samples'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PerformanceCalibrationGroundTruth:
        """Create an instance of PerformanceCalibrationGroundTruth from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PerformanceCalibrationGroundTruth.parse_obj(obj)

        _obj = PerformanceCalibrationGroundTruth.parse_obj({
            "type": obj.get("type"),
            "label_idx": obj.get("labelIdx"),
            "label_string": obj.get("labelString"),
            "start": obj.get("start"),
            "length": obj.get("length"),
            "samples": [PerformanceCalibrationGroundTruthSamplesInner.from_dict(_item) for _item in obj.get("samples")] if obj.get("samples") is not None else None
        })
        return _obj

