# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator

class PerformanceCalibrationFalsePositive(BaseModel):
    type: StrictStr = Field(..., description="The type of false positive. Incorrect is when a detection matches the wrong ground truth. Duplicate is when the same ground truth was detected more than once. The first correct detection is considered a true positive but subsequent detections are considered false positives. Spurious is when the detection was not associated with any ground truth.")
    detection_time: StrictInt = Field(..., alias="detectionTime", description="The time of the detection in milliseconds")
    ground_truth_label: Optional[StrictStr] = Field(None, alias="groundTruthLabel", description="The label of any associated ground truth")
    ground_truth_start: Optional[float] = Field(None, alias="groundTruthStart", description="The start time of any associated ground truth")
    sample_ids: Optional[List[StrictInt]] = Field(None, alias="sampleIds", description="All of the sample IDs in the affected region")
    __properties = ["type", "detectionTime", "groundTruthLabel", "groundTruthStart", "sampleIds"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('incorrect', 'duplicate', 'spurious'):
            raise ValueError("must validate the enum values ('incorrect', 'duplicate', 'spurious')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PerformanceCalibrationFalsePositive:
        """Create an instance of PerformanceCalibrationFalsePositive from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PerformanceCalibrationFalsePositive:
        """Create an instance of PerformanceCalibrationFalsePositive from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PerformanceCalibrationFalsePositive.parse_obj(obj)

        _obj = PerformanceCalibrationFalsePositive.parse_obj({
            "type": obj.get("type"),
            "detection_time": obj.get("detectionTime"),
            "ground_truth_label": obj.get("groundTruthLabel"),
            "ground_truth_start": obj.get("groundTruthStart"),
            "sample_ids": obj.get("sampleIds")
        })
        return _obj

