# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.staff_info import StaffInfo

class OrganizationUser(BaseModel):
    id: StrictInt = ...
    username: StrictStr = ...
    name: StrictStr = ...
    photo: Optional[StrictStr] = None
    created: datetime = ...
    added: datetime = ...
    email: StrictStr = ...
    role: StrictStr = ...
    staff_info: StaffInfo = Field(..., alias="staffInfo")
    project_count: StrictInt = Field(..., alias="projectCount")
    datasets: List[StrictStr] = ...
    pending: StrictBool = ...
    __properties = ["id", "username", "name", "photo", "created", "added", "email", "role", "staffInfo", "projectCount", "datasets", "pending"]

    @validator('role')
    def role_validate_enum(cls, v):
        if v not in ('admin', 'member', 'guest'):
            raise ValueError("must validate the enum values ('admin', 'member', 'guest')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationUser:
        """Create an instance of OrganizationUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of staff_info
        if self.staff_info:
            _dict['staffInfo'] = self.staff_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationUser:
        """Create an instance of OrganizationUser from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationUser.parse_obj(obj)

        _obj = OrganizationUser.parse_obj({
            "id": obj.get("id"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "photo": obj.get("photo"),
            "created": obj.get("created"),
            "added": obj.get("added"),
            "email": obj.get("email"),
            "role": obj.get("role"),
            "staff_info": StaffInfo.from_dict(obj.get("staffInfo")) if obj.get("staffInfo") is not None else None,
            "project_count": obj.get("projectCount"),
            "datasets": obj.get("datasets"),
            "pending": obj.get("pending")
        })
        return _obj

