# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class Note(BaseModel):
    id: StrictInt = ...
    note: StrictStr = ...
    user_id: Optional[StrictInt] = Field(None, alias="userId")
    parent_id: Optional[StrictInt] = Field(None, alias="parentId", description="If the note is a response to a previous note, this value holds the Id of that note")
    created: datetime = Field(..., description="Timestamp when the note was created")
    user_name: Optional[StrictStr] = Field(None, alias="userName", description="Name of the user that created the note")
    user_photo: Optional[StrictStr] = Field(None, alias="userPhoto", description="Photo of the user that created the note")
    __properties = ["id", "note", "userId", "parentId", "created", "userName", "userPhoto"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Note:
        """Create an instance of Note from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Note:
        """Create an instance of Note from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Note.parse_obj(obj)

        _obj = Note.parse_obj({
            "id": obj.get("id"),
            "note": obj.get("note"),
            "user_id": obj.get("userId"),
            "parent_id": obj.get("parentId"),
            "created": obj.get("created"),
            "user_name": obj.get("userName"),
            "user_photo": obj.get("userPhoto")
        })
        return _obj

