# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.dsp_group_item_select_options_inner import DSPGroupItemSelectOptionsInner
from edgeimpulse_api.models.dsp_group_item_show_if import DSPGroupItemShowIf

class DSPGroupItem(BaseModel):
    name: StrictStr = ...
    value: Optional[StrictStr] = None
    default_value: StrictStr = Field(..., alias="defaultValue")
    type: StrictStr = ...
    help: StrictStr = ...
    param: StrictStr = ...
    select_options: Optional[List[DSPGroupItemSelectOptionsInner]] = Field(None, alias="selectOptions")
    readonly: StrictBool = ...
    should_show: StrictBool = Field(..., alias="shouldShow")
    show_if: Optional[DSPGroupItemShowIf] = Field(None, alias="showIf")
    __properties = ["name", "value", "defaultValue", "type", "help", "param", "selectOptions", "readonly", "shouldShow", "showIf"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DSPGroupItem:
        """Create an instance of DSPGroupItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in select_options (list)
        _items = []
        if self.select_options:
            for _item in self.select_options:
                if _item:
                    _items.append(_item.to_dict())
            _dict['selectOptions'] = _items
        # override the default output from pydantic by calling `to_dict()` of show_if
        if self.show_if:
            _dict['showIf'] = self.show_if.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DSPGroupItem:
        """Create an instance of DSPGroupItem from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DSPGroupItem.parse_obj(obj)

        _obj = DSPGroupItem.parse_obj({
            "name": obj.get("name"),
            "value": obj.get("value"),
            "default_value": obj.get("defaultValue"),
            "type": obj.get("type"),
            "help": obj.get("help"),
            "param": obj.get("param"),
            "select_options": [DSPGroupItemSelectOptionsInner.from_dict(_item) for _item in obj.get("selectOptions")] if obj.get("selectOptions") is not None else None,
            "readonly": obj.get("readonly"),
            "should_show": obj.get("shouldShow"),
            "show_if": DSPGroupItemShowIf.from_dict(obj.get("showIf")) if obj.get("showIf") is not None else None
        })
        return _obj

