# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

class CreateWhitelabelRequest(BaseModel):
    name: StrictStr = Field(..., description="The name of the white label.")
    domain: StrictStr = Field(..., description="The domain where the white label lives.")
    owner_organization_id: StrictInt = Field(..., alias="ownerOrganizationId")
    identity_providers: Optional[List[StrictStr]] = Field(None, alias="identityProviders", description="The list of allowed identity providers.")
    allow_password_auth: Optional[StrictBool] = Field(None, alias="allowPasswordAuth", description="Whether this white label accepts password based authentication.")
    deployment_targets: Optional[List[StrictStr]] = Field(None, alias="deploymentTargets", description="The list of deployment targets to show on the UI")
    documentation_url: Optional[StrictStr] = Field(None, alias="documentationUrl", description="Custom documentation URL")
    allow_signup: Optional[StrictBool] = Field(None, alias="allowSignup", description="Whether this white label allow sign ups or not.")
    allow_free_projects: Optional[StrictBool] = Field(None, alias="allowFreeProjects", description="Whether this white label allows the creation of free projects.")
    sandboxed: Optional[StrictBool] = Field(None, description="Whether this white label should work in sandboxed mode or not.")
    expose_public_projects: Optional[StrictBool] = Field(None, alias="exposePublicProjects", description="Whether public projects created in this white label scope should be exposed through the Public Projects API or not.")
    __properties = ["name", "domain", "ownerOrganizationId", "identityProviders", "allowPasswordAuth", "deploymentTargets", "documentationUrl", "allowSignup", "allowFreeProjects", "sandboxed", "exposePublicProjects"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateWhitelabelRequest:
        """Create an instance of CreateWhitelabelRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateWhitelabelRequest:
        """Create an instance of CreateWhitelabelRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateWhitelabelRequest.parse_obj(obj)

        _obj = CreateWhitelabelRequest.parse_obj({
            "name": obj.get("name"),
            "domain": obj.get("domain"),
            "owner_organization_id": obj.get("ownerOrganizationId"),
            "identity_providers": obj.get("identityProviders"),
            "allow_password_auth": obj.get("allowPasswordAuth"),
            "deployment_targets": obj.get("deploymentTargets"),
            "documentation_url": obj.get("documentationUrl"),
            "allow_signup": obj.get("allowSignup"),
            "allow_free_projects": obj.get("allowFreeProjects"),
            "sandboxed": obj.get("sandboxed"),
            "expose_public_projects": obj.get("exposePublicProjects")
        })
        return _obj

