# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator

class UpdateProjectRequest(BaseModel):
    logo: Optional[StrictStr] = Field(None, description="New logo URL, or set to `null` to remove the logo.")
    name: Optional[StrictStr] = Field(None, description="New project name.")
    description: Optional[StrictStr] = None
    last_deploy_eon_compiler: Optional[StrictBool] = Field(None, alias="lastDeployEonCompiler", description="Call this when clicking the Eon compiler setting")
    latency_device: Optional[StrictStr] = Field(None, alias="latencyDevice", description="MCU used for calculating latency")
    experiments: Optional[List[StrictStr]] = None
    show_create_first_impulse: Optional[StrictBool] = Field(None, alias="showCreateFirstImpulse", description="Whether to show the 'Create your first impulse' section on the dashboard")
    labeling_method: Optional[StrictStr] = Field(None, alias="labelingMethod", description="What labeling flow to use")
    selected_project_type_in_wizard: Optional[StrictStr] = Field(None, alias="selectedProjectTypeInWizard", description="Which option was selected in the project type wizard")
    getting_started_step: Optional[StrictInt] = Field(None, alias="gettingStartedStep", description="The next step in the getting started wizard, or set to -1 to clear the getting started wizard")
    use_gpu: Optional[StrictBool] = Field(None, alias="useGpu", description="Whether to use GPU for training")
    compute_time_limit_m: Optional[StrictInt] = Field(None, alias="computeTimeLimitM", description="Job limit in minutes")
    dsp_file_size_mb: Optional[StrictInt] = Field(None, alias="dspFileSizeMb", description="DSP file size in MB")
    enterprise_performance: Optional[StrictBool] = Field(None, alias="enterprisePerformance")
    train_job_ram_mb: Optional[StrictInt] = Field(None, alias="trainJobRamMb", description="Amount of RAM allocated to training jobs")
    metadata: Optional[Dict[str, Any]] = Field(None, description="New metadata about the project")
    readme: Optional[StrictStr] = Field(None, description="Readme for the project (in Markdown)")
    last_acquisition_label: Optional[StrictStr] = Field(None, alias="lastAcquisitionLabel")
    train_job_notification_uids: Optional[List[StrictInt]] = Field(None, alias="trainJobNotificationUids", description="The IDs of users who should be notified when a Keras or retrain job is finished.")
    dsp_job_notification_uids: Optional[List[StrictInt]] = Field(None, alias="dspJobNotificationUids", description="The IDs of users who should be notified when a DSP job is finished.")
    model_testing_job_notification_uids: Optional[List[StrictInt]] = Field(None, alias="modelTestingJobNotificationUids", description="The IDs of users who should be notified when a model testing job is finished.")
    export_job_notification_uids: Optional[List[StrictInt]] = Field(None, alias="exportJobNotificationUids", description="The IDs of users who should be notified when an export job is finished.")
    csv_import_config: Optional[Dict[str, Any]] = Field(None, alias="csvImportConfig", description="Config file specifying how to process CSV files.")
    in_pretrained_model_flow: Optional[StrictBool] = Field(None, alias="inPretrainedModelFlow")
    __properties = ["logo", "name", "description", "lastDeployEonCompiler", "latencyDevice", "experiments", "showCreateFirstImpulse", "labelingMethod", "selectedProjectTypeInWizard", "gettingStartedStep", "useGpu", "computeTimeLimitM", "dspFileSizeMb", "enterprisePerformance", "trainJobRamMb", "metadata", "readme", "lastAcquisitionLabel", "trainJobNotificationUids", "dspJobNotificationUids", "modelTestingJobNotificationUids", "exportJobNotificationUids", "csvImportConfig", "inPretrainedModelFlow"]

    @validator('labeling_method')
    def labeling_method_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('single_label', 'object_detection'):
            raise ValueError("must validate the enum values ('single_label', 'object_detection')")
        return v

    @validator('selected_project_type_in_wizard')
    def selected_project_type_in_wizard_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('accelerometer', 'audio', 'image_classification', 'object_detection', 'something_else'):
            raise ValueError("must validate the enum values ('accelerometer', 'audio', 'image_classification', 'object_detection', 'something_else')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateProjectRequest:
        """Create an instance of UpdateProjectRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateProjectRequest:
        """Create an instance of UpdateProjectRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UpdateProjectRequest.parse_obj(obj)

        _obj = UpdateProjectRequest.parse_obj({
            "logo": obj.get("logo"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "last_deploy_eon_compiler": obj.get("lastDeployEonCompiler"),
            "latency_device": obj.get("latencyDevice"),
            "experiments": obj.get("experiments"),
            "show_create_first_impulse": obj.get("showCreateFirstImpulse"),
            "labeling_method": obj.get("labelingMethod"),
            "selected_project_type_in_wizard": obj.get("selectedProjectTypeInWizard"),
            "getting_started_step": obj.get("gettingStartedStep"),
            "use_gpu": obj.get("useGpu"),
            "compute_time_limit_m": obj.get("computeTimeLimitM"),
            "dsp_file_size_mb": obj.get("dspFileSizeMb"),
            "enterprise_performance": obj.get("enterprisePerformance"),
            "train_job_ram_mb": obj.get("trainJobRamMb"),
            "metadata": obj.get("metadata"),
            "readme": obj.get("readme"),
            "last_acquisition_label": obj.get("lastAcquisitionLabel"),
            "train_job_notification_uids": obj.get("trainJobNotificationUids"),
            "dsp_job_notification_uids": obj.get("dspJobNotificationUids"),
            "model_testing_job_notification_uids": obj.get("modelTestingJobNotificationUids"),
            "export_job_notification_uids": obj.get("exportJobNotificationUids"),
            "csv_import_config": obj.get("csvImportConfig"),
            "in_pretrained_model_flow": obj.get("inPretrainedModelFlow")
        })
        return _obj

