# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.object_detection_last_layer import ObjectDetectionLastLayer
from edgeimpulse_api.models.organization_transfer_learning_operates_on import OrganizationTransferLearningOperatesOn

class UpdateOrganizationTransferLearningBlockRequest(BaseModel):
    name: Optional[StrictStr] = None
    docker_container: Optional[StrictStr] = Field(None, alias="dockerContainer")
    description: Optional[StrictStr] = None
    operates_on: Optional[OrganizationTransferLearningOperatesOn] = Field(None, alias="operatesOn")
    object_detection_last_layer: Optional[ObjectDetectionLastLayer] = Field(None, alias="objectDetectionLastLayer")
    implementation_version: Optional[StrictInt] = Field(None, alias="implementationVersion")
    is_public: Optional[StrictBool] = Field(None, alias="isPublic", description="Whether this block is publicly available to Edge Impulse users (if false, then only for members of the owning organization)")
    is_public_for_devices: Optional[List[StrictStr]] = Field(None, alias="isPublicForDevices", description="If `isPublic` is true, the list of devices (from latencyDevices) for which this model can be shown.")
    repository_url: Optional[StrictStr] = Field(None, alias="repositoryUrl", description="URL to the source code of this custom learn block.")
    __properties = ["name", "dockerContainer", "description", "operatesOn", "objectDetectionLastLayer", "implementationVersion", "isPublic", "isPublicForDevices", "repositoryUrl"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateOrganizationTransferLearningBlockRequest:
        """Create an instance of UpdateOrganizationTransferLearningBlockRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateOrganizationTransferLearningBlockRequest:
        """Create an instance of UpdateOrganizationTransferLearningBlockRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UpdateOrganizationTransferLearningBlockRequest.parse_obj(obj)

        _obj = UpdateOrganizationTransferLearningBlockRequest.parse_obj({
            "name": obj.get("name"),
            "docker_container": obj.get("dockerContainer"),
            "description": obj.get("description"),
            "operates_on": obj.get("operatesOn"),
            "object_detection_last_layer": obj.get("objectDetectionLastLayer"),
            "implementation_version": obj.get("implementationVersion"),
            "is_public": obj.get("isPublic"),
            "is_public_for_devices": obj.get("isPublicForDevices"),
            "repository_url": obj.get("repositoryUrl")
        })
        return _obj

