# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.keras_visual_layer_type import KerasVisualLayerType
from edgeimpulse_api.models.learn_block_type import LearnBlockType

class TransferLearningModel(BaseModel):
    name: StrictStr = ...
    short_name: StrictStr = Field(..., alias="shortName")
    description: StrictStr = ...
    has_neurons: StrictBool = Field(..., alias="hasNeurons")
    has_dropout: StrictBool = Field(..., alias="hasDropout")
    default_neurons: Optional[StrictInt] = Field(None, alias="defaultNeurons")
    default_dropout: Optional[float] = Field(None, alias="defaultDropout")
    default_learning_rate: Optional[float] = Field(None, alias="defaultLearningRate")
    default_training_cycles: Optional[float] = Field(None, alias="defaultTrainingCycles")
    has_image_augmentation: Optional[StrictBool] = Field(None, alias="hasImageAugmentation")
    type: KerasVisualLayerType = ...
    learn_block_type: Optional[LearnBlockType] = Field(None, alias="learnBlockType")
    organization_model_id: Optional[StrictInt] = Field(None, alias="organizationModelId")
    implementation_version: Optional[StrictInt] = Field(None, alias="implementationVersion")
    repository_url: Optional[StrictStr] = Field(None, alias="repositoryUrl")
    author: StrictStr = ...
    block_type: StrictStr = Field(..., alias="blockType")
    __properties = ["name", "shortName", "description", "hasNeurons", "hasDropout", "defaultNeurons", "defaultDropout", "defaultLearningRate", "defaultTrainingCycles", "hasImageAugmentation", "type", "learnBlockType", "organizationModelId", "implementationVersion", "repositoryUrl", "author", "blockType"]

    @validator('block_type')
    def block_type_validate_enum(cls, v):
        if v not in ('official', 'personal', 'enterprise', 'community'):
            raise ValueError("must validate the enum values ('official', 'personal', 'enterprise', 'community')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransferLearningModel:
        """Create an instance of TransferLearningModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransferLearningModel:
        """Create an instance of TransferLearningModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransferLearningModel.parse_obj(obj)

        _obj = TransferLearningModel.parse_obj({
            "name": obj.get("name"),
            "short_name": obj.get("shortName"),
            "description": obj.get("description"),
            "has_neurons": obj.get("hasNeurons"),
            "has_dropout": obj.get("hasDropout"),
            "default_neurons": obj.get("defaultNeurons"),
            "default_dropout": obj.get("defaultDropout"),
            "default_learning_rate": obj.get("defaultLearningRate"),
            "default_training_cycles": obj.get("defaultTrainingCycles"),
            "has_image_augmentation": obj.get("hasImageAugmentation"),
            "type": obj.get("type"),
            "learn_block_type": obj.get("learnBlockType"),
            "organization_model_id": obj.get("organizationModelId"),
            "implementation_version": obj.get("implementationVersion"),
            "repository_url": obj.get("repositoryUrl"),
            "author": obj.get("author"),
            "block_type": obj.get("blockType")
        })
        return _obj

