# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.score_trial_response_all_of_latency import ScoreTrialResponseAllOfLatency
from edgeimpulse_api.models.score_trial_response_all_of_ram import ScoreTrialResponseAllOfRam

class ScoreTrialResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    score: float = ...
    latency: ScoreTrialResponseAllOfLatency = ...
    ram: ScoreTrialResponseAllOfRam = ...
    rom: ScoreTrialResponseAllOfRam = ...
    __properties = ["success", "error", "score", "latency", "ram", "rom"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScoreTrialResponse:
        """Create an instance of ScoreTrialResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of latency
        if self.latency:
            _dict['latency'] = self.latency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ram
        if self.ram:
            _dict['ram'] = self.ram.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rom
        if self.rom:
            _dict['rom'] = self.rom.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ScoreTrialResponse:
        """Create an instance of ScoreTrialResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ScoreTrialResponse.parse_obj(obj)

        _obj = ScoreTrialResponse.parse_obj({
            "success": obj.get("success"),
            "error": obj.get("error"),
            "score": obj.get("score"),
            "latency": ScoreTrialResponseAllOfLatency.from_dict(obj.get("latency")) if obj.get("latency") is not None else None,
            "ram": ScoreTrialResponseAllOfRam.from_dict(obj.get("ram")) if obj.get("ram") is not None else None,
            "rom": ScoreTrialResponseAllOfRam.from_dict(obj.get("rom")) if obj.get("rom") is not None else None
        })
        return _obj

