# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictInt
from edgeimpulse_api.models.raw_sample_payload import RawSamplePayload
from edgeimpulse_api.models.sample import Sample

class RawSampleData(BaseModel):
    sample: Sample = ...
    payload: RawSamplePayload = ...
    total_payload_length: StrictInt = Field(..., alias="totalPayloadLength", description="Total number of payload values")
    __properties = ["sample", "payload", "totalPayloadLength"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RawSampleData:
        """Create an instance of RawSampleData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of sample
        if self.sample:
            _dict['sample'] = self.sample.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RawSampleData:
        """Create an instance of RawSampleData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RawSampleData.parse_obj(obj)

        _obj = RawSampleData.parse_obj({
            "sample": Sample.from_dict(obj.get("sample")) if obj.get("sample") is not None else None,
            "payload": RawSamplePayload.from_dict(obj.get("payload")) if obj.get("payload") is not None else None,
            "total_payload_length": obj.get("totalPayloadLength")
        })
        return _obj

