# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt
from edgeimpulse_api.models.organization import Organization
from edgeimpulse_api.models.organization_dataset import OrganizationDataset
from edgeimpulse_api.models.organization_info_response_all_of_default_compute_limits import OrganizationInfoResponseAllOfDefaultComputeLimits
from edgeimpulse_api.models.organization_info_response_all_of_entitlement_limits import OrganizationInfoResponseAllOfEntitlementLimits
from edgeimpulse_api.models.project_info_response_all_of_experiments import ProjectInfoResponseAllOfExperiments
from edgeimpulse_api.models.project_info_response_all_of_readme import ProjectInfoResponseAllOfReadme

class OrganizationInfoResponseAllOf(BaseModel):
    organization: Organization = ...
    datasets: List[OrganizationDataset] = ...
    default_compute_limits: OrganizationInfoResponseAllOfDefaultComputeLimits = Field(..., alias="defaultComputeLimits")
    entitlement_limits: Optional[OrganizationInfoResponseAllOfEntitlementLimits] = Field(None, alias="entitlementLimits")
    experiments: Optional[List[ProjectInfoResponseAllOfExperiments]] = Field(None, description="Experiments that the organization has access to. Enabling experiments can only be done through a JWT token.")
    readme: Optional[ProjectInfoResponseAllOfReadme] = None
    whitelabel_id: Optional[StrictInt] = Field(None, alias="whitelabelId")
    __properties = ["organization", "datasets", "defaultComputeLimits", "entitlementLimits", "experiments", "readme", "whitelabelId"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationInfoResponseAllOf:
        """Create an instance of OrganizationInfoResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in datasets (list)
        _items = []
        if self.datasets:
            for _item in self.datasets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['datasets'] = _items
        # override the default output from pydantic by calling `to_dict()` of default_compute_limits
        if self.default_compute_limits:
            _dict['defaultComputeLimits'] = self.default_compute_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entitlement_limits
        if self.entitlement_limits:
            _dict['entitlementLimits'] = self.entitlement_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in experiments (list)
        _items = []
        if self.experiments:
            for _item in self.experiments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['experiments'] = _items
        # override the default output from pydantic by calling `to_dict()` of readme
        if self.readme:
            _dict['readme'] = self.readme.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationInfoResponseAllOf:
        """Create an instance of OrganizationInfoResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationInfoResponseAllOf.parse_obj(obj)

        _obj = OrganizationInfoResponseAllOf.parse_obj({
            "organization": Organization.from_dict(obj.get("organization")) if obj.get("organization") is not None else None,
            "datasets": [OrganizationDataset.from_dict(_item) for _item in obj.get("datasets")] if obj.get("datasets") is not None else None,
            "default_compute_limits": OrganizationInfoResponseAllOfDefaultComputeLimits.from_dict(obj.get("defaultComputeLimits")) if obj.get("defaultComputeLimits") is not None else None,
            "entitlement_limits": OrganizationInfoResponseAllOfEntitlementLimits.from_dict(obj.get("entitlementLimits")) if obj.get("entitlementLimits") is not None else None,
            "experiments": [ProjectInfoResponseAllOfExperiments.from_dict(_item) for _item in obj.get("experiments")] if obj.get("experiments") is not None else None,
            "readme": ProjectInfoResponseAllOfReadme.from_dict(obj.get("readme")) if obj.get("readme") is not None else None,
            "whitelabel_id": obj.get("whitelabelId")
        })
        return _obj

