# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from edgeimpulse_api.models.transformation_job_status_enum import TransformationJobStatusEnum

class OrganizationGetCreateProjectsResponseAllOfJobs(BaseModel):
    id: StrictInt = ...
    organization_id: Optional[StrictInt] = Field(None, alias="organizationId")
    name: StrictStr = ...
    upload_type: StrictStr = Field(..., alias="uploadType")
    transform_job_status: TransformationJobStatusEnum = Field(..., alias="transformJobStatus")
    upload_job_id: Optional[StrictInt] = Field(None, alias="uploadJobId")
    upload_job_status: TransformationJobStatusEnum = Field(..., alias="uploadJobStatus")
    project_owner: Optional[StrictStr] = Field(None, alias="projectOwner")
    project_id: Optional[StrictInt] = Field(None, alias="projectId")
    project_name: Optional[StrictStr] = Field(None, alias="projectName")
    transformation_block_id: Optional[StrictInt] = Field(None, alias="transformationBlockId")
    builtin_transformation_block: Optional[Dict[str, Any]] = Field(None, alias="builtinTransformationBlock")
    transformation_block_name: Optional[StrictStr] = Field(None, alias="transformationBlockName")
    created: datetime = ...
    output_dataset_name: Optional[StrictStr] = Field(None, alias="outputDatasetName")
    total_download_file_count: StrictInt = Field(..., alias="totalDownloadFileCount")
    total_download_file_size: StrictInt = Field(..., alias="totalDownloadFileSize")
    total_download_file_size_string: StrictStr = Field(..., alias="totalDownloadFileSizeString")
    total_upload_file_count: Optional[StrictInt] = Field(None, alias="totalUploadFileCount")
    __properties = ["id", "organizationId", "name", "uploadType", "transformJobStatus", "uploadJobId", "uploadJobStatus", "projectOwner", "projectId", "projectName", "transformationBlockId", "builtinTransformationBlock", "transformationBlockName", "created", "outputDatasetName", "totalDownloadFileCount", "totalDownloadFileSize", "totalDownloadFileSizeString", "totalUploadFileCount"]

    @validator('upload_type')
    def upload_type_validate_enum(cls, v):
        if v not in ('dataset', 'project'):
            raise ValueError("must validate the enum values ('dataset', 'project')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationGetCreateProjectsResponseAllOfJobs:
        """Create an instance of OrganizationGetCreateProjectsResponseAllOfJobs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationGetCreateProjectsResponseAllOfJobs:
        """Create an instance of OrganizationGetCreateProjectsResponseAllOfJobs from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationGetCreateProjectsResponseAllOfJobs.parse_obj(obj)

        _obj = OrganizationGetCreateProjectsResponseAllOfJobs.parse_obj({
            "id": obj.get("id"),
            "organization_id": obj.get("organizationId"),
            "name": obj.get("name"),
            "upload_type": obj.get("uploadType"),
            "transform_job_status": obj.get("transformJobStatus"),
            "upload_job_id": obj.get("uploadJobId"),
            "upload_job_status": obj.get("uploadJobStatus"),
            "project_owner": obj.get("projectOwner"),
            "project_id": obj.get("projectId"),
            "project_name": obj.get("projectName"),
            "transformation_block_id": obj.get("transformationBlockId"),
            "builtin_transformation_block": obj.get("builtinTransformationBlock"),
            "transformation_block_name": obj.get("transformationBlockName"),
            "created": obj.get("created"),
            "output_dataset_name": obj.get("outputDatasetName"),
            "total_download_file_count": obj.get("totalDownloadFileCount"),
            "total_download_file_size": obj.get("totalDownloadFileSize"),
            "total_download_file_size_string": obj.get("totalDownloadFileSizeString"),
            "total_upload_file_count": obj.get("totalUploadFileCount")
        })
        return _obj

