# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator

class OrganizationDeployBlock(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    docker_container: StrictStr = Field(..., alias="dockerContainer")
    docker_container_managed_by_edge_impulse: StrictBool = Field(..., alias="dockerContainerManagedByEdgeImpulse")
    created: datetime = ...
    user_id: Optional[StrictInt] = Field(None, alias="userId")
    user_name: Optional[StrictStr] = Field(None, alias="userName")
    description: StrictStr = ...
    cli_arguments: StrictStr = Field(..., alias="cliArguments", description="These arguments are passed into the container")
    requests_cpu: Optional[float] = Field(None, alias="requestsCpu")
    requests_memory: Optional[StrictInt] = Field(None, alias="requestsMemory")
    limits_cpu: Optional[float] = Field(None, alias="limitsCpu")
    limits_memory: Optional[StrictInt] = Field(None, alias="limitsMemory")
    photo: StrictStr = ...
    integrate_url: Optional[StrictStr] = Field(None, alias="integrateUrl")
    privileged: StrictBool = ...
    mount_learn_block: StrictBool = Field(..., alias="mountLearnBlock")
    supports_eon_compiler: StrictBool = Field(..., alias="supportsEonCompiler")
    show_optimizations: StrictBool = Field(..., alias="showOptimizations")
    category: StrictStr = ...
    __properties = ["id", "name", "dockerContainer", "dockerContainerManagedByEdgeImpulse", "created", "userId", "userName", "description", "cliArguments", "requestsCpu", "requestsMemory", "limitsCpu", "limitsMemory", "photo", "integrateUrl", "privileged", "mountLearnBlock", "supportsEonCompiler", "showOptimizations", "category"]

    @validator('category')
    def category_validate_enum(cls, v):
        if v not in ('library', 'firmware'):
            raise ValueError("must validate the enum values ('library', 'firmware')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationDeployBlock:
        """Create an instance of OrganizationDeployBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationDeployBlock:
        """Create an instance of OrganizationDeployBlock from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationDeployBlock.parse_obj(obj)

        _obj = OrganizationDeployBlock.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "docker_container": obj.get("dockerContainer"),
            "docker_container_managed_by_edge_impulse": obj.get("dockerContainerManagedByEdgeImpulse"),
            "created": obj.get("created"),
            "user_id": obj.get("userId"),
            "user_name": obj.get("userName"),
            "description": obj.get("description"),
            "cli_arguments": obj.get("cliArguments"),
            "requests_cpu": obj.get("requestsCpu"),
            "requests_memory": obj.get("requestsMemory"),
            "limits_cpu": obj.get("limitsCpu"),
            "limits_memory": obj.get("limitsMemory"),
            "photo": obj.get("photo"),
            "integrate_url": obj.get("integrateUrl"),
            "privileged": obj.get("privileged"),
            "mount_learn_block": obj.get("mountLearnBlock"),
            "supports_eon_compiler": obj.get("supportsEonCompiler"),
            "show_optimizations": obj.get("showOptimizations"),
            "category": obj.get("category")
        })
        return _obj

