# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator
from edgeimpulse_api.models.get_user_response_all_of_whitelabels import GetUserResponseAllOfWhitelabels
from edgeimpulse_api.models.project import Project
from edgeimpulse_api.models.user_experiment import UserExperiment
from edgeimpulse_api.models.user_organization import UserOrganization

class GetUserResponseAllOf(BaseModel):
    email: StrictStr = ...
    activated: StrictBool = ...
    organizations: List[UserOrganization] = Field(..., description="Organizations that the user is a member of. Only filled when requesting information about yourself.")
    projects: List[Project] = ...
    experiments: List[UserExperiment] = Field(..., description="Experiments the user has access to. Enabling experiments can only be done through a JWT token.")
    evaluation: Optional[StrictBool] = Field(None, description="Whether this is an ephemeral evaluation account.")
    ambassador: Optional[StrictBool] = Field(None, description="Whether this user is an ambassador.")
    show_imagine2022: StrictBool = Field(..., alias="showImagine2022", description="Whether to show the Imagine 2022 banner.")
    tier: StrictStr = Field(..., description="The user account tier.")
    whitelabels: Optional[List[GetUserResponseAllOfWhitelabels]] = Field(None, description="List of white labels the user is a member of")
    __properties = ["email", "activated", "organizations", "projects", "experiments", "evaluation", "ambassador", "showImagine2022", "tier", "whitelabels"]

    @validator('tier')
    def tier_validate_enum(cls, v):
        if v not in ('free', 'pro'):
            raise ValueError("must validate the enum values ('free', 'pro')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetUserResponseAllOf:
        """Create an instance of GetUserResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in organizations (list)
        _items = []
        if self.organizations:
            for _item in self.organizations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['organizations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item in self.projects:
                if _item:
                    _items.append(_item.to_dict())
            _dict['projects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in experiments (list)
        _items = []
        if self.experiments:
            for _item in self.experiments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['experiments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in whitelabels (list)
        _items = []
        if self.whitelabels:
            for _item in self.whitelabels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['whitelabels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetUserResponseAllOf:
        """Create an instance of GetUserResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetUserResponseAllOf.parse_obj(obj)

        _obj = GetUserResponseAllOf.parse_obj({
            "email": obj.get("email"),
            "activated": obj.get("activated"),
            "organizations": [UserOrganization.from_dict(_item) for _item in obj.get("organizations")] if obj.get("organizations") is not None else None,
            "projects": [Project.from_dict(_item) for _item in obj.get("projects")] if obj.get("projects") is not None else None,
            "experiments": [UserExperiment.from_dict(_item) for _item in obj.get("experiments")] if obj.get("experiments") is not None else None,
            "evaluation": obj.get("evaluation"),
            "ambassador": obj.get("ambassador"),
            "show_imagine2022": obj.get("showImagine2022"),
            "tier": obj.get("tier"),
            "whitelabels": [GetUserResponseAllOfWhitelabels.from_dict(_item) for _item in obj.get("whitelabels")] if obj.get("whitelabels") is not None else None
        })
        return _obj

