# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class GetJWTTokenRequest(BaseModel):
    username: StrictStr = Field(..., description="Username or e-mail address")
    password: StrictStr = Field(..., description="Password")
    uuid: Optional[StrictStr] = Field(None, description="Evaluation user UUID")
    sso_type: Optional[StrictStr] = Field(None, alias="ssoType")
    session_id: Optional[StrictStr] = Field(None, alias="sessionId", description="Session ID")
    __properties = ["username", "password", "uuid", "ssoType", "sessionId"]

    @validator('sso_type')
    def sso_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('browser', 'cli'):
            raise ValueError("must validate the enum values ('browser', 'cli')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetJWTTokenRequest:
        """Create an instance of GetJWTTokenRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetJWTTokenRequest:
        """Create an instance of GetJWTTokenRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetJWTTokenRequest.parse_obj(obj)

        _obj = GetJWTTokenRequest.parse_obj({
            "username": obj.get("username"),
            "password": obj.get("password"),
            "uuid": obj.get("uuid"),
            "sso_type": obj.get("ssoType"),
            "session_id": obj.get("sessionId")
        })
        return _obj

