# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.dsp_metadata_included_samples_inner import DSPMetadataIncludedSamplesInner
from edgeimpulse_api.models.dsp_metadata_output_config import DSPMetadataOutputConfig

class DSPMetadata(BaseModel):
    created: datetime = Field(..., description="Date when the features were created")
    dsp_config: Dict[str, StrictStr] = Field(..., alias="dspConfig")
    labels: List[StrictStr] = Field(..., description="Labels in the dataset when generator ran")
    feature_labels: Optional[List[StrictStr]] = Field(None, alias="featureLabels", description="Names of the generated features. Only set if axes have explicit labels.")
    window_count: StrictInt = Field(..., alias="windowCount")
    feature_count: StrictInt = Field(..., alias="featureCount", description="Number of features for this DSP block")
    included_samples: List[DSPMetadataIncludedSamplesInner] = Field(..., alias="includedSamples", description="The included samples in this DSP block. Note that these are sorted in the same way as the `npy` files are laid out. So with the `windowCount` parameter you can exactly search back to see which file contributed to which windows there.")
    window_size_ms: StrictInt = Field(..., alias="windowSizeMs", description="Length of the sliding window when generating features.")
    window_increase_ms: StrictInt = Field(..., alias="windowIncreaseMs", description="Increase of the sliding window when generating features.")
    pad_zeros: StrictBool = Field(..., alias="padZeros", description="Whether data was zero-padded when generating features.")
    frequency: float = Field(..., description="Frequency of the original data in Hz.")
    output_config: DSPMetadataOutputConfig = Field(..., alias="outputConfig")
    fft_used: Optional[List[StrictInt]] = Field(None, alias="fftUsed")
    __properties = ["created", "dspConfig", "labels", "featureLabels", "windowCount", "featureCount", "includedSamples", "windowSizeMs", "windowIncreaseMs", "padZeros", "frequency", "outputConfig", "fftUsed"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DSPMetadata:
        """Create an instance of DSPMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in included_samples (list)
        _items = []
        if self.included_samples:
            for _item in self.included_samples:
                if _item:
                    _items.append(_item.to_dict())
            _dict['includedSamples'] = _items
        # override the default output from pydantic by calling `to_dict()` of output_config
        if self.output_config:
            _dict['outputConfig'] = self.output_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DSPMetadata:
        """Create an instance of DSPMetadata from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DSPMetadata.parse_obj(obj)

        _obj = DSPMetadata.parse_obj({
            "created": obj.get("created"),
            "dsp_config": obj.get("dspConfig"),
            "labels": obj.get("labels"),
            "feature_labels": obj.get("featureLabels"),
            "window_count": obj.get("windowCount"),
            "feature_count": obj.get("featureCount"),
            "included_samples": [DSPMetadataIncludedSamplesInner.from_dict(_item) for _item in obj.get("includedSamples")] if obj.get("includedSamples") is not None else None,
            "window_size_ms": obj.get("windowSizeMs"),
            "window_increase_ms": obj.get("windowIncreaseMs"),
            "pad_zeros": obj.get("padZeros"),
            "frequency": obj.get("frequency"),
            "output_config": DSPMetadataOutputConfig.from_dict(obj.get("outputConfig")) if obj.get("outputConfig") is not None else None,
            "fft_used": obj.get("fftUsed")
        })
        return _obj

